/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.InvtrySpecialStockValnType_2Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.InvtrySpecialStockValnType_2Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Inventory Special Stock Valuation Type (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>InvtrySpecialStockValnType_2</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InvtrySpecialStockValnType_2 extends VdmEntity<InvtrySpecialStockValnType_2>
{

    /**
     * Selector for all available fields of InvtrySpecialStockValnType_2.
     *
     */
    public final static InvtrySpecialStockValnType_2Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpecialStockValnType_2_ID</b>
     * </p>
     *
     * @return Inventory Special Stock Valuation Type
     */
    @Key
    @SerializedName( "InvtrySpecialStockValnType_2_ID" )
    @JsonProperty( "InvtrySpecialStockValnType_2_ID" )
    @Nullable
    @ODataField( odataName = "InvtrySpecialStockValnType_2_ID" )
    private String invtrySpecialStockValnType_2_ID;
    /**
     * Use with available fluent helpers to apply the <b>InvtrySpecialStockValnType_2_ID</b> field to query operations.
     *
     */
    public final static InvtrySpecialStockValnType_2Field<String> INVTRY_SPECIAL_STOCK_VALN_TYPE_2_I_D =
        new InvtrySpecialStockValnType_2Field<String>("InvtrySpecialStockValnType_2_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpecialStockValnType_2Text</b>
     * </p>
     *
     * @return Inventory Special Stock Valuation Type (Description)
     */
    @SerializedName( "InvtrySpecialStockValnType_2Text" )
    @JsonProperty( "InvtrySpecialStockValnType_2Text" )
    @Nullable
    @ODataField( odataName = "InvtrySpecialStockValnType_2Text" )
    private String invtrySpecialStockValnType_2Text;
    /**
     * Use with available fluent helpers to apply the <b>InvtrySpecialStockValnType_2Text</b> field to query operations.
     *
     */
    public final static InvtrySpecialStockValnType_2Field<String> INVTRY_SPECIAL_STOCK_VALN_TYPE_2_TEXT =
        new InvtrySpecialStockValnType_2Field<String>("InvtrySpecialStockValnType_2Text");

    @Nonnull
    @Override
    public Class<InvtrySpecialStockValnType_2> getType()
    {
        return InvtrySpecialStockValnType_2.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpecialStockValnType_2_ID</b>
     * </p>
     *
     * @param invtrySpecialStockValnType_2_ID
     *            Inventory Special Stock Valuation Type
     */
    public void setInvtrySpecialStockValnType_2_ID( @Nullable final String invtrySpecialStockValnType_2_ID )
    {
        rememberChangedField("InvtrySpecialStockValnType_2_ID", this.invtrySpecialStockValnType_2_ID);
        this.invtrySpecialStockValnType_2_ID = invtrySpecialStockValnType_2_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpecialStockValnType_2Text</b>
     * </p>
     *
     * @param invtrySpecialStockValnType_2Text
     *            Inventory Special Stock Valuation Type (Description)
     */
    public void setInvtrySpecialStockValnType_2Text( @Nullable final String invtrySpecialStockValnType_2Text )
    {
        rememberChangedField("InvtrySpecialStockValnType_2Text", this.invtrySpecialStockValnType_2Text);
        this.invtrySpecialStockValnType_2Text = invtrySpecialStockValnType_2Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "InvtrySpecialStockValnType_2";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InvtrySpecialStockValnType_2_ID", getInvtrySpecialStockValnType_2_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InvtrySpecialStockValnType_2_ID", getInvtrySpecialStockValnType_2_ID());
        values.put("InvtrySpecialStockValnType_2Text", getInvtrySpecialStockValnType_2Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InvtrySpecialStockValnType_2_ID") ) {
                final Object value = values.remove("InvtrySpecialStockValnType_2_ID");
                if( (value == null) || (!value.equals(getInvtrySpecialStockValnType_2_ID())) ) {
                    setInvtrySpecialStockValnType_2_ID(((String) value));
                }
            }
            if( values.containsKey("InvtrySpecialStockValnType_2Text") ) {
                final Object value = values.remove("InvtrySpecialStockValnType_2Text");
                if( (value == null) || (!value.equals(getInvtrySpecialStockValnType_2Text())) ) {
                    setInvtrySpecialStockValnType_2Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> InvtrySpecialStockValnType_2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new InvtrySpecialStockValnType_2Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InvtrySpecialStockValnType_2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InvtrySpecialStockValnType_2Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
