/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.InvtrySpecialStockValnType_2Selectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpecialStockValnType_2
 * InvtrySpecialStockValnType_2} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class InvtrySpecialStockValnType_2ByKeyFluentHelper
    extends
    FluentHelperByKey<InvtrySpecialStockValnType_2ByKeyFluentHelper, InvtrySpecialStockValnType_2, InvtrySpecialStockValnType_2Selectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpecialStockValnType_2
     * InvtrySpecialStockValnType_2} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code InvtrySpecialStockValnType_2}
     * @param servicePath
     *            Service path to be used to fetch a single {@code InvtrySpecialStockValnType_2}
     * @param invtrySpecialStockValnType_2_ID
     *            Inventory Special Stock Valuation Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     */
    public InvtrySpecialStockValnType_2ByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String invtrySpecialStockValnType_2_ID )
    {
        super(servicePath, entityCollection);
        this.key.put("InvtrySpecialStockValnType_2_ID", invtrySpecialStockValnType_2_ID);
    }

    @Override
    @Nonnull
    protected Class<InvtrySpecialStockValnType_2> getEntityClass()
    {
        return InvtrySpecialStockValnType_2.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
