/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.IsBalanceSheetAccountField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.IsBalanceSheetAccountSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Balance sheet acct (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>IsBalanceSheetAccount</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class IsBalanceSheetAccount extends VdmEntity<IsBalanceSheetAccount>
{

    /**
     * Selector for all available fields of IsBalanceSheetAccount.
     *
     */
    public final static IsBalanceSheetAccountSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBalanceSheetAccount_ID</b>
     * </p>
     *
     * @return Balance sheet acct
     */
    @Key
    @SerializedName( "IsBalanceSheetAccount_ID" )
    @JsonProperty( "IsBalanceSheetAccount_ID" )
    @Nullable
    @ODataField( odataName = "IsBalanceSheetAccount_ID" )
    private String isBalanceSheetAccount_ID;
    /**
     * Use with available fluent helpers to apply the <b>IsBalanceSheetAccount_ID</b> field to query operations.
     *
     */
    public final static IsBalanceSheetAccountField<String> IS_BALANCE_SHEET_ACCOUNT_ID =
        new IsBalanceSheetAccountField<String>("IsBalanceSheetAccount_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBalanceSheetAccountText</b>
     * </p>
     *
     * @return Balance sheet acct (Description)
     */
    @SerializedName( "IsBalanceSheetAccountText" )
    @JsonProperty( "IsBalanceSheetAccountText" )
    @Nullable
    @ODataField( odataName = "IsBalanceSheetAccountText" )
    private String isBalanceSheetAccountText;
    /**
     * Use with available fluent helpers to apply the <b>IsBalanceSheetAccountText</b> field to query operations.
     *
     */
    public final static IsBalanceSheetAccountField<String> IS_BALANCE_SHEET_ACCOUNT_TEXT =
        new IsBalanceSheetAccountField<String>("IsBalanceSheetAccountText");

    @Nonnull
    @Override
    public Class<IsBalanceSheetAccount> getType()
    {
        return IsBalanceSheetAccount.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBalanceSheetAccount_ID</b>
     * </p>
     *
     * @param isBalanceSheetAccount_ID
     *            Balance sheet acct
     */
    public void setIsBalanceSheetAccount_ID( @Nullable final String isBalanceSheetAccount_ID )
    {
        rememberChangedField("IsBalanceSheetAccount_ID", this.isBalanceSheetAccount_ID);
        this.isBalanceSheetAccount_ID = isBalanceSheetAccount_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBalanceSheetAccountText</b>
     * </p>
     *
     * @param isBalanceSheetAccountText
     *            Balance sheet acct (Description)
     */
    public void setIsBalanceSheetAccountText( @Nullable final String isBalanceSheetAccountText )
    {
        rememberChangedField("IsBalanceSheetAccountText", this.isBalanceSheetAccountText);
        this.isBalanceSheetAccountText = isBalanceSheetAccountText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "IsBalanceSheetAccount";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("IsBalanceSheetAccount_ID", getIsBalanceSheetAccount_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("IsBalanceSheetAccount_ID", getIsBalanceSheetAccount_ID());
        values.put("IsBalanceSheetAccountText", getIsBalanceSheetAccountText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("IsBalanceSheetAccount_ID") ) {
                final Object value = values.remove("IsBalanceSheetAccount_ID");
                if( (value == null) || (!value.equals(getIsBalanceSheetAccount_ID())) ) {
                    setIsBalanceSheetAccount_ID(((String) value));
                }
            }
            if( values.containsKey("IsBalanceSheetAccountText") ) {
                final Object value = values.remove("IsBalanceSheetAccountText");
                if( (value == null) || (!value.equals(getIsBalanceSheetAccountText())) ) {
                    setIsBalanceSheetAccountText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> IsBalanceSheetAccountField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new IsBalanceSheetAccountField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> IsBalanceSheetAccountField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new IsBalanceSheetAccountField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
