/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.IsOpenItemManagedField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.IsOpenItemManagedSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Open Item Management (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>IsOpenItemManaged</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class IsOpenItemManaged extends VdmEntity<IsOpenItemManaged>
{

    /**
     * Selector for all available fields of IsOpenItemManaged.
     *
     */
    public final static IsOpenItemManagedSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsOpenItemManaged_ID</b>
     * </p>
     *
     * @return Open Item Management
     */
    @Key
    @SerializedName( "IsOpenItemManaged_ID" )
    @JsonProperty( "IsOpenItemManaged_ID" )
    @Nullable
    @ODataField( odataName = "IsOpenItemManaged_ID" )
    private String isOpenItemManaged_ID;
    /**
     * Use with available fluent helpers to apply the <b>IsOpenItemManaged_ID</b> field to query operations.
     *
     */
    public final static IsOpenItemManagedField<String> IS_OPEN_ITEM_MANAGED_ID =
        new IsOpenItemManagedField<String>("IsOpenItemManaged_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsOpenItemManagedText</b>
     * </p>
     *
     * @return Open Item Management (Description)
     */
    @SerializedName( "IsOpenItemManagedText" )
    @JsonProperty( "IsOpenItemManagedText" )
    @Nullable
    @ODataField( odataName = "IsOpenItemManagedText" )
    private String isOpenItemManagedText;
    /**
     * Use with available fluent helpers to apply the <b>IsOpenItemManagedText</b> field to query operations.
     *
     */
    public final static IsOpenItemManagedField<String> IS_OPEN_ITEM_MANAGED_TEXT =
        new IsOpenItemManagedField<String>("IsOpenItemManagedText");

    @Nonnull
    @Override
    public Class<IsOpenItemManaged> getType()
    {
        return IsOpenItemManaged.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsOpenItemManaged_ID</b>
     * </p>
     *
     * @param isOpenItemManaged_ID
     *            Open Item Management
     */
    public void setIsOpenItemManaged_ID( @Nullable final String isOpenItemManaged_ID )
    {
        rememberChangedField("IsOpenItemManaged_ID", this.isOpenItemManaged_ID);
        this.isOpenItemManaged_ID = isOpenItemManaged_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsOpenItemManagedText</b>
     * </p>
     *
     * @param isOpenItemManagedText
     *            Open Item Management (Description)
     */
    public void setIsOpenItemManagedText( @Nullable final String isOpenItemManagedText )
    {
        rememberChangedField("IsOpenItemManagedText", this.isOpenItemManagedText);
        this.isOpenItemManagedText = isOpenItemManagedText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "IsOpenItemManaged";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("IsOpenItemManaged_ID", getIsOpenItemManaged_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("IsOpenItemManaged_ID", getIsOpenItemManaged_ID());
        values.put("IsOpenItemManagedText", getIsOpenItemManagedText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("IsOpenItemManaged_ID") ) {
                final Object value = values.remove("IsOpenItemManaged_ID");
                if( (value == null) || (!value.equals(getIsOpenItemManaged_ID())) ) {
                    setIsOpenItemManaged_ID(((String) value));
                }
            }
            if( values.containsKey("IsOpenItemManagedText") ) {
                final Object value = values.remove("IsOpenItemManagedText");
                if( (value == null) || (!value.equals(getIsOpenItemManagedText())) ) {
                    setIsOpenItemManagedText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> IsOpenItemManagedField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new IsOpenItemManagedField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> IsOpenItemManagedField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new IsOpenItemManagedField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
