/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.IsReversalField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.IsReversalSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Is Reversing (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>IsReversal</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class IsReversal extends VdmEntity<IsReversal>
{

    /**
     * Selector for all available fields of IsReversal.
     *
     */
    public final static IsReversalSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsReversal_ID</b>
     * </p>
     *
     * @return Is Reversing
     */
    @Key
    @SerializedName( "IsReversal_ID" )
    @JsonProperty( "IsReversal_ID" )
    @Nullable
    @ODataField( odataName = "IsReversal_ID" )
    private String isReversal_ID;
    /**
     * Use with available fluent helpers to apply the <b>IsReversal_ID</b> field to query operations.
     *
     */
    public final static IsReversalField<String> IS_REVERSAL_ID = new IsReversalField<String>("IsReversal_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversalText</b>
     * </p>
     *
     * @return Is Reversing (Description)
     */
    @SerializedName( "IsReversalText" )
    @JsonProperty( "IsReversalText" )
    @Nullable
    @ODataField( odataName = "IsReversalText" )
    private String isReversalText;
    /**
     * Use with available fluent helpers to apply the <b>IsReversalText</b> field to query operations.
     *
     */
    public final static IsReversalField<String> IS_REVERSAL_TEXT = new IsReversalField<String>("IsReversalText");

    @Nonnull
    @Override
    public Class<IsReversal> getType()
    {
        return IsReversal.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsReversal_ID</b>
     * </p>
     *
     * @param isReversal_ID
     *            Is Reversing
     */
    public void setIsReversal_ID( @Nullable final String isReversal_ID )
    {
        rememberChangedField("IsReversal_ID", this.isReversal_ID);
        this.isReversal_ID = isReversal_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversalText</b>
     * </p>
     *
     * @param isReversalText
     *            Is Reversing (Description)
     */
    public void setIsReversalText( @Nullable final String isReversalText )
    {
        rememberChangedField("IsReversalText", this.isReversalText);
        this.isReversalText = isReversalText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "IsReversal";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("IsReversal_ID", getIsReversal_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("IsReversal_ID", getIsReversal_ID());
        values.put("IsReversalText", getIsReversalText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("IsReversal_ID") ) {
                final Object value = values.remove("IsReversal_ID");
                if( (value == null) || (!value.equals(getIsReversal_ID())) ) {
                    setIsReversal_ID(((String) value));
                }
            }
            if( values.containsKey("IsReversalText") ) {
                final Object value = values.remove("IsReversalText");
                if( (value == null) || (!value.equals(getIsReversalText())) ) {
                    setIsReversalText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> IsReversalField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new IsReversalField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> IsReversalField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new IsReversalField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
