/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.IsReversedField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.IsReversedSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Is Reversed (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>IsReversed</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class IsReversed extends VdmEntity<IsReversed>
{

    /**
     * Selector for all available fields of IsReversed.
     *
     */
    public final static IsReversedSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsReversed_ID</b>
     * </p>
     *
     * @return Is Reversed
     */
    @Key
    @SerializedName( "IsReversed_ID" )
    @JsonProperty( "IsReversed_ID" )
    @Nullable
    @ODataField( odataName = "IsReversed_ID" )
    private String isReversed_ID;
    /**
     * Use with available fluent helpers to apply the <b>IsReversed_ID</b> field to query operations.
     *
     */
    public final static IsReversedField<String> IS_REVERSED_ID = new IsReversedField<String>("IsReversed_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversedText</b>
     * </p>
     *
     * @return Is Reversed (Description)
     */
    @SerializedName( "IsReversedText" )
    @JsonProperty( "IsReversedText" )
    @Nullable
    @ODataField( odataName = "IsReversedText" )
    private String isReversedText;
    /**
     * Use with available fluent helpers to apply the <b>IsReversedText</b> field to query operations.
     *
     */
    public final static IsReversedField<String> IS_REVERSED_TEXT = new IsReversedField<String>("IsReversedText");

    @Nonnull
    @Override
    public Class<IsReversed> getType()
    {
        return IsReversed.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsReversed_ID</b>
     * </p>
     *
     * @param isReversed_ID
     *            Is Reversed
     */
    public void setIsReversed_ID( @Nullable final String isReversed_ID )
    {
        rememberChangedField("IsReversed_ID", this.isReversed_ID);
        this.isReversed_ID = isReversed_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversedText</b>
     * </p>
     *
     * @param isReversedText
     *            Is Reversed (Description)
     */
    public void setIsReversedText( @Nullable final String isReversedText )
    {
        rememberChangedField("IsReversedText", this.isReversedText);
        this.isReversedText = isReversedText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "IsReversed";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("IsReversed_ID", getIsReversed_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("IsReversed_ID", getIsReversed_ID());
        values.put("IsReversedText", getIsReversedText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("IsReversed_ID") ) {
                final Object value = values.remove("IsReversed_ID");
                if( (value == null) || (!value.equals(getIsReversed_ID())) ) {
                    setIsReversed_ID(((String) value));
                }
            }
            if( values.containsKey("IsReversedText") ) {
                final Object value = values.remove("IsReversedText");
                if( (value == null) || (!value.equals(getIsReversedText())) ) {
                    setIsReversedText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> IsReversedField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new IsReversedField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> IsReversedField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new IsReversedField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
