/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.IsSettledField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.IsSettledSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Is Settled (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>IsSettled</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class IsSettled extends VdmEntity<IsSettled>
{

    /**
     * Selector for all available fields of IsSettled.
     *
     */
    public final static IsSettledSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSettled_ID</b>
     * </p>
     *
     * @return Is Settled
     */
    @Key
    @SerializedName( "IsSettled_ID" )
    @JsonProperty( "IsSettled_ID" )
    @Nullable
    @ODataField( odataName = "IsSettled_ID" )
    private String isSettled_ID;
    /**
     * Use with available fluent helpers to apply the <b>IsSettled_ID</b> field to query operations.
     *
     */
    public final static IsSettledField<String> IS_SETTLED_ID = new IsSettledField<String>("IsSettled_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsSettledText</b>
     * </p>
     *
     * @return Is Settled (Description)
     */
    @SerializedName( "IsSettledText" )
    @JsonProperty( "IsSettledText" )
    @Nullable
    @ODataField( odataName = "IsSettledText" )
    private String isSettledText;
    /**
     * Use with available fluent helpers to apply the <b>IsSettledText</b> field to query operations.
     *
     */
    public final static IsSettledField<String> IS_SETTLED_TEXT = new IsSettledField<String>("IsSettledText");

    @Nonnull
    @Override
    public Class<IsSettled> getType()
    {
        return IsSettled.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSettled_ID</b>
     * </p>
     *
     * @param isSettled_ID
     *            Is Settled
     */
    public void setIsSettled_ID( @Nullable final String isSettled_ID )
    {
        rememberChangedField("IsSettled_ID", this.isSettled_ID);
        this.isSettled_ID = isSettled_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsSettledText</b>
     * </p>
     *
     * @param isSettledText
     *            Is Settled (Description)
     */
    public void setIsSettledText( @Nullable final String isSettledText )
    {
        rememberChangedField("IsSettledText", this.isSettledText);
        this.isSettledText = isSettledText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "IsSettled";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("IsSettled_ID", getIsSettled_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("IsSettled_ID", getIsSettled_ID());
        values.put("IsSettledText", getIsSettledText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("IsSettled_ID") ) {
                final Object value = values.remove("IsSettled_ID");
                if( (value == null) || (!value.equals(getIsSettled_ID())) ) {
                    setIsSettled_ID(((String) value));
                }
            }
            if( values.containsKey("IsSettledText") ) {
                final Object value = values.remove("IsSettledText");
                if( (value == null) || (!value.equals(getIsSettledText())) ) {
                    setIsSettledText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> IsSettledField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new IsSettledField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> IsSettledField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new IsSettledField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
