/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.IsSettlementField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.IsSettlementSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Is Settling (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>IsSettlement</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class IsSettlement extends VdmEntity<IsSettlement>
{

    /**
     * Selector for all available fields of IsSettlement.
     *
     */
    public final static IsSettlementSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSettlement_ID</b>
     * </p>
     *
     * @return Is Settling
     */
    @Key
    @SerializedName( "IsSettlement_ID" )
    @JsonProperty( "IsSettlement_ID" )
    @Nullable
    @ODataField( odataName = "IsSettlement_ID" )
    private String isSettlement_ID;
    /**
     * Use with available fluent helpers to apply the <b>IsSettlement_ID</b> field to query operations.
     *
     */
    public final static IsSettlementField<String> IS_SETTLEMENT_ID = new IsSettlementField<String>("IsSettlement_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsSettlementText</b>
     * </p>
     *
     * @return Is Settling (Description)
     */
    @SerializedName( "IsSettlementText" )
    @JsonProperty( "IsSettlementText" )
    @Nullable
    @ODataField( odataName = "IsSettlementText" )
    private String isSettlementText;
    /**
     * Use with available fluent helpers to apply the <b>IsSettlementText</b> field to query operations.
     *
     */
    public final static IsSettlementField<String> IS_SETTLEMENT_TEXT =
        new IsSettlementField<String>("IsSettlementText");

    @Nonnull
    @Override
    public Class<IsSettlement> getType()
    {
        return IsSettlement.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSettlement_ID</b>
     * </p>
     *
     * @param isSettlement_ID
     *            Is Settling
     */
    public void setIsSettlement_ID( @Nullable final String isSettlement_ID )
    {
        rememberChangedField("IsSettlement_ID", this.isSettlement_ID);
        this.isSettlement_ID = isSettlement_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsSettlementText</b>
     * </p>
     *
     * @param isSettlementText
     *            Is Settling (Description)
     */
    public void setIsSettlementText( @Nullable final String isSettlementText )
    {
        rememberChangedField("IsSettlementText", this.isSettlementText);
        this.isSettlementText = isSettlementText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "IsSettlement";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("IsSettlement_ID", getIsSettlement_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("IsSettlement_ID", getIsSettlement_ID());
        values.put("IsSettlementText", getIsSettlementText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("IsSettlement_ID") ) {
                final Object value = values.remove("IsSettlement_ID");
                if( (value == null) || (!value.equals(getIsSettlement_ID())) ) {
                    setIsSettlement_ID(((String) value));
                }
            }
            if( values.containsKey("IsSettlementText") ) {
                final Object value = values.remove("IsSettlementText");
                if( (value == null) || (!value.equals(getIsSettlementText())) ) {
                    setIsSettlementText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> IsSettlementField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new IsSettlementField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> IsSettlementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new IsSettlementField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
