/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.IsSettlementResultField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.IsSettlementResultSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Is Settling (Booked Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>IsSettlementResult</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class IsSettlementResult extends VdmEntity<IsSettlementResult>
{

    /**
     * Selector for all available fields of IsSettlementResult.
     *
     */
    public final static IsSettlementResultSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSettlement</b>
     * </p>
     *
     * @return Is Settling
     */
    @Key
    @SerializedName( "IsSettlement" )
    @JsonProperty( "IsSettlement" )
    @Nullable
    @ODataField( odataName = "IsSettlement" )
    private String isSettlement;
    /**
     * Use with available fluent helpers to apply the <b>IsSettlement</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> IS_SETTLEMENT =
        new IsSettlementResultField<String>("IsSettlement");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> COMPANY_CODE =
        new IsSettlementResultField<String>("CompanyCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @return Company Code (Description)
     */
    @SerializedName( "CompanyCodeName" )
    @JsonProperty( "CompanyCodeName" )
    @Nullable
    @ODataField( odataName = "CompanyCodeName" )
    private String companyCodeName;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> COMPANY_CODE_NAME =
        new IsSettlementResultField<String>("CompanyCodeName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> GL_ACCOUNT = new IsSettlementResultField<String>("GLAccount");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountHierarchyName</b>
     * </p>
     *
     * @return G/L Account (Description)
     */
    @SerializedName( "GLAccountHierarchyName" )
    @JsonProperty( "GLAccountHierarchyName" )
    @Nullable
    @ODataField( odataName = "GLAccountHierarchyName" )
    private String gLAccountHierarchyName;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountHierarchyName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> GL_ACCOUNT_HIERARCHY_NAME =
        new IsSettlementResultField<String>("GLAccountHierarchyName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @return Business Process
     */
    @SerializedName( "BusinessProcess" )
    @JsonProperty( "BusinessProcess" )
    @Nullable
    @ODataField( odataName = "BusinessProcess" )
    private String businessProcess;
    /**
     * Use with available fluent helpers to apply the <b>BusinessProcess</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> BUSINESS_PROCESS =
        new IsSettlementResultField<String>("BusinessProcess");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency8</b>
     * </p>
     *
     * @return Freely Defined Currency 8
     */
    @SerializedName( "FreeDefinedCurrency8" )
    @JsonProperty( "FreeDefinedCurrency8" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency8" )
    private String freeDefinedCurrency8;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency8</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FREE_DEFINED_CURRENCY8 =
        new IsSettlementResultField<String>("FreeDefinedCurrency8");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostObject</b>
     * </p>
     *
     * @return Partner Cost Object
     */
    @SerializedName( "PartnerCostObject" )
    @JsonProperty( "PartnerCostObject" )
    @Nullable
    @ODataField( odataName = "PartnerCostObject" )
    private String partnerCostObject;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCostObject</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_COST_OBJECT =
        new IsSettlementResultField<String>("PartnerCostObject");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AssetValueDate</b>
     * </p>
     *
     * @return Asset Value Date
     */
    @SerializedName( "AssetValueDate" )
    @JsonProperty( "AssetValueDate" )
    @Nullable
    @ODataField( odataName = "AssetValueDate" )
    private String assetValueDate;
    /**
     * Use with available fluent helpers to apply the <b>AssetValueDate</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ASSET_VALUE_DATE =
        new IsSettlementResultField<String>("AssetValueDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AssetValueDate_T</b>
     * </p>
     *
     * @return Asset Value Date (Description)
     */
    @SerializedName( "AssetValueDate_T" )
    @JsonProperty( "AssetValueDate_T" )
    @Nullable
    @ODataField( odataName = "AssetValueDate_T" )
    private String assetValueDate_T;
    /**
     * Use with available fluent helpers to apply the <b>AssetValueDate_T</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ASSET_VALUE_DATE_T =
        new IsSettlementResultField<String>("AssetValueDate_T");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearPeriod</b>
     * </p>
     *
     * @return Fiscal Year Period
     */
    @SerializedName( "FiscalYearPeriod" )
    @JsonProperty( "FiscalYearPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalYearPeriod" )
    private String fiscalYearPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearPeriod</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FISCAL_YEAR_PERIOD =
        new IsSettlementResultField<String>("FiscalYearPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsIncomplete</b>
     * </p>
     *
     * @return Qty Is Incomplete
     */
    @SerializedName( "QuantityIsIncomplete" )
    @JsonProperty( "QuantityIsIncomplete" )
    @Nullable
    @ODataField( odataName = "QuantityIsIncomplete" )
    private String quantityIsIncomplete;
    /**
     * Use with available fluent helpers to apply the <b>QuantityIsIncomplete</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> QUANTITY_IS_INCOMPLETE =
        new IsSettlementResultField<String>("QuantityIsIncomplete");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsOpenItemManaged</b>
     * </p>
     *
     * @return Open Item Management
     */
    @SerializedName( "IsOpenItemManaged" )
    @JsonProperty( "IsOpenItemManaged" )
    @Nullable
    @ODataField( odataName = "IsOpenItemManaged" )
    private String isOpenItemManaged;
    /**
     * Use with available fluent helpers to apply the <b>IsOpenItemManaged</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> IS_OPEN_ITEM_MANAGED =
        new IsSettlementResultField<String>("IsOpenItemManaged");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupAccount</b>
     * </p>
     *
     * @return Group Account Number
     */
    @SerializedName( "CorporateGroupAccount" )
    @JsonProperty( "CorporateGroupAccount" )
    @Nullable
    @ODataField( odataName = "CorporateGroupAccount" )
    private String corporateGroupAccount;
    /**
     * Use with available fluent helpers to apply the <b>CorporateGroupAccount</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CORPORATE_GROUP_ACCOUNT =
        new IsSettlementResultField<String>("CorporateGroupAccount");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupAccount_T</b>
     * </p>
     *
     * @return Group Account Number (Description)
     */
    @SerializedName( "CorporateGroupAccount_T" )
    @JsonProperty( "CorporateGroupAccount_T" )
    @Nullable
    @ODataField( odataName = "CorporateGroupAccount_T" )
    private String corporateGroupAccount_T;
    /**
     * Use with available fluent helpers to apply the <b>CorporateGroupAccount_T</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CORPORATE_GROUP_ACCOUNT_T =
        new IsSettlementResultField<String>("CorporateGroupAccount_T");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentType</b>
     * </p>
     *
     * @return Billing Type
     */
    @SerializedName( "BillingDocumentType" )
    @JsonProperty( "BillingDocumentType" )
    @Nullable
    @ODataField( odataName = "BillingDocumentType" )
    private String billingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> BILLING_DOCUMENT_TYPE =
        new IsSettlementResultField<String>("BillingDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FiscalQuarter</b>
     * </p>
     *
     * @return Fiscal Quarter
     */
    @SerializedName( "FiscalQuarter" )
    @JsonProperty( "FiscalQuarter" )
    @Nullable
    @ODataField( odataName = "FiscalQuarter" )
    private String fiscalQuarter;
    /**
     * Use with available fluent helpers to apply the <b>FiscalQuarter</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FISCAL_QUARTER =
        new IsSettlementResultField<String>("FiscalQuarter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupChartOfAccounts</b>
     * </p>
     *
     * @return Group Chart of Accts
     */
    @SerializedName( "CorporateGroupChartOfAccounts" )
    @JsonProperty( "CorporateGroupChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "CorporateGroupChartOfAccounts" )
    private String corporateGroupChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>CorporateGroupChartOfAccounts</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CORPORATE_GROUP_CHART_OF_ACCOUNTS =
        new IsSettlementResultField<String>("CorporateGroupChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDocFiscalYear</b>
     * </p>
     *
     * @return Fiscal Year of Clearing JE (Depr.)
     */
    @SerializedName( "ClearingDocFiscalYear" )
    @JsonProperty( "ClearingDocFiscalYear" )
    @Nullable
    @ODataField( odataName = "ClearingDocFiscalYear" )
    private String clearingDocFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>ClearingDocFiscalYear</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CLEARING_DOC_FISCAL_YEAR =
        new IsSettlementResultField<String>("ClearingDocFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElement</b>
     * </p>
     *
     * @return Partner WBS Element
     */
    @SerializedName( "PartnerWBSElement" )
    @JsonProperty( "PartnerWBSElement" )
    @Nullable
    @ODataField( odataName = "PartnerWBSElement" )
    private String partnerWBSElement;
    /**
     * Use with available fluent helpers to apply the <b>PartnerWBSElement</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_WBS_ELEMENT =
        new IsSettlementResultField<String>("PartnerWBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency2</b>
     * </p>
     *
     * @return Freely Defined Currency 2
     */
    @SerializedName( "FreeDefinedCurrency2" )
    @JsonProperty( "FreeDefinedCurrency2" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency2" )
    private String freeDefinedCurrency2;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency2</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FREE_DEFINED_CURRENCY2 =
        new IsSettlementResultField<String>("FreeDefinedCurrency2");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenter</b>
     * </p>
     *
     * @return Partner Profit Center
     */
    @SerializedName( "PartnerProfitCenter" )
    @JsonProperty( "PartnerProfitCenter" )
    @Nullable
    @ODataField( odataName = "PartnerProfitCenter" )
    private String partnerProfitCenter;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProfitCenter</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_PROFIT_CENTER =
        new IsSettlementResultField<String>("PartnerProfitCenter");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenterName</b>
     * </p>
     *
     * @return Partner Profit Center (Description)
     */
    @SerializedName( "PartnerProfitCenterName" )
    @JsonProperty( "PartnerProfitCenterName" )
    @Nullable
    @ODataField( odataName = "PartnerProfitCenterName" )
    private String partnerProfitCenterName;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProfitCenterName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_PROFIT_CENTER_NAME =
        new IsSettlementResultField<String>("PartnerProfitCenterName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerControllingObjectClass</b>
     * </p>
     *
     * @return Partner Controlling Object Class
     */
    @SerializedName( "PartnerControllingObjectClass" )
    @JsonProperty( "PartnerControllingObjectClass" )
    @Nullable
    @ODataField( odataName = "PartnerControllingObjectClass" )
    private String partnerControllingObjectClass;
    /**
     * Use with available fluent helpers to apply the <b>PartnerControllingObjectClass</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_CONTROLLING_OBJECT_CLASS =
        new IsSettlementResultField<String>("PartnerControllingObjectClass");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountType</b>
     * </p>
     *
     * @return G/L Account Type
     */
    @SerializedName( "GLAccountType" )
    @JsonProperty( "GLAccountType" )
    @Nullable
    @ODataField( odataName = "GLAccountType" )
    private String gLAccountType;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> GL_ACCOUNT_TYPE =
        new IsSettlementResultField<String>("GLAccountType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCategory</b>
     * </p>
     *
     * @return Journal Entry Category
     */
    @SerializedName( "AccountingDocumentCategory" )
    @JsonProperty( "AccountingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentCategory" )
    private String accountingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentCategory</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ACCOUNTING_DOCUMENT_CATEGORY =
        new IsSettlementResultField<String>("AccountingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessTransactionType</b>
     * </p>
     *
     * @return Business Transaction Type
     */
    @SerializedName( "BusinessTransactionType" )
    @JsonProperty( "BusinessTransactionType" )
    @Nullable
    @ODataField( odataName = "BusinessTransactionType" )
    private String businessTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>BusinessTransactionType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> BUSINESS_TRANSACTION_TYPE =
        new IsSettlementResultField<String>("BusinessTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CalendarMonth</b>
     * </p>
     *
     * @return Calendar Month
     */
    @SerializedName( "CalendarMonth" )
    @JsonProperty( "CalendarMonth" )
    @Nullable
    @ODataField( odataName = "CalendarMonth" )
    private String calendarMonth;
    /**
     * Use with available fluent helpers to apply the <b>CalendarMonth</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CALENDAR_MONTH =
        new IsSettlementResultField<String>("CalendarMonth");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CalendarQuarter</b>
     * </p>
     *
     * @return Calendar Quarter
     */
    @SerializedName( "CalendarQuarter" )
    @JsonProperty( "CalendarQuarter" )
    @Nullable
    @ODataField( odataName = "CalendarQuarter" )
    private String calendarQuarter;
    /**
     * Use with available fluent helpers to apply the <b>CalendarQuarter</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CALENDAR_QUARTER =
        new IsSettlementResultField<String>("CalendarQuarter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingAccountingDocument</b>
     * </p>
     *
     * @return Clearing Journal Entry (Deprecated)
     */
    @SerializedName( "ClearingAccountingDocument" )
    @JsonProperty( "ClearingAccountingDocument" )
    @Nullable
    @ODataField( odataName = "ClearingAccountingDocument" )
    private String clearingAccountingDocument;
    /**
     * Use with available fluent helpers to apply the <b>ClearingAccountingDocument</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CLEARING_ACCOUNTING_DOCUMENT =
        new IsSettlementResultField<String>("ClearingAccountingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentType</b>
     * </p>
     *
     * @return Journal Entry Type
     */
    @SerializedName( "AccountingDocumentType" )
    @JsonProperty( "AccountingDocumentType" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentType" )
    private String accountingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ACCOUNTING_DOCUMENT_TYPE =
        new IsSettlementResultField<String>("AccountingDocumentType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentTypeName</b>
     * </p>
     *
     * @return Journal Entry Type (Description)
     */
    @SerializedName( "AccountingDocumentTypeName" )
    @JsonProperty( "AccountingDocumentTypeName" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentTypeName" )
    private String accountingDocumentTypeName;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentTypeName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ACCOUNTING_DOCUMENT_TYPE_NAME =
        new IsSettlementResultField<String>("AccountingDocumentTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountType</b>
     * </p>
     *
     * @return Account Type
     */
    @SerializedName( "FinancialAccountType" )
    @JsonProperty( "FinancialAccountType" )
    @Nullable
    @ODataField( odataName = "FinancialAccountType" )
    private String financialAccountType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialAccountType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FINANCIAL_ACCOUNT_TYPE =
        new IsSettlementResultField<String>("FinancialAccountType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountTypeName</b>
     * </p>
     *
     * @return Account Type (Description)
     */
    @SerializedName( "FinancialAccountTypeName" )
    @JsonProperty( "FinancialAccountTypeName" )
    @Nullable
    @ODataField( odataName = "FinancialAccountTypeName" )
    private String financialAccountTypeName;
    /**
     * Use with available fluent helpers to apply the <b>FinancialAccountTypeName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FINANCIAL_ACCOUNT_TYPE_NAME =
        new IsSettlementResultField<String>("FinancialAccountTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> BUSINESS_AREA =
        new IsSettlementResultField<String>("BusinessArea");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessAreaName</b>
     * </p>
     *
     * @return Business Area (Description)
     */
    @SerializedName( "BusinessAreaName" )
    @JsonProperty( "BusinessAreaName" )
    @Nullable
    @ODataField( odataName = "BusinessAreaName" )
    private String businessAreaName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessAreaName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> BUSINESS_AREA_NAME =
        new IsSettlementResultField<String>("BusinessAreaName");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OriginCostCtrActivityType</b>
     * </p>
     *
     * @return Origin Cost Center Activity Type
     */
    @SerializedName( "OriginCostCtrActivityType" )
    @JsonProperty( "OriginCostCtrActivityType" )
    @Nullable
    @ODataField( odataName = "OriginCostCtrActivityType" )
    private String originCostCtrActivityType;
    /**
     * Use with available fluent helpers to apply the <b>OriginCostCtrActivityType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ORIGIN_COST_CTR_ACTIVITY_TYPE =
        new IsSettlementResultField<String>("OriginCostCtrActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return Chart of Accounts
     */
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CHART_OF_ACCOUNTS =
        new IsSettlementResultField<String>("ChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CONTROLLING_AREA =
        new IsSettlementResultField<String>("ControllingArea");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaName</b>
     * </p>
     *
     * @return Controlling Area (Description)
     */
    @SerializedName( "ControllingAreaName" )
    @JsonProperty( "ControllingAreaName" )
    @Nullable
    @ODataField( odataName = "ControllingAreaName" )
    private String controllingAreaName;
    /**
     * Use with available fluent helpers to apply the <b>ControllingAreaName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CONTROLLING_AREA_NAME =
        new IsSettlementResultField<String>("ControllingAreaName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectClass</b>
     * </p>
     *
     * @return Controlling Object Class
     */
    @SerializedName( "ControllingObjectClass" )
    @JsonProperty( "ControllingObjectClass" )
    @Nullable
    @ODataField( odataName = "ControllingObjectClass" )
    private String controllingObjectClass;
    /**
     * Use with available fluent helpers to apply the <b>ControllingObjectClass</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CONTROLLING_OBJECT_CLASS =
        new IsSettlementResultField<String>("ControllingObjectClass");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenter</b>
     * </p>
     *
     * @return Partner Cost Center
     */
    @SerializedName( "PartnerCostCenter" )
    @JsonProperty( "PartnerCostCenter" )
    @Nullable
    @ODataField( odataName = "PartnerCostCenter" )
    private String partnerCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCostCenter</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_COST_CENTER =
        new IsSettlementResultField<String>("PartnerCostCenter");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SenderCostCenterName</b>
     * </p>
     *
     * @return Partner Cost Center (Description)
     */
    @SerializedName( "SenderCostCenterName" )
    @JsonProperty( "SenderCostCenterName" )
    @Nullable
    @ODataField( odataName = "SenderCostCenterName" )
    private String senderCostCenterName;
    /**
     * Use with available fluent helpers to apply the <b>SenderCostCenterName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> SENDER_COST_CENTER_NAME =
        new IsSettlementResultField<String>("SenderCostCenterName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @return Debit/Credit Code
     */
    @SerializedName( "DebitCreditCode" )
    @JsonProperty( "DebitCreditCode" )
    @Nullable
    @ODataField( odataName = "DebitCreditCode" )
    private String debitCreditCode;
    /**
     * Use with available fluent helpers to apply the <b>DebitCreditCode</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> DEBIT_CREDIT_CODE =
        new IsSettlementResultField<String>("DebitCreditCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCodeName</b>
     * </p>
     *
     * @return Debit/Credit Code (Description)
     */
    @SerializedName( "DebitCreditCodeName" )
    @JsonProperty( "DebitCreditCodeName" )
    @Nullable
    @ODataField( odataName = "DebitCreditCodeName" )
    private String debitCreditCodeName;
    /**
     * Use with available fluent helpers to apply the <b>DebitCreditCodeName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> DEBIT_CREDIT_CODE_NAME =
        new IsSettlementResultField<String>("DebitCreditCodeName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting Date
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @ODataField( odataName = "PostingDate" )
    private String postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> POSTING_DATE =
        new IsSettlementResultField<String>("PostingDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate_T</b>
     * </p>
     *
     * @return Posting Date (Description)
     */
    @SerializedName( "PostingDate_T" )
    @JsonProperty( "PostingDate_T" )
    @Nullable
    @ODataField( odataName = "PostingDate_T" )
    private String postingDate_T;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate_T</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> POSTING_DATE_T =
        new IsSettlementResultField<String>("PostingDate_T");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @return Fiscal Year Variant
     */
    @SerializedName( "FiscalYearVariant" )
    @JsonProperty( "FiscalYearVariant" )
    @Nullable
    @ODataField( odataName = "FiscalYearVariant" )
    private String fiscalYearVariant;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearVariant</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FISCAL_YEAR_VARIANT =
        new IsSettlementResultField<String>("FiscalYearVariant");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FUNCTIONAL_AREA =
        new IsSettlementResultField<String>("FunctionalArea");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalAreaName</b>
     * </p>
     *
     * @return Functional Area (Description)
     */
    @SerializedName( "FunctionalAreaName" )
    @JsonProperty( "FunctionalAreaName" )
    @Nullable
    @ODataField( odataName = "FunctionalAreaName" )
    private String functionalAreaName;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalAreaName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FUNCTIONAL_AREA_NAME =
        new IsSettlementResultField<String>("FunctionalAreaName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FISCAL_YEAR = new IsSettlementResultField<String>("FiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @return Budget Period
     */
    @SerializedName( "BudgetPeriod" )
    @JsonProperty( "BudgetPeriod" )
    @Nullable
    @ODataField( odataName = "BudgetPeriod" )
    private String budgetPeriod;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriod</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> BUDGET_PERIOD =
        new IsSettlementResultField<String>("BudgetPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CalendarWeek</b>
     * </p>
     *
     * @return Calendar Week
     */
    @SerializedName( "CalendarWeek" )
    @JsonProperty( "CalendarWeek" )
    @Nullable
    @ODataField( odataName = "CalendarWeek" )
    private String calendarWeek;
    /**
     * Use with available fluent helpers to apply the <b>CalendarWeek</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CALENDAR_WEEK =
        new IsSettlementResultField<String>("CalendarWeek");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYear</b>
     * </p>
     *
     * @return Calendar Year
     */
    @SerializedName( "CalendarYear" )
    @JsonProperty( "CalendarYear" )
    @Nullable
    @ODataField( odataName = "CalendarYear" )
    private String calendarYear;
    /**
     * Use with available fluent helpers to apply the <b>CalendarYear</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CALENDAR_YEAR =
        new IsSettlementResultField<String>("CalendarYear");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDate</b>
     * </p>
     *
     * @return Clearing Date
     */
    @SerializedName( "ClearingDate" )
    @JsonProperty( "ClearingDate" )
    @Nullable
    @ODataField( odataName = "ClearingDate" )
    private String clearingDate;
    /**
     * Use with available fluent helpers to apply the <b>ClearingDate</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CLEARING_DATE =
        new IsSettlementResultField<String>("ClearingDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDate_T</b>
     * </p>
     *
     * @return Clearing Date (Description)
     */
    @SerializedName( "ClearingDate_T" )
    @JsonProperty( "ClearingDate_T" )
    @Nullable
    @ODataField( odataName = "ClearingDate_T" )
    private String clearingDate_T;
    /**
     * Use with available fluent helpers to apply the <b>ClearingDate_T</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CLEARING_DATE_T =
        new IsSettlementResultField<String>("ClearingDate_T");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> COST_CENTER = new IsSettlementResultField<String>("CostCenter");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterName</b>
     * </p>
     *
     * @return Cost Center (Description)
     */
    @SerializedName( "CostCenterName" )
    @JsonProperty( "CostCenterName" )
    @Nullable
    @ODataField( odataName = "CostCenterName" )
    private String costCenterName;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> COST_CENTER_NAME =
        new IsSettlementResultField<String>("CostCenterName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @return Cost Object
     */
    @SerializedName( "CostObject" )
    @JsonProperty( "CostObject" )
    @Nullable
    @ODataField( odataName = "CostObject" )
    private String costObject;
    /**
     * Use with available fluent helpers to apply the <b>CostObject</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> COST_OBJECT = new IsSettlementResultField<String>("CostObject");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @return Fiscal Period
     */
    @SerializedName( "FiscalPeriod" )
    @JsonProperty( "FiscalPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalPeriod" )
    private String fiscalPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriod</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FISCAL_PERIOD =
        new IsSettlementResultField<String>("FiscalPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalWeek</b>
     * </p>
     *
     * @return Fiscal Week
     */
    @SerializedName( "FiscalWeek" )
    @JsonProperty( "FiscalWeek" )
    @Nullable
    @ODataField( odataName = "FiscalWeek" )
    private String fiscalWeek;
    /**
     * Use with available fluent helpers to apply the <b>FiscalWeek</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FISCAL_WEEK = new IsSettlementResultField<String>("FiscalWeek");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @return Fund
     */
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FUND = new IsSettlementResultField<String>("Fund");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @return Grant
     */
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> GRANT_ID = new IsSettlementResultField<String>("GrantID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsReversal</b>
     * </p>
     *
     * @return Is Reversing
     */
    @SerializedName( "IsReversal" )
    @JsonProperty( "IsReversal" )
    @Nullable
    @ODataField( odataName = "IsReversal" )
    private String isReversal;
    /**
     * Use with available fluent helpers to apply the <b>IsReversal</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> IS_REVERSAL = new IsSettlementResultField<String>("IsReversal");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsReversed</b>
     * </p>
     *
     * @return Is Reversed
     */
    @SerializedName( "IsReversed" )
    @JsonProperty( "IsReversed" )
    @Nullable
    @ODataField( odataName = "IsReversed" )
    private String isReversed;
    /**
     * Use with available fluent helpers to apply the <b>IsReversed</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> IS_REVERSED = new IsSettlementResultField<String>("IsReversed");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSettled</b>
     * </p>
     *
     * @return Is Settled
     */
    @SerializedName( "IsSettled" )
    @JsonProperty( "IsSettled" )
    @Nullable
    @ODataField( odataName = "IsSettled" )
    private String isSettled;
    /**
     * Use with available fluent helpers to apply the <b>IsSettled</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> IS_SETTLED = new IsSettlementResultField<String>("IsSettled");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     *
     * @return Joint Venture
     */
    @SerializedName( "JointVenture" )
    @JsonProperty( "JointVenture" )
    @Nullable
    @ODataField( odataName = "JointVenture" )
    private String jointVenture;
    /**
     * Use with available fluent helpers to apply the <b>JointVenture</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> JOINT_VENTURE =
        new IsSettlementResultField<String>("JointVenture");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return Order ID
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ORDER_ID = new IsSettlementResultField<String>("OrderID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFund</b>
     * </p>
     *
     * @return Partner Fund
     */
    @SerializedName( "PartnerFund" )
    @JsonProperty( "PartnerFund" )
    @Nullable
    @ODataField( odataName = "PartnerFund" )
    private String partnerFund;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFund</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_FUND =
        new IsSettlementResultField<String>("PartnerFund");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerGrant</b>
     * </p>
     *
     * @return Partner Grant
     */
    @SerializedName( "PartnerGrant" )
    @JsonProperty( "PartnerGrant" )
    @Nullable
    @ODataField( odataName = "PartnerGrant" )
    private String partnerGrant;
    /**
     * Use with available fluent helpers to apply the <b>PartnerGrant</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_GRANT =
        new IsSettlementResultField<String>("PartnerGrant");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrder</b>
     * </p>
     *
     * @return Partner Order
     */
    @SerializedName( "PartnerOrder" )
    @JsonProperty( "PartnerOrder" )
    @Nullable
    @ODataField( odataName = "PartnerOrder" )
    private String partnerOrder;
    /**
     * Use with available fluent helpers to apply the <b>PartnerOrder</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_ORDER =
        new IsSettlementResultField<String>("PartnerOrder");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> SALES_ORDER = new IsSettlementResultField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SoldMaterial</b>
     * </p>
     *
     * @return Product Sold (Deprecated)
     */
    @SerializedName( "SoldMaterial" )
    @JsonProperty( "SoldMaterial" )
    @Nullable
    @ODataField( odataName = "SoldMaterial" )
    private String soldMaterial;
    /**
     * Use with available fluent helpers to apply the <b>SoldMaterial</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> SOLD_MATERIAL =
        new IsSettlementResultField<String>("SoldMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SoldProduct</b>
     * </p>
     *
     * @return Product Sold
     */
    @SerializedName( "SoldProduct" )
    @JsonProperty( "SoldProduct" )
    @Nullable
    @ODataField( odataName = "SoldProduct" )
    private String soldProduct;
    /**
     * Use with available fluent helpers to apply the <b>SoldProduct</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> SOLD_PRODUCT =
        new IsSettlementResultField<String>("SoldProduct");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> TAX_CODE = new IsSettlementResultField<String>("TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return WBS Element
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> WBS_ELEMENT = new IsSettlementResultField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     *
     * @return House Bank
     */
    @SerializedName( "HouseBank" )
    @JsonProperty( "HouseBank" )
    @Nullable
    @ODataField( odataName = "HouseBank" )
    private String houseBank;
    /**
     * Use with available fluent helpers to apply the <b>HouseBank</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> HOUSE_BANK = new IsSettlementResultField<String>("HouseBank");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockValnType</b>
     * </p>
     *
     * @return Inv. Special Stock Val. Type -Deprecated
     */
    @SerializedName( "InventorySpecialStockValnType" )
    @JsonProperty( "InventorySpecialStockValnType" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockValnType" )
    private String inventorySpecialStockValnType;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockValnType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> INVENTORY_SPECIAL_STOCK_VALN_TYPE =
        new IsSettlementResultField<String>("InventorySpecialStockValnType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @return Ledger
     */
    @SerializedName( "Ledger" )
    @JsonProperty( "Ledger" )
    @Nullable
    @ODataField( odataName = "Ledger" )
    private String ledger;
    /**
     * Use with available fluent helpers to apply the <b>Ledger</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> LEDGER = new IsSettlementResultField<String>("Ledger");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @return Fixed Asset
     */
    @SerializedName( "MasterFixedAsset" )
    @JsonProperty( "MasterFixedAsset" )
    @Nullable
    @ODataField( odataName = "MasterFixedAsset" )
    private String masterFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>MasterFixedAsset</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> MASTER_FIXED_ASSET =
        new IsSettlementResultField<String>("MasterFixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingKey</b>
     * </p>
     *
     * @return Posting Key
     */
    @SerializedName( "PostingKey" )
    @JsonProperty( "PostingKey" )
    @Nullable
    @ODataField( odataName = "PostingKey" )
    private String postingKey;
    /**
     * Use with available fluent helpers to apply the <b>PostingKey</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> POSTING_KEY = new IsSettlementResultField<String>("PostingKey");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PostingKeyName</b>
     * </p>
     *
     * @return Posting Key (Description)
     */
    @SerializedName( "PostingKeyName" )
    @JsonProperty( "PostingKeyName" )
    @Nullable
    @ODataField( odataName = "PostingKeyName" )
    private String postingKeyName;
    /**
     * Use with available fluent helpers to apply the <b>PostingKeyName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> POSTING_KEY_NAME =
        new IsSettlementResultField<String>("PostingKeyName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PROFIT_CENTER =
        new IsSettlementResultField<String>("ProfitCenter");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterName</b>
     * </p>
     *
     * @return Profit Center (Description)
     */
    @SerializedName( "ProfitCenterName" )
    @JsonProperty( "ProfitCenterName" )
    @Nullable
    @ODataField( odataName = "ProfitCenterName" )
    private String profitCenterName;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenterName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PROFIT_CENTER_NAME =
        new IsSettlementResultField<String>("ProfitCenterName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @return Segment
     */
    @SerializedName( "Segment" )
    @JsonProperty( "Segment" )
    @Nullable
    @ODataField( odataName = "Segment" )
    private String segment;
    /**
     * Use with available fluent helpers to apply the <b>Segment</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> SEGMENT = new IsSettlementResultField<String>("Segment");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SegmentName</b>
     * </p>
     *
     * @return Segment (Description)
     */
    @SerializedName( "SegmentName" )
    @JsonProperty( "SegmentName" )
    @Nullable
    @ODataField( odataName = "SegmentName" )
    private String segmentName;
    /**
     * Use with available fluent helpers to apply the <b>SegmentName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> SEGMENT_NAME =
        new IsSettlementResultField<String>("SegmentName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLCode</b>
     * </p>
     *
     * @return Special G/L
     */
    @SerializedName( "SpecialGLCode" )
    @JsonProperty( "SpecialGLCode" )
    @Nullable
    @ODataField( odataName = "SpecialGLCode" )
    private String specialGLCode;
    /**
     * Use with available fluent helpers to apply the <b>SpecialGLCode</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> SPECIAL_GL_CODE =
        new IsSettlementResultField<String>("SpecialGLCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @return Financial Transaction Type
     */
    @SerializedName( "FinancialTransactionType" )
    @JsonProperty( "FinancialTransactionType" )
    @Nullable
    @ODataField( odataName = "FinancialTransactionType" )
    private String financialTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialTransactionType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FINANCIAL_TRANSACTION_TYPE =
        new IsSettlementResultField<String>("FinancialTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @return Asset Subnumber
     */
    @SerializedName( "FixedAsset" )
    @JsonProperty( "FixedAsset" )
    @Nullable
    @ODataField( odataName = "FixedAsset" )
    private String fixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>FixedAsset</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FIXED_ASSET = new IsSettlementResultField<String>("FixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityType</b>
     * </p>
     *
     * @return Joint Venture Equity Type
     */
    @SerializedName( "JointVentureEquityType" )
    @JsonProperty( "JointVentureEquityType" )
    @Nullable
    @ODataField( odataName = "JointVentureEquityType" )
    private String jointVentureEquityType;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureEquityType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> JOINT_VENTURE_EQUITY_TYPE =
        new IsSettlementResultField<String>("JointVentureEquityType");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount</b>
     * </p>
     *
     * @return House Bank Account
     */
    @SerializedName( "HouseBankAccount" )
    @JsonProperty( "HouseBankAccount" )
    @Nullable
    @ODataField( odataName = "HouseBankAccount" )
    private String houseBankAccount;
    /**
     * Use with available fluent helpers to apply the <b>HouseBankAccount</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> HOUSE_BANK_ACCOUNT =
        new IsSettlementResultField<String>("HouseBankAccount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @return Inventory Special Stock Type
     */
    @SerializedName( "InventorySpecialStockType" )
    @JsonProperty( "InventorySpecialStockType" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockType" )
    private String inventorySpecialStockType;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> INVENTORY_SPECIAL_STOCK_TYPE =
        new IsSettlementResultField<String>("InventorySpecialStockType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeGLAccount</b>
     * </p>
     *
     * @return Alternative G/L Account
     */
    @SerializedName( "AlternativeGLAccount" )
    @JsonProperty( "AlternativeGLAccount" )
    @Nullable
    @ODataField( odataName = "AlternativeGLAccount" )
    private String alternativeGLAccount;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeGLAccount</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ALTERNATIVE_GL_ACCOUNT =
        new IsSettlementResultField<String>("AlternativeGLAccount");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeGLAccount_T</b>
     * </p>
     *
     * @return Alternative G/L Account (Description)
     */
    @SerializedName( "AlternativeGLAccount_T" )
    @JsonProperty( "AlternativeGLAccount_T" )
    @Nullable
    @ODataField( odataName = "AlternativeGLAccount_T" )
    private String alternativeGLAccount_T;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeGLAccount_T</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ALTERNATIVE_GL_ACCOUNT_T =
        new IsSettlementResultField<String>("AlternativeGLAccount_T");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Product (Deprecated)
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> MATERIAL = new IsSettlementResultField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Product Sold Group (Deprecated)
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> MATERIAL_GROUP =
        new IsSettlementResultField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PLANT = new IsSettlementResultField<String>("Plant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlantName</b>
     * </p>
     *
     * @return Plant (Description)
     */
    @SerializedName( "PlantName" )
    @JsonProperty( "PlantName" )
    @Nullable
    @ODataField( odataName = "PlantName" )
    private String plantName;
    /**
     * Use with available fluent helpers to apply the <b>PlantName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PLANT_NAME = new IsSettlementResultField<String>("PlantName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrderCategory</b>
     * </p>
     *
     * @return Order Category
     */
    @SerializedName( "OrderCategory" )
    @JsonProperty( "OrderCategory" )
    @Nullable
    @ODataField( odataName = "OrderCategory" )
    private String orderCategory;
    /**
     * Use with available fluent helpers to apply the <b>OrderCategory</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ORDER_CATEGORY =
        new IsSettlementResultField<String>("OrderCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PRODUCT = new IsSettlementResultField<String>("Product");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @return Product (Description)
     */
    @SerializedName( "MaterialName" )
    @JsonProperty( "MaterialName" )
    @Nullable
    @ODataField( odataName = "MaterialName" )
    private String materialName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> MATERIAL_NAME =
        new IsSettlementResultField<String>("MaterialName");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup</b>
     * </p>
     *
     * @return Product Group
     */
    @SerializedName( "ProductGroup" )
    @JsonProperty( "ProductGroup" )
    @Nullable
    @ODataField( odataName = "ProductGroup" )
    private String productGroup;
    /**
     * Use with available fluent helpers to apply the <b>ProductGroup</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PRODUCT_GROUP =
        new IsSettlementResultField<String>("ProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @return Project Definition
     */
    @SerializedName( "Project" )
    @JsonProperty( "Project" )
    @Nullable
    @ODataField( odataName = "Project" )
    private String project;
    /**
     * Use with available fluent helpers to apply the <b>Project</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PROJECT = new IsSettlementResultField<String>("Project");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @return Valuation Area
     */
    @SerializedName( "ValuationArea" )
    @JsonProperty( "ValuationArea" )
    @Nullable
    @ODataField( odataName = "ValuationArea" )
    private String valuationArea;
    /**
     * Use with available fluent helpers to apply the <b>ValuationArea</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> VALUATION_AREA =
        new IsSettlementResultField<String>("ValuationArea");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @return Customer Group
     */
    @SerializedName( "CustomerGroup" )
    @JsonProperty( "CustomerGroup" )
    @Nullable
    @ODataField( odataName = "CustomerGroup" )
    private String customerGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroup</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CUSTOMER_GROUP =
        new IsSettlementResultField<String>("CustomerGroup");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroupName</b>
     * </p>
     *
     * @return Customer Group (Description)
     */
    @SerializedName( "CustomerGroupName" )
    @JsonProperty( "CustomerGroupName" )
    @Nullable
    @ODataField( odataName = "CustomerGroupName" )
    private String customerGroupName;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroupName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CUSTOMER_GROUP_NAME =
        new IsSettlementResultField<String>("CustomerGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocument</b>
     * </p>
     *
     * @return Inventory Special Stock Sales Document
     */
    @SerializedName( "InventorySpclStkSalesDocument" )
    @JsonProperty( "InventorySpclStkSalesDocument" )
    @Nullable
    @ODataField( odataName = "InventorySpclStkSalesDocument" )
    private String inventorySpclStkSalesDocument;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpclStkSalesDocument</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> INVENTORY_SPCL_STK_SALES_DOCUMENT =
        new IsSettlementResultField<String>("InventorySpclStkSalesDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocItm</b>
     * </p>
     *
     * @return Inventory Spcl Stock Sales Document Item
     */
    @SerializedName( "InventorySpclStkSalesDocItm" )
    @JsonProperty( "InventorySpclStkSalesDocItm" )
    @Nullable
    @ODataField( odataName = "InventorySpclStkSalesDocItm" )
    private String inventorySpclStkSalesDocItm;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpclStkSalesDocItm</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> INVENTORY_SPCL_STK_SALES_DOC_ITM =
        new IsSettlementResultField<String>("InventorySpclStkSalesDocItm");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpclStockWBSElmntIntID</b>
     * </p>
     *
     * @return Inv. Special Stock WBS Element Int. ID
     */
    @SerializedName( "InvtrySpclStockWBSElmntIntID" )
    @JsonProperty( "InvtrySpclStockWBSElmntIntID" )
    @Nullable
    @ODataField( odataName = "InvtrySpclStockWBSElmntIntID" )
    private String invtrySpclStockWBSElmntIntID;
    /**
     * Use with available fluent helpers to apply the <b>InvtrySpclStockWBSElmntIntID</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> INVTRY_SPCL_STOCK_WBS_ELMNT_INT_ID =
        new IsSettlementResultField<String>("InvtrySpclStockWBSElmntIntID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStockWBSElement</b>
     * </p>
     *
     * @return WBSElem of Inventory
     */
    @SerializedName( "InventorySpclStockWBSElement" )
    @JsonProperty( "InventorySpclStockWBSElement" )
    @Nullable
    @ODataField( odataName = "InventorySpclStockWBSElement" )
    private String inventorySpclStockWBSElement;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpclStockWBSElement</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> INVENTORY_SPCL_STOCK_WBS_ELEMENT =
        new IsSettlementResultField<String>("InventorySpclStockWBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYearMonth</b>
     * </p>
     *
     * @return Year Month
     */
    @SerializedName( "CalendarYearMonth" )
    @JsonProperty( "CalendarYearMonth" )
    @Nullable
    @ODataField( odataName = "CalendarYearMonth" )
    private String calendarYearMonth;
    /**
     * Use with available fluent helpers to apply the <b>CalendarYearMonth</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CALENDAR_YEAR_MONTH =
        new IsSettlementResultField<String>("CalendarYearMonth");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CUSTOMER = new IsSettlementResultField<String>("Customer");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustomerName</b>
     * </p>
     *
     * @return Customer (Description)
     */
    @SerializedName( "CustomerName" )
    @JsonProperty( "CustomerName" )
    @Nullable
    @ODataField( odataName = "CustomerName" )
    private String customerName;
    /**
     * Use with available fluent helpers to apply the <b>CustomerName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CUSTOMER_NAME =
        new IsSettlementResultField<String>("CustomerName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> SUPPLIER = new IsSettlementResultField<String>("Supplier");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SupplierName</b>
     * </p>
     *
     * @return Supplier (Description)
     */
    @SerializedName( "SupplierName" )
    @JsonProperty( "SupplierName" )
    @Nullable
    @ODataField( odataName = "SupplierName" )
    private String supplierName;
    /**
     * Use with available fluent helpers to apply the <b>SupplierName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> SUPPLIER_NAME =
        new IsSettlementResultField<String>("SupplierName");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BalanceTransactionCurrency</b>
     * </p>
     *
     * @return Balance Transaction Currency
     */
    @SerializedName( "BalanceTransactionCurrency" )
    @JsonProperty( "BalanceTransactionCurrency" )
    @Nullable
    @ODataField( odataName = "BalanceTransactionCurrency" )
    private String balanceTransactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>BalanceTransactionCurrency</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> BALANCE_TRANSACTION_CURRENCY =
        new IsSettlementResultField<String>("BalanceTransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @return Assignment Reference
     */
    @SerializedName( "AssignmentReference" )
    @JsonProperty( "AssignmentReference" )
    @Nullable
    @ODataField( odataName = "AssignmentReference" )
    private String assignmentReference;
    /**
     * Use with available fluent helpers to apply the <b>AssignmentReference</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ASSIGNMENT_REFERENCE =
        new IsSettlementResultField<String>("AssignmentReference");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return WBS Element External ID
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> WBS_ELEMENT_EXTERNAL_ID =
        new IsSettlementResultField<String>("WBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "OrganizationDivision" )
    @JsonProperty( "OrganizationDivision" )
    @Nullable
    @ODataField( odataName = "OrganizationDivision" )
    private String organizationDivision;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationDivision</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ORGANIZATION_DIVISION =
        new IsSettlementResultField<String>("OrganizationDivision");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectNetworkActivity</b>
     * </p>
     *
     * @return Partner Project Network Activity
     */
    @SerializedName( "PartnerProjectNetworkActivity" )
    @JsonProperty( "PartnerProjectNetworkActivity" )
    @Nullable
    @ODataField( odataName = "PartnerProjectNetworkActivity" )
    private String partnerProjectNetworkActivity;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProjectNetworkActivity</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_PROJECT_NETWORK_ACTIVITY =
        new IsSettlementResultField<String>("PartnerProjectNetworkActivity");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYearQuarter</b>
     * </p>
     *
     * @return Year Quarter
     */
    @SerializedName( "CalendarYearQuarter" )
    @JsonProperty( "CalendarYearQuarter" )
    @Nullable
    @ODataField( odataName = "CalendarYearQuarter" )
    private String calendarYearQuarter;
    /**
     * Use with available fluent helpers to apply the <b>CalendarYearQuarter</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CALENDAR_YEAR_QUARTER =
        new IsSettlementResultField<String>("CalendarYearQuarter");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBalanceSheetAccount</b>
     * </p>
     *
     * @return Balance sheet acct
     */
    @SerializedName( "IsBalanceSheetAccount" )
    @JsonProperty( "IsBalanceSheetAccount" )
    @Nullable
    @ODataField( odataName = "IsBalanceSheetAccount" )
    private String isBalanceSheetAccount;
    /**
     * Use with available fluent helpers to apply the <b>IsBalanceSheetAccount</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> IS_BALANCE_SHEET_ACCOUNT =
        new IsSettlementResultField<String>("IsBalanceSheetAccount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountAssignmentType</b>
     * </p>
     *
     * @return Partner Account Assignment Type
     */
    @SerializedName( "PartnerAccountAssignmentType" )
    @JsonProperty( "PartnerAccountAssignmentType" )
    @Nullable
    @ODataField( odataName = "PartnerAccountAssignmentType" )
    private String partnerAccountAssignmentType;
    /**
     * Use with available fluent helpers to apply the <b>PartnerAccountAssignmentType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_ACCOUNT_ASSIGNMENT_TYPE =
        new IsSettlementResultField<String>("PartnerAccountAssignmentType");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearWeek</b>
     * </p>
     *
     * @return Fiscal Year Week
     */
    @SerializedName( "FiscalYearWeek" )
    @JsonProperty( "FiscalYearWeek" )
    @Nullable
    @ODataField( odataName = "FiscalYearWeek" )
    private String fiscalYearWeek;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearWeek</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FISCAL_YEAR_WEEK =
        new IsSettlementResultField<String>("FiscalYearWeek");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityGroup</b>
     * </p>
     *
     * @return Joint Venture Equity Group
     */
    @SerializedName( "JointVentureEquityGroup" )
    @JsonProperty( "JointVentureEquityGroup" )
    @Nullable
    @ODataField( odataName = "JointVentureEquityGroup" )
    private String jointVentureEquityGroup;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureEquityGroup</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> JOINT_VENTURE_EQUITY_GROUP =
        new IsSettlementResultField<String>("JointVentureEquityGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @return FM Area
     */
    @SerializedName( "FinancialManagementArea" )
    @JsonProperty( "FinancialManagementArea" )
    @Nullable
    @ODataField( odataName = "FinancialManagementArea" )
    private String financialManagementArea;
    /**
     * Use with available fluent helpers to apply the <b>FinancialManagementArea</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FINANCIAL_MANAGEMENT_AREA =
        new IsSettlementResultField<String>("FinancialManagementArea");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @return Activity Type
     */
    @SerializedName( "CostCtrActivityType" )
    @JsonProperty( "CostCtrActivityType" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityType" )
    private String costCtrActivityType;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> COST_CTR_ACTIVITY_TYPE =
        new IsSettlementResultField<String>("CostCtrActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SenderAccountAssignment</b>
     * </p>
     *
     * @return Sender Account Assignment
     */
    @SerializedName( "SenderAccountAssignment" )
    @JsonProperty( "SenderAccountAssignment" )
    @Nullable
    @ODataField( odataName = "SenderAccountAssignment" )
    private String senderAccountAssignment;
    /**
     * Use with available fluent helpers to apply the <b>SenderAccountAssignment</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> SENDER_ACCOUNT_ASSIGNMENT =
        new IsSettlementResultField<String>("SenderAccountAssignment");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearQuarter</b>
     * </p>
     *
     * @return Fiscal Year Quarter
     */
    @SerializedName( "FiscalYearQuarter" )
    @JsonProperty( "FiscalYearQuarter" )
    @Nullable
    @ODataField( odataName = "FiscalYearQuarter" )
    private String fiscalYearQuarter;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearQuarter</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FISCAL_YEAR_QUARTER =
        new IsSettlementResultField<String>("FiscalYearQuarter");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     *
     * @return Reference Document Type
     */
    @SerializedName( "ReferenceDocumentType" )
    @JsonProperty( "ReferenceDocumentType" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentType" )
    private String referenceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> REFERENCE_DOCUMENT_TYPE =
        new IsSettlementResultField<String>("ReferenceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GroupFixedAsset</b>
     * </p>
     *
     * @return Group Asset Subnmbr
     */
    @SerializedName( "GroupFixedAsset" )
    @JsonProperty( "GroupFixedAsset" )
    @Nullable
    @ODataField( odataName = "GroupFixedAsset" )
    private String groupFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>GroupFixedAsset</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> GROUP_FIXED_ASSET =
        new IsSettlementResultField<String>("GroupFixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentItemGroup</b>
     * </p>
     *
     * @return Reference Document Item Group
     */
    @SerializedName( "ReferenceDocumentItemGroup" )
    @JsonProperty( "ReferenceDocumentItemGroup" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentItemGroup" )
    private String referenceDocumentItemGroup;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentItemGroup</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> REFERENCE_DOCUMENT_ITEM_GROUP =
        new IsSettlementResultField<String>("ReferenceDocumentItemGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssetDepreciationArea</b>
     * </p>
     *
     * @return Depreciation Area
     */
    @SerializedName( "AssetDepreciationArea" )
    @JsonProperty( "AssetDepreciationArea" )
    @Nullable
    @ODataField( odataName = "AssetDepreciationArea" )
    private String assetDepreciationArea;
    /**
     * Use with available fluent helpers to apply the <b>AssetDepreciationArea</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ASSET_DEPRECIATION_AREA =
        new IsSettlementResultField<String>("AssetDepreciationArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegment</b>
     * </p>
     *
     * @return Partner Segment
     */
    @SerializedName( "PartnerSegment" )
    @JsonProperty( "PartnerSegment" )
    @Nullable
    @ODataField( odataName = "PartnerSegment" )
    private String partnerSegment;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSegment</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_SEGMENT =
        new IsSettlementResultField<String>("PartnerSegment");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegmentName</b>
     * </p>
     *
     * @return Partner Segment (Description)
     */
    @SerializedName( "PartnerSegmentName" )
    @JsonProperty( "PartnerSegmentName" )
    @Nullable
    @ODataField( odataName = "PartnerSegmentName" )
    private String partnerSegmentName;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSegmentName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_SEGMENT_NAME =
        new IsSettlementResultField<String>("PartnerSegmentName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingJournalEntry</b>
     * </p>
     *
     * @return Clearing Journal Entry
     */
    @SerializedName( "ClearingJournalEntry" )
    @JsonProperty( "ClearingJournalEntry" )
    @Nullable
    @ODataField( odataName = "ClearingJournalEntry" )
    private String clearingJournalEntry;
    /**
     * Use with available fluent helpers to apply the <b>ClearingJournalEntry</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CLEARING_JOURNAL_ENTRY =
        new IsSettlementResultField<String>("ClearingJournalEntry");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperatingConcern</b>
     * </p>
     *
     * @return Operating Concern
     */
    @SerializedName( "OperatingConcern" )
    @JsonProperty( "OperatingConcern" )
    @Nullable
    @ODataField( odataName = "OperatingConcern" )
    private String operatingConcern;
    /**
     * Use with available fluent helpers to apply the <b>OperatingConcern</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> OPERATING_CONCERN =
        new IsSettlementResultField<String>("OperatingConcern");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpclStockWBSElmntExtID</b>
     * </p>
     *
     * @return Inventory WBS Element External ID
     */
    @SerializedName( "InvtrySpclStockWBSElmntExtID" )
    @JsonProperty( "InvtrySpclStockWBSElmntExtID" )
    @Nullable
    @ODataField( odataName = "InvtrySpclStockWBSElmntExtID" )
    private String invtrySpclStockWBSElmntExtID;
    /**
     * Use with available fluent helpers to apply the <b>InvtrySpclStockWBSElmntExtID</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> INVTRY_SPCL_STOCK_WBS_ELMNT_EXT_ID =
        new IsSettlementResultField<String>("InvtrySpclStockWBSElmntExtID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodEndDate</b>
     * </p>
     *
     * @return End of Fiscal Period
     */
    @SerializedName( "FiscalPeriodEndDate" )
    @JsonProperty( "FiscalPeriodEndDate" )
    @Nullable
    @ODataField( odataName = "FiscalPeriodEndDate" )
    private String fiscalPeriodEndDate;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriodEndDate</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FISCAL_PERIOD_END_DATE =
        new IsSettlementResultField<String>("FiscalPeriodEndDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodEndDate_T</b>
     * </p>
     *
     * @return End of Fiscal Period (Description)
     */
    @SerializedName( "FiscalPeriodEndDate_T" )
    @JsonProperty( "FiscalPeriodEndDate_T" )
    @Nullable
    @ODataField( odataName = "FiscalPeriodEndDate_T" )
    private String fiscalPeriodEndDate_T;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriodEndDate_T</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FISCAL_PERIOD_END_DATE_T =
        new IsSettlementResultField<String>("FiscalPeriodEndDate_T");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CountryChartOfAccounts</b>
     * </p>
     *
     * @return Alternative Chart of Accounts
     */
    @SerializedName( "CountryChartOfAccounts" )
    @JsonProperty( "CountryChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "CountryChartOfAccounts" )
    private String countryChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>CountryChartOfAccounts</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> COUNTRY_CHART_OF_ACCOUNTS =
        new IsSettlementResultField<String>("CountryChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodStartDate</b>
     * </p>
     *
     * @return Start Date
     */
    @SerializedName( "FiscalPeriodStartDate" )
    @JsonProperty( "FiscalPeriodStartDate" )
    @Nullable
    @ODataField( odataName = "FiscalPeriodStartDate" )
    private String fiscalPeriodStartDate;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriodStartDate</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FISCAL_PERIOD_START_DATE =
        new IsSettlementResultField<String>("FiscalPeriodStartDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodStartDate_T</b>
     * </p>
     *
     * @return Start Date (Description)
     */
    @SerializedName( "FiscalPeriodStartDate_T" )
    @JsonProperty( "FiscalPeriodStartDate_T" )
    @Nullable
    @ODataField( odataName = "FiscalPeriodStartDate_T" )
    private String fiscalPeriodStartDate_T;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriodStartDate_T</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FISCAL_PERIOD_START_DATE_T =
        new IsSettlementResultField<String>("FiscalPeriodStartDate_T");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency6</b>
     * </p>
     *
     * @return Freely Defined Currency 6
     */
    @SerializedName( "FreeDefinedCurrency6" )
    @JsonProperty( "FreeDefinedCurrency6" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency6" )
    private String freeDefinedCurrency6;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency6</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FREE_DEFINED_CURRENCY6 =
        new IsSettlementResultField<String>("FreeDefinedCurrency6");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Transaction Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> TRANSACTION_CURRENCY =
        new IsSettlementResultField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignment</b>
     * </p>
     *
     * @return Account Assignment
     */
    @SerializedName( "AccountAssignment" )
    @JsonProperty( "AccountAssignment" )
    @Nullable
    @ODataField( odataName = "AccountAssignment" )
    private String accountAssignment;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignment</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ACCOUNT_ASSIGNMENT =
        new IsSettlementResultField<String>("AccountAssignment");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCtrActivityType</b>
     * </p>
     *
     * @return Partner Cost Center Activity Type
     */
    @SerializedName( "PartnerCostCtrActivityType" )
    @JsonProperty( "PartnerCostCtrActivityType" )
    @Nullable
    @ODataField( odataName = "PartnerCostCtrActivityType" )
    private String partnerCostCtrActivityType;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCostCtrActivityType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_COST_CTR_ACTIVITY_TYPE =
        new IsSettlementResultField<String>("PartnerCostCtrActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessProcess</b>
     * </p>
     *
     * @return Partner Business Process
     */
    @SerializedName( "PartnerBusinessProcess" )
    @JsonProperty( "PartnerBusinessProcess" )
    @Nullable
    @ODataField( odataName = "PartnerBusinessProcess" )
    private String partnerBusinessProcess;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBusinessProcess</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_BUSINESS_PROCESS =
        new IsSettlementResultField<String>("PartnerBusinessProcess");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RelatedNetworkActivity</b>
     * </p>
     *
     * @return Related Network Activity
     */
    @SerializedName( "RelatedNetworkActivity" )
    @JsonProperty( "RelatedNetworkActivity" )
    @Nullable
    @ODataField( odataName = "RelatedNetworkActivity" )
    private String relatedNetworkActivity;
    /**
     * Use with available fluent helpers to apply the <b>RelatedNetworkActivity</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> RELATED_NETWORK_ACTIVITY =
        new IsSettlementResultField<String>("RelatedNetworkActivity");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @return Sales Document
     */
    @SerializedName( "SalesDocument" )
    @JsonProperty( "SalesDocument" )
    @Nullable
    @ODataField( odataName = "SalesDocument" )
    private String salesDocument;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocument</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> SALES_DOCUMENT =
        new IsSettlementResultField<String>("SalesDocument");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency1</b>
     * </p>
     *
     * @return Freely Defined Currency 1
     */
    @SerializedName( "FreeDefinedCurrency1" )
    @JsonProperty( "FreeDefinedCurrency1" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency1" )
    private String freeDefinedCurrency1;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency1</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FREE_DEFINED_CURRENCY1 =
        new IsSettlementResultField<String>("FreeDefinedCurrency1");
    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodDate</b>
     * </p>
     *
     * @return Fiscal Period Date
     */
    @SerializedName( "FiscalPeriodDate" )
    @JsonProperty( "FiscalPeriodDate" )
    @Nullable
    @ODataField( odataName = "FiscalPeriodDate" )
    private String fiscalPeriodDate;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriodDate</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FISCAL_PERIOD_DATE =
        new IsSettlementResultField<String>("FiscalPeriodDate");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency3</b>
     * </p>
     *
     * @return Freely Defined Currency 3
     */
    @SerializedName( "FreeDefinedCurrency3" )
    @JsonProperty( "FreeDefinedCurrency3" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency3" )
    private String freeDefinedCurrency3;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency3</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FREE_DEFINED_CURRENCY3 =
        new IsSettlementResultField<String>("FreeDefinedCurrency3");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AssetTransactionType</b>
     * </p>
     *
     * @return Ast Transaction Type
     */
    @SerializedName( "AssetTransactionType" )
    @JsonProperty( "AssetTransactionType" )
    @Nullable
    @ODataField( odataName = "AssetTransactionType" )
    private String assetTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>AssetTransactionType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ASSET_TRANSACTION_TYPE =
        new IsSettlementResultField<String>("AssetTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @return Purchasing Document
     */
    @SerializedName( "PurchasingDocument" )
    @JsonProperty( "PurchasingDocument" )
    @Nullable
    @ODataField( odataName = "PurchasingDocument" )
    private String purchasingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocument</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PURCHASING_DOCUMENT =
        new IsSettlementResultField<String>("PurchasingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpecialStockValnType_2</b>
     * </p>
     *
     * @return Inventory Special Stock Valuation Type
     */
    @SerializedName( "InvtrySpecialStockValnType_2" )
    @JsonProperty( "InvtrySpecialStockValnType_2" )
    @Nullable
    @ODataField( odataName = "InvtrySpecialStockValnType_2" )
    private String invtrySpecialStockValnType_2;
    /**
     * Use with available fluent helpers to apply the <b>InvtrySpecialStockValnType_2</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> INVTRY_SPECIAL_STOCK_VALN_TYPE_2 =
        new IsSettlementResultField<String>("InvtrySpecialStockValnType_2");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EliminationProfitCenter</b>
     * </p>
     *
     * @return Elimination Profit Center
     */
    @SerializedName( "EliminationProfitCenter" )
    @JsonProperty( "EliminationProfitCenter" )
    @Nullable
    @ODataField( odataName = "EliminationProfitCenter" )
    private String eliminationProfitCenter;
    /**
     * Use with available fluent helpers to apply the <b>EliminationProfitCenter</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ELIMINATION_PROFIT_CENTER =
        new IsSettlementResultField<String>("EliminationProfitCenter");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EliminationProfitCenterName</b>
     * </p>
     *
     * @return Elimination Profit Center (Description)
     */
    @SerializedName( "EliminationProfitCenterName" )
    @JsonProperty( "EliminationProfitCenterName" )
    @Nullable
    @ODataField( odataName = "EliminationProfitCenterName" )
    private String eliminationProfitCenterName;
    /**
     * Use with available fluent helpers to apply the <b>EliminationProfitCenterName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ELIMINATION_PROFIT_CENTER_NAME =
        new IsSettlementResultField<String>("EliminationProfitCenterName");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GlobalCurrency</b>
     * </p>
     *
     * @return Global Currency
     */
    @SerializedName( "GlobalCurrency" )
    @JsonProperty( "GlobalCurrency" )
    @Nullable
    @ODataField( odataName = "GlobalCurrency" )
    private String globalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>GlobalCurrency</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> GLOBAL_CURRENCY =
        new IsSettlementResultField<String>("GlobalCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorReferenceDocType</b>
     * </p>
     *
     * @return Predecessor Reference Document Type
     */
    @SerializedName( "PredecessorReferenceDocType" )
    @JsonProperty( "PredecessorReferenceDocType" )
    @Nullable
    @ODataField( odataName = "PredecessorReferenceDocType" )
    private String predecessorReferenceDocType;
    /**
     * Use with available fluent helpers to apply the <b>PredecessorReferenceDocType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PREDECESSOR_REFERENCE_DOC_TYPE =
        new IsSettlementResultField<String>("PredecessorReferenceDocType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LedgerFiscalYear</b>
     * </p>
     *
     * @return Fiscal Year of Ledger
     */
    @SerializedName( "LedgerFiscalYear" )
    @JsonProperty( "LedgerFiscalYear" )
    @Nullable
    @ODataField( odataName = "LedgerFiscalYear" )
    private String ledgerFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>LedgerFiscalYear</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> LEDGER_FISCAL_YEAR =
        new IsSettlementResultField<String>("LedgerFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocument</b>
     * </p>
     *
     * @return Partner Sales Doc.
     */
    @SerializedName( "PartnerSalesDocument" )
    @JsonProperty( "PartnerSalesDocument" )
    @Nullable
    @ODataField( odataName = "PartnerSalesDocument" )
    private String partnerSalesDocument;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSalesDocument</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_SALES_DOCUMENT =
        new IsSettlementResultField<String>("PartnerSalesDocument");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountAssignment</b>
     * </p>
     *
     * @return Partner Account Assignment
     */
    @SerializedName( "PartnerAccountAssignment" )
    @JsonProperty( "PartnerAccountAssignment" )
    @Nullable
    @ODataField( odataName = "PartnerAccountAssignment" )
    private String partnerAccountAssignment;
    /**
     * Use with available fluent helpers to apply the <b>PartnerAccountAssignment</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_ACCOUNT_ASSIGNMENT =
        new IsSettlementResultField<String>("PartnerAccountAssignment");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccount</b>
     * </p>
     *
     * @return Offsetting Account
     */
    @SerializedName( "OffsettingAccount" )
    @JsonProperty( "OffsettingAccount" )
    @Nullable
    @ODataField( odataName = "OffsettingAccount" )
    private String offsettingAccount;
    /**
     * Use with available fluent helpers to apply the <b>OffsettingAccount</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> OFFSETTING_ACCOUNT =
        new IsSettlementResultField<String>("OffsettingAccount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBudgetPeriod</b>
     * </p>
     *
     * @return Partner Budget Period
     */
    @SerializedName( "PartnerBudgetPeriod" )
    @JsonProperty( "PartnerBudgetPeriod" )
    @Nullable
    @ODataField( odataName = "PartnerBudgetPeriod" )
    private String partnerBudgetPeriod;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBudgetPeriod</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_BUDGET_PERIOD =
        new IsSettlementResultField<String>("PartnerBudgetPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocCreatedByUser</b>
     * </p>
     *
     * @return Journal Entry Created By
     */
    @SerializedName( "AccountingDocCreatedByUser" )
    @JsonProperty( "AccountingDocCreatedByUser" )
    @Nullable
    @ODataField( odataName = "AccountingDocCreatedByUser" )
    private String accountingDocCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocCreatedByUser</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ACCOUNTING_DOC_CREATED_BY_USER =
        new IsSettlementResultField<String>("AccountingDocCreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency4</b>
     * </p>
     *
     * @return Freely Defined Currency 4
     */
    @SerializedName( "FreeDefinedCurrency4" )
    @JsonProperty( "FreeDefinedCurrency4" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency4" )
    private String freeDefinedCurrency4;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency4</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FREE_DEFINED_CURRENCY4 =
        new IsSettlementResultField<String>("FreeDefinedCurrency4");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @return Network
     */
    @SerializedName( "ProjectNetwork" )
    @JsonProperty( "ProjectNetwork" )
    @Nullable
    @ODataField( odataName = "ProjectNetwork" )
    private String projectNetwork;
    /**
     * Use with available fluent helpers to apply the <b>ProjectNetwork</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PROJECT_NETWORK =
        new IsSettlementResultField<String>("ProjectNetwork");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LineItemIsCompleted</b>
     * </p>
     *
     * @return Line Item is Completed
     */
    @SerializedName( "LineItemIsCompleted" )
    @JsonProperty( "LineItemIsCompleted" )
    @Nullable
    @ODataField( odataName = "LineItemIsCompleted" )
    private String lineItemIsCompleted;
    /**
     * Use with available fluent helpers to apply the <b>LineItemIsCompleted</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> LINE_ITEM_IS_COMPLETED =
        new IsSettlementResultField<String>("LineItemIsCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectInternalID</b>
     * </p>
     *
     * @return Partner Project Internal ID
     */
    @SerializedName( "PartnerProjectInternalID" )
    @JsonProperty( "PartnerProjectInternalID" )
    @Nullable
    @ODataField( odataName = "PartnerProjectInternalID" )
    private String partnerProjectInternalID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProjectInternalID</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_PROJECT_INTERNAL_ID =
        new IsSettlementResultField<String>("PartnerProjectInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureCostRecoveryCode</b>
     * </p>
     *
     * @return Joint Venture Cost Recovery Code
     */
    @SerializedName( "JointVentureCostRecoveryCode" )
    @JsonProperty( "JointVentureCostRecoveryCode" )
    @Nullable
    @ODataField( odataName = "JointVentureCostRecoveryCode" )
    private String jointVentureCostRecoveryCode;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureCostRecoveryCode</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> JOINT_VENTURE_COST_RECOVERY_CODE =
        new IsSettlementResultField<String>("JointVentureCostRecoveryCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockSupplier</b>
     * </p>
     *
     * @return Inventory Special Stock Supplier
     */
    @SerializedName( "InventorySpecialStockSupplier" )
    @JsonProperty( "InventorySpecialStockSupplier" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockSupplier" )
    private String inventorySpecialStockSupplier;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockSupplier</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> INVENTORY_SPECIAL_STOCK_SUPPLIER =
        new IsSettlementResultField<String>("InventorySpecialStockSupplier");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpecialStockSupplierName</b>
     * </p>
     *
     * @return Inventory Special Stock Supplier (Description)
     */
    @SerializedName( "InvtrySpecialStockSupplierName" )
    @JsonProperty( "InvtrySpecialStockSupplierName" )
    @Nullable
    @ODataField( odataName = "InvtrySpecialStockSupplierName" )
    private String invtrySpecialStockSupplierName;
    /**
     * Use with available fluent helpers to apply the <b>InvtrySpecialStockSupplierName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> INVTRY_SPECIAL_STOCK_SUPPLIER_NAME =
        new IsSettlementResultField<String>("InvtrySpecialStockSupplierName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentType</b>
     * </p>
     *
     * @return Account Assignment Type
     */
    @SerializedName( "AccountAssignmentType" )
    @JsonProperty( "AccountAssignmentType" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentType" )
    private String accountAssignmentType;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ACCOUNT_ASSIGNMENT_TYPE =
        new IsSettlementResultField<String>("AccountAssignmentType");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductGroup</b>
     * </p>
     *
     * @return Product Sold Group
     */
    @SerializedName( "SoldProductGroup" )
    @JsonProperty( "SoldProductGroup" )
    @Nullable
    @ODataField( odataName = "SoldProductGroup" )
    private String soldProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>SoldProductGroup</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> SOLD_PRODUCT_GROUP =
        new IsSettlementResultField<String>("SoldProductGroup");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupName</b>
     * </p>
     *
     * @return Product Sold Group (Description)
     */
    @SerializedName( "MaterialGroupName" )
    @JsonProperty( "MaterialGroupName" )
    @Nullable
    @ODataField( odataName = "MaterialGroupName" )
    private String materialGroupName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroupName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> MATERIAL_GROUP_NAME =
        new IsSettlementResultField<String>("MaterialGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProject</b>
     * </p>
     *
     * @return Partner Project
     */
    @SerializedName( "PartnerProject" )
    @JsonProperty( "PartnerProject" )
    @Nullable
    @ODataField( odataName = "PartnerProject" )
    private String partnerProject;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProject</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_PROJECT =
        new IsSettlementResultField<String>("PartnerProject");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ClearingJournalEntryFiscalYear</b>
     * </p>
     *
     * @return Fiscal Year of Clearing Journal Entry
     */
    @SerializedName( "ClearingJournalEntryFiscalYear" )
    @JsonProperty( "ClearingJournalEntryFiscalYear" )
    @Nullable
    @ODataField( odataName = "ClearingJournalEntryFiscalYear" )
    private String clearingJournalEntryFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>ClearingJournalEntryFiscalYear</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CLEARING_JOURNAL_ENTRY_FISCAL_YEAR =
        new IsSettlementResultField<String>("ClearingJournalEntryFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     *
     * @return Trading Partner
     */
    @SerializedName( "PartnerCompany" )
    @JsonProperty( "PartnerCompany" )
    @Nullable
    @ODataField( odataName = "PartnerCompany" )
    private String partnerCompany;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCompany</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_COMPANY =
        new IsSettlementResultField<String>("PartnerCompany");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     *
     * @return Logical System
     */
    @SerializedName( "LogicalSystem" )
    @JsonProperty( "LogicalSystem" )
    @Nullable
    @ODataField( odataName = "LogicalSystem" )
    private String logicalSystem;
    /**
     * Use with available fluent helpers to apply the <b>LogicalSystem</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> LOGICAL_SYSTEM =
        new IsSettlementResultField<String>("LogicalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelNumber</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "PersonnelNumber" )
    @JsonProperty( "PersonnelNumber" )
    @Nullable
    @ODataField( odataName = "PersonnelNumber" )
    private String personnelNumber;
    /**
     * Use with available fluent helpers to apply the <b>PersonnelNumber</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PERSONNEL_NUMBER =
        new IsSettlementResultField<String>("PersonnelNumber");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GroupMasterFixedAsset</b>
     * </p>
     *
     * @return Group Asset
     */
    @SerializedName( "GroupMasterFixedAsset" )
    @JsonProperty( "GroupMasterFixedAsset" )
    @Nullable
    @ODataField( odataName = "GroupMasterFixedAsset" )
    private String groupMasterFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>GroupMasterFixedAsset</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> GROUP_MASTER_FIXED_ASSET =
        new IsSettlementResultField<String>("GroupMasterFixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @SerializedName( "SalesDocumentItem" )
    @JsonProperty( "SalesDocumentItem" )
    @Nullable
    @ODataField( odataName = "SalesDocumentItem" )
    private String salesDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentItem</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> SALES_DOCUMENT_ITEM =
        new IsSettlementResultField<String>("SalesDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrderCategory</b>
     * </p>
     *
     * @return Partner Order Cat.
     */
    @SerializedName( "PartnerOrderCategory" )
    @JsonProperty( "PartnerOrderCategory" )
    @Nullable
    @ODataField( odataName = "PartnerOrderCategory" )
    private String partnerOrderCategory;
    /**
     * Use with available fluent helpers to apply the <b>PartnerOrderCategory</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_ORDER_CATEGORY =
        new IsSettlementResultField<String>("PartnerOrderCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea</b>
     * </p>
     *
     * @return Partner Bus. Area
     */
    @SerializedName( "PartnerBusinessArea" )
    @JsonProperty( "PartnerBusinessArea" )
    @Nullable
    @ODataField( odataName = "PartnerBusinessArea" )
    private String partnerBusinessArea;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBusinessArea</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_BUSINESS_AREA =
        new IsSettlementResultField<String>("PartnerBusinessArea");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessAreaName</b>
     * </p>
     *
     * @return Partner Bus. Area (Description)
     */
    @SerializedName( "PartnerBusinessAreaName" )
    @JsonProperty( "PartnerBusinessAreaName" )
    @Nullable
    @ODataField( odataName = "PartnerBusinessAreaName" )
    private String partnerBusinessAreaName;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBusinessAreaName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_BUSINESS_AREA_NAME =
        new IsSettlementResultField<String>("PartnerBusinessAreaName");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalArea</b>
     * </p>
     *
     * @return Partner Func. Area
     */
    @SerializedName( "PartnerFunctionalArea" )
    @JsonProperty( "PartnerFunctionalArea" )
    @Nullable
    @ODataField( odataName = "PartnerFunctionalArea" )
    private String partnerFunctionalArea;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunctionalArea</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_FUNCTIONAL_AREA =
        new IsSettlementResultField<String>("PartnerFunctionalArea");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalAreaName</b>
     * </p>
     *
     * @return Partner Func. Area (Description)
     */
    @SerializedName( "PartnerFunctionalAreaName" )
    @JsonProperty( "PartnerFunctionalAreaName" )
    @Nullable
    @ODataField( odataName = "PartnerFunctionalAreaName" )
    private String partnerFunctionalAreaName;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunctionalAreaName</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_FUNCTIONAL_AREA_NAME =
        new IsSettlementResultField<String>("PartnerFunctionalAreaName");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProjectExternalID</b>
     * </p>
     *
     * @return Project External ID
     */
    @SerializedName( "ProjectExternalID" )
    @JsonProperty( "ProjectExternalID" )
    @Nullable
    @ODataField( odataName = "ProjectExternalID" )
    private String projectExternalID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectExternalID</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PROJECT_EXTERNAL_ID =
        new IsSettlementResultField<String>("ProjectExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OriginCostCenter</b>
     * </p>
     *
     * @return Origin Cost Center
     */
    @SerializedName( "OriginCostCenter" )
    @JsonProperty( "OriginCostCenter" )
    @Nullable
    @ODataField( odataName = "OriginCostCenter" )
    private String originCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>OriginCostCenter</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ORIGIN_COST_CENTER =
        new IsSettlementResultField<String>("OriginCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency5</b>
     * </p>
     *
     * @return Freely Defined Currency 5
     */
    @SerializedName( "FreeDefinedCurrency5" )
    @JsonProperty( "FreeDefinedCurrency5" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency5" )
    private String freeDefinedCurrency5;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency5</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FREE_DEFINED_CURRENCY5 =
        new IsSettlementResultField<String>("FreeDefinedCurrency5");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @return Company Code Currency
     */
    @SerializedName( "CompanyCodeCurrency" )
    @JsonProperty( "CompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCurrency" )
    private String companyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> COMPANY_CODE_CURRENCY =
        new IsSettlementResultField<String>("CompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OriginObjectType</b>
     * </p>
     *
     * @return Origin Object Type
     */
    @SerializedName( "OriginObjectType" )
    @JsonProperty( "OriginObjectType" )
    @Nullable
    @ODataField( odataName = "OriginObjectType" )
    private String originObjectType;
    /**
     * Use with available fluent helpers to apply the <b>OriginObjectType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ORIGIN_OBJECT_TYPE =
        new IsSettlementResultField<String>("OriginObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectDebitType</b>
     * </p>
     *
     * @return Controlling Object Debit Type
     */
    @SerializedName( "ControllingObjectDebitType" )
    @JsonProperty( "ControllingObjectDebitType" )
    @Nullable
    @ODataField( odataName = "ControllingObjectDebitType" )
    private String controllingObjectDebitType;
    /**
     * Use with available fluent helpers to apply the <b>ControllingObjectDebitType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CONTROLLING_OBJECT_DEBIT_TYPE =
        new IsSettlementResultField<String>("ControllingObjectDebitType");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElementInternalID</b>
     * </p>
     *
     * @return Partner WBS Element Internal ID
     */
    @SerializedName( "PartnerWBSElementInternalID" )
    @JsonProperty( "PartnerWBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "PartnerWBSElementInternalID" )
    private String partnerWBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerWBSElementInternalID</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_WBS_ELEMENT_INTERNAL_ID =
        new IsSettlementResultField<String>("PartnerWBSElementInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountHierarchy</b>
     * </p>
     *
     * @return G/L Account
     */
    @SerializedName( "GLAccountHierarchy" )
    @JsonProperty( "GLAccountHierarchy" )
    @Nullable
    @ODataField( odataName = "GLAccountHierarchy" )
    private String gLAccountHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountHierarchy</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> GL_ACCOUNT_HIERARCHY =
        new IsSettlementResultField<String>("GLAccountHierarchy");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CustomerServiceNotification</b>
     * </p>
     *
     * @return Customer Service Notification
     */
    @SerializedName( "CustomerServiceNotification" )
    @JsonProperty( "CustomerServiceNotification" )
    @Nullable
    @ODataField( odataName = "CustomerServiceNotification" )
    private String customerServiceNotification;
    /**
     * Use with available fluent helpers to apply the <b>CustomerServiceNotification</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CUSTOMER_SERVICE_NOTIFICATION =
        new IsSettlementResultField<String>("CustomerServiceNotification");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency7</b>
     * </p>
     *
     * @return Freely Defined Currency 7
     */
    @SerializedName( "FreeDefinedCurrency7" )
    @JsonProperty( "FreeDefinedCurrency7" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency7" )
    private String freeDefinedCurrency7;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency7</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> FREE_DEFINED_CURRENCY7 =
        new IsSettlementResultField<String>("FreeDefinedCurrency7");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentNumber</b>
     * </p>
     *
     * @return Account Assignment Number
     */
    @SerializedName( "AccountAssignmentNumber" )
    @JsonProperty( "AccountAssignmentNumber" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentNumber" )
    private String accountAssignmentNumber;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentNumber</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> ACCOUNT_ASSIGNMENT_NUMBER =
        new IsSettlementResultField<String>("AccountAssignmentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> SALES_ORGANIZATION =
        new IsSettlementResultField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TransactionTypeDetermination</b>
     * </p>
     *
     * @return Transaction Key
     */
    @SerializedName( "TransactionTypeDetermination" )
    @JsonProperty( "TransactionTypeDetermination" )
    @Nullable
    @ODataField( odataName = "TransactionTypeDetermination" )
    private String transactionTypeDetermination;
    /**
     * Use with available fluent helpers to apply the <b>TransactionTypeDetermination</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> TRANSACTION_TYPE_DETERMINATION =
        new IsSettlementResultField<String>("TransactionTypeDetermination");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectNetwork</b>
     * </p>
     *
     * @return Partner Project Network
     */
    @SerializedName( "PartnerProjectNetwork" )
    @JsonProperty( "PartnerProjectNetwork" )
    @Nullable
    @ODataField( odataName = "PartnerProjectNetwork" )
    private String partnerProjectNetwork;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProjectNetwork</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_PROJECT_NETWORK =
        new IsSettlementResultField<String>("PartnerProjectNetwork");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompanyCode</b>
     * </p>
     *
     * @return Partner Company Code
     */
    @SerializedName( "PartnerCompanyCode" )
    @JsonProperty( "PartnerCompanyCode" )
    @Nullable
    @ODataField( odataName = "PartnerCompanyCode" )
    private String partnerCompanyCode;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCompanyCode</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_COMPANY_CODE =
        new IsSettlementResultField<String>("PartnerCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Item
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> SALES_ORDER_ITEM =
        new IsSettlementResultField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccountType</b>
     * </p>
     *
     * @return Offsetting Account Type
     */
    @SerializedName( "OffsettingAccountType" )
    @JsonProperty( "OffsettingAccountType" )
    @Nullable
    @ODataField( odataName = "OffsettingAccountType" )
    private String offsettingAccountType;
    /**
     * Use with available fluent helpers to apply the <b>OffsettingAccountType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> OFFSETTING_ACCOUNT_TYPE =
        new IsSettlementResultField<String>("OffsettingAccountType");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYearWeek</b>
     * </p>
     *
     * @return Year and Calendar Week
     */
    @SerializedName( "CalendarYearWeek" )
    @JsonProperty( "CalendarYearWeek" )
    @Nullable
    @ODataField( odataName = "CalendarYearWeek" )
    private String calendarYearWeek;
    /**
     * Use with available fluent helpers to apply the <b>CalendarYearWeek</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> CALENDAR_YEAR_WEEK =
        new IsSettlementResultField<String>("CalendarYearWeek");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SenderAccountAssignmentType</b>
     * </p>
     *
     * @return Sender Account Assignment Type
     */
    @SerializedName( "SenderAccountAssignmentType" )
    @JsonProperty( "SenderAccountAssignmentType" )
    @Nullable
    @ODataField( odataName = "SenderAccountAssignmentType" )
    private String senderAccountAssignmentType;
    /**
     * Use with available fluent helpers to apply the <b>SenderAccountAssignmentType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> SENDER_ACCOUNT_ASSIGNMENT_TYPE =
        new IsSettlementResultField<String>("SenderAccountAssignmentType");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @return Purchasing Doc. Item
     */
    @SerializedName( "PurchasingDocumentItem" )
    @JsonProperty( "PurchasingDocumentItem" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItem" )
    private String purchasingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItem</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PURCHASING_DOCUMENT_ITEM =
        new IsSettlementResultField<String>("PurchasingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SenderGLAccount</b>
     * </p>
     *
     * @return Sender G/L Account
     */
    @SerializedName( "SenderGLAccount" )
    @JsonProperty( "SenderGLAccount" )
    @Nullable
    @ODataField( odataName = "SenderGLAccount" )
    private String senderGLAccount;
    /**
     * Use with available fluent helpers to apply the <b>SenderGLAccount</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> SENDER_GL_ACCOUNT =
        new IsSettlementResultField<String>("SenderGLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocumentItem</b>
     * </p>
     *
     * @return Partner Sales Document Item
     */
    @SerializedName( "PartnerSalesDocumentItem" )
    @JsonProperty( "PartnerSalesDocumentItem" )
    @Nullable
    @ODataField( odataName = "PartnerSalesDocumentItem" )
    private String partnerSalesDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSalesDocumentItem</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> PARTNER_SALES_DOCUMENT_ITEM =
        new IsSettlementResultField<String>("PartnerSalesDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventoryValuationType</b>
     * </p>
     *
     * @return Inventory Valuation Type
     */
    @SerializedName( "InventoryValuationType" )
    @JsonProperty( "InventoryValuationType" )
    @Nullable
    @ODataField( odataName = "InventoryValuationType" )
    private String inventoryValuationType;
    /**
     * Use with available fluent helpers to apply the <b>InventoryValuationType</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> INVENTORY_VALUATION_TYPE =
        new IsSettlementResultField<String>("InventoryValuationType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SettlementReferenceDate</b>
     * </p>
     *
     * @return Settlement Reference Date
     */
    @SerializedName( "SettlementReferenceDate" )
    @JsonProperty( "SettlementReferenceDate" )
    @Nullable
    @ODataField( odataName = "SettlementReferenceDate" )
    private String settlementReferenceDate;
    /**
     * Use with available fluent helpers to apply the <b>SettlementReferenceDate</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> SETTLEMENT_REFERENCE_DATE =
        new IsSettlementResultField<String>("SettlementReferenceDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SettlementReferenceDate_T</b>
     * </p>
     *
     * @return Settlement Reference Date (Description)
     */
    @SerializedName( "SettlementReferenceDate_T" )
    @JsonProperty( "SettlementReferenceDate_T" )
    @Nullable
    @ODataField( odataName = "SettlementReferenceDate_T" )
    private String settlementReferenceDate_T;
    /**
     * Use with available fluent helpers to apply the <b>SettlementReferenceDate_T</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> SETTLEMENT_REFERENCE_DATE_T =
        new IsSettlementResultField<String>("SettlementReferenceDate_T");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static IsSettlementResultField<String> DISTRIBUTION_CHANNEL =
        new IsSettlementResultField<String>("DistributionChannel");

    @Nonnull
    @Override
    public Class<IsSettlementResult> getType()
    {
        return IsSettlementResult.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSettlement</b>
     * </p>
     *
     * @param isSettlement
     *            Is Settling
     */
    public void setIsSettlement( @Nullable final String isSettlement )
    {
        rememberChangedField("IsSettlement", this.isSettlement);
        this.isSettlement = isSettlement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @param companyCodeName
     *            Company Code (Description)
     */
    public void setCompanyCodeName( @Nullable final String companyCodeName )
    {
        rememberChangedField("CompanyCodeName", this.companyCodeName);
        this.companyCodeName = companyCodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountHierarchyName</b>
     * </p>
     *
     * @param gLAccountHierarchyName
     *            G/L Account (Description)
     */
    public void setGLAccountHierarchyName( @Nullable final String gLAccountHierarchyName )
    {
        rememberChangedField("GLAccountHierarchyName", this.gLAccountHierarchyName);
        this.gLAccountHierarchyName = gLAccountHierarchyName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @param businessProcess
     *            Business Process
     */
    public void setBusinessProcess( @Nullable final String businessProcess )
    {
        rememberChangedField("BusinessProcess", this.businessProcess);
        this.businessProcess = businessProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency8</b>
     * </p>
     *
     * @param freeDefinedCurrency8
     *            Freely Defined Currency 8
     */
    public void setFreeDefinedCurrency8( @Nullable final String freeDefinedCurrency8 )
    {
        rememberChangedField("FreeDefinedCurrency8", this.freeDefinedCurrency8);
        this.freeDefinedCurrency8 = freeDefinedCurrency8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostObject</b>
     * </p>
     *
     * @param partnerCostObject
     *            Partner Cost Object
     */
    public void setPartnerCostObject( @Nullable final String partnerCostObject )
    {
        rememberChangedField("PartnerCostObject", this.partnerCostObject);
        this.partnerCostObject = partnerCostObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AssetValueDate</b>
     * </p>
     *
     * @param assetValueDate
     *            Asset Value Date
     */
    public void setAssetValueDate( @Nullable final String assetValueDate )
    {
        rememberChangedField("AssetValueDate", this.assetValueDate);
        this.assetValueDate = assetValueDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AssetValueDate_T</b>
     * </p>
     *
     * @param assetValueDate_T
     *            Asset Value Date (Description)
     */
    public void setAssetValueDate_T( @Nullable final String assetValueDate_T )
    {
        rememberChangedField("AssetValueDate_T", this.assetValueDate_T);
        this.assetValueDate_T = assetValueDate_T;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearPeriod</b>
     * </p>
     *
     * @param fiscalYearPeriod
     *            Fiscal Year Period
     */
    public void setFiscalYearPeriod( @Nullable final String fiscalYearPeriod )
    {
        rememberChangedField("FiscalYearPeriod", this.fiscalYearPeriod);
        this.fiscalYearPeriod = fiscalYearPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsIncomplete</b>
     * </p>
     *
     * @param quantityIsIncomplete
     *            Qty Is Incomplete
     */
    public void setQuantityIsIncomplete( @Nullable final String quantityIsIncomplete )
    {
        rememberChangedField("QuantityIsIncomplete", this.quantityIsIncomplete);
        this.quantityIsIncomplete = quantityIsIncomplete;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsOpenItemManaged</b>
     * </p>
     *
     * @param isOpenItemManaged
     *            Open Item Management
     */
    public void setIsOpenItemManaged( @Nullable final String isOpenItemManaged )
    {
        rememberChangedField("IsOpenItemManaged", this.isOpenItemManaged);
        this.isOpenItemManaged = isOpenItemManaged;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupAccount</b>
     * </p>
     *
     * @param corporateGroupAccount
     *            Group Account Number
     */
    public void setCorporateGroupAccount( @Nullable final String corporateGroupAccount )
    {
        rememberChangedField("CorporateGroupAccount", this.corporateGroupAccount);
        this.corporateGroupAccount = corporateGroupAccount;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupAccount_T</b>
     * </p>
     *
     * @param corporateGroupAccount_T
     *            Group Account Number (Description)
     */
    public void setCorporateGroupAccount_T( @Nullable final String corporateGroupAccount_T )
    {
        rememberChangedField("CorporateGroupAccount_T", this.corporateGroupAccount_T);
        this.corporateGroupAccount_T = corporateGroupAccount_T;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentType</b>
     * </p>
     *
     * @param billingDocumentType
     *            Billing Type
     */
    public void setBillingDocumentType( @Nullable final String billingDocumentType )
    {
        rememberChangedField("BillingDocumentType", this.billingDocumentType);
        this.billingDocumentType = billingDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FiscalQuarter</b>
     * </p>
     *
     * @param fiscalQuarter
     *            Fiscal Quarter
     */
    public void setFiscalQuarter( @Nullable final String fiscalQuarter )
    {
        rememberChangedField("FiscalQuarter", this.fiscalQuarter);
        this.fiscalQuarter = fiscalQuarter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupChartOfAccounts</b>
     * </p>
     *
     * @param corporateGroupChartOfAccounts
     *            Group Chart of Accts
     */
    public void setCorporateGroupChartOfAccounts( @Nullable final String corporateGroupChartOfAccounts )
    {
        rememberChangedField("CorporateGroupChartOfAccounts", this.corporateGroupChartOfAccounts);
        this.corporateGroupChartOfAccounts = corporateGroupChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDocFiscalYear</b>
     * </p>
     *
     * @param clearingDocFiscalYear
     *            Fiscal Year of Clearing JE (Depr.)
     */
    public void setClearingDocFiscalYear( @Nullable final String clearingDocFiscalYear )
    {
        rememberChangedField("ClearingDocFiscalYear", this.clearingDocFiscalYear);
        this.clearingDocFiscalYear = clearingDocFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElement</b>
     * </p>
     *
     * @param partnerWBSElement
     *            Partner WBS Element
     */
    public void setPartnerWBSElement( @Nullable final String partnerWBSElement )
    {
        rememberChangedField("PartnerWBSElement", this.partnerWBSElement);
        this.partnerWBSElement = partnerWBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency2</b>
     * </p>
     *
     * @param freeDefinedCurrency2
     *            Freely Defined Currency 2
     */
    public void setFreeDefinedCurrency2( @Nullable final String freeDefinedCurrency2 )
    {
        rememberChangedField("FreeDefinedCurrency2", this.freeDefinedCurrency2);
        this.freeDefinedCurrency2 = freeDefinedCurrency2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenter</b>
     * </p>
     *
     * @param partnerProfitCenter
     *            Partner Profit Center
     */
    public void setPartnerProfitCenter( @Nullable final String partnerProfitCenter )
    {
        rememberChangedField("PartnerProfitCenter", this.partnerProfitCenter);
        this.partnerProfitCenter = partnerProfitCenter;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenterName</b>
     * </p>
     *
     * @param partnerProfitCenterName
     *            Partner Profit Center (Description)
     */
    public void setPartnerProfitCenterName( @Nullable final String partnerProfitCenterName )
    {
        rememberChangedField("PartnerProfitCenterName", this.partnerProfitCenterName);
        this.partnerProfitCenterName = partnerProfitCenterName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerControllingObjectClass</b>
     * </p>
     *
     * @param partnerControllingObjectClass
     *            Partner Controlling Object Class
     */
    public void setPartnerControllingObjectClass( @Nullable final String partnerControllingObjectClass )
    {
        rememberChangedField("PartnerControllingObjectClass", this.partnerControllingObjectClass);
        this.partnerControllingObjectClass = partnerControllingObjectClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountType</b>
     * </p>
     *
     * @param gLAccountType
     *            G/L Account Type
     */
    public void setGLAccountType( @Nullable final String gLAccountType )
    {
        rememberChangedField("GLAccountType", this.gLAccountType);
        this.gLAccountType = gLAccountType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCategory</b>
     * </p>
     *
     * @param accountingDocumentCategory
     *            Journal Entry Category
     */
    public void setAccountingDocumentCategory( @Nullable final String accountingDocumentCategory )
    {
        rememberChangedField("AccountingDocumentCategory", this.accountingDocumentCategory);
        this.accountingDocumentCategory = accountingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessTransactionType</b>
     * </p>
     *
     * @param businessTransactionType
     *            Business Transaction Type
     */
    public void setBusinessTransactionType( @Nullable final String businessTransactionType )
    {
        rememberChangedField("BusinessTransactionType", this.businessTransactionType);
        this.businessTransactionType = businessTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CalendarMonth</b>
     * </p>
     *
     * @param calendarMonth
     *            Calendar Month
     */
    public void setCalendarMonth( @Nullable final String calendarMonth )
    {
        rememberChangedField("CalendarMonth", this.calendarMonth);
        this.calendarMonth = calendarMonth;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CalendarQuarter</b>
     * </p>
     *
     * @param calendarQuarter
     *            Calendar Quarter
     */
    public void setCalendarQuarter( @Nullable final String calendarQuarter )
    {
        rememberChangedField("CalendarQuarter", this.calendarQuarter);
        this.calendarQuarter = calendarQuarter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingAccountingDocument</b>
     * </p>
     *
     * @param clearingAccountingDocument
     *            Clearing Journal Entry (Deprecated)
     */
    public void setClearingAccountingDocument( @Nullable final String clearingAccountingDocument )
    {
        rememberChangedField("ClearingAccountingDocument", this.clearingAccountingDocument);
        this.clearingAccountingDocument = clearingAccountingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentType</b>
     * </p>
     *
     * @param accountingDocumentType
     *            Journal Entry Type
     */
    public void setAccountingDocumentType( @Nullable final String accountingDocumentType )
    {
        rememberChangedField("AccountingDocumentType", this.accountingDocumentType);
        this.accountingDocumentType = accountingDocumentType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentTypeName</b>
     * </p>
     *
     * @param accountingDocumentTypeName
     *            Journal Entry Type (Description)
     */
    public void setAccountingDocumentTypeName( @Nullable final String accountingDocumentTypeName )
    {
        rememberChangedField("AccountingDocumentTypeName", this.accountingDocumentTypeName);
        this.accountingDocumentTypeName = accountingDocumentTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountType</b>
     * </p>
     *
     * @param financialAccountType
     *            Account Type
     */
    public void setFinancialAccountType( @Nullable final String financialAccountType )
    {
        rememberChangedField("FinancialAccountType", this.financialAccountType);
        this.financialAccountType = financialAccountType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountTypeName</b>
     * </p>
     *
     * @param financialAccountTypeName
     *            Account Type (Description)
     */
    public void setFinancialAccountTypeName( @Nullable final String financialAccountTypeName )
    {
        rememberChangedField("FinancialAccountTypeName", this.financialAccountTypeName);
        this.financialAccountTypeName = financialAccountTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessAreaName</b>
     * </p>
     *
     * @param businessAreaName
     *            Business Area (Description)
     */
    public void setBusinessAreaName( @Nullable final String businessAreaName )
    {
        rememberChangedField("BusinessAreaName", this.businessAreaName);
        this.businessAreaName = businessAreaName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OriginCostCtrActivityType</b>
     * </p>
     *
     * @param originCostCtrActivityType
     *            Origin Cost Center Activity Type
     */
    public void setOriginCostCtrActivityType( @Nullable final String originCostCtrActivityType )
    {
        rememberChangedField("OriginCostCtrActivityType", this.originCostCtrActivityType);
        this.originCostCtrActivityType = originCostCtrActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaName</b>
     * </p>
     *
     * @param controllingAreaName
     *            Controlling Area (Description)
     */
    public void setControllingAreaName( @Nullable final String controllingAreaName )
    {
        rememberChangedField("ControllingAreaName", this.controllingAreaName);
        this.controllingAreaName = controllingAreaName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectClass</b>
     * </p>
     *
     * @param controllingObjectClass
     *            Controlling Object Class
     */
    public void setControllingObjectClass( @Nullable final String controllingObjectClass )
    {
        rememberChangedField("ControllingObjectClass", this.controllingObjectClass);
        this.controllingObjectClass = controllingObjectClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenter</b>
     * </p>
     *
     * @param partnerCostCenter
     *            Partner Cost Center
     */
    public void setPartnerCostCenter( @Nullable final String partnerCostCenter )
    {
        rememberChangedField("PartnerCostCenter", this.partnerCostCenter);
        this.partnerCostCenter = partnerCostCenter;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SenderCostCenterName</b>
     * </p>
     *
     * @param senderCostCenterName
     *            Partner Cost Center (Description)
     */
    public void setSenderCostCenterName( @Nullable final String senderCostCenterName )
    {
        rememberChangedField("SenderCostCenterName", this.senderCostCenterName);
        this.senderCostCenterName = senderCostCenterName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @param debitCreditCode
     *            Debit/Credit Code
     */
    public void setDebitCreditCode( @Nullable final String debitCreditCode )
    {
        rememberChangedField("DebitCreditCode", this.debitCreditCode);
        this.debitCreditCode = debitCreditCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCodeName</b>
     * </p>
     *
     * @param debitCreditCodeName
     *            Debit/Credit Code (Description)
     */
    public void setDebitCreditCodeName( @Nullable final String debitCreditCodeName )
    {
        rememberChangedField("DebitCreditCodeName", this.debitCreditCodeName);
        this.debitCreditCodeName = debitCreditCodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date
     */
    public void setPostingDate( @Nullable final String postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate_T</b>
     * </p>
     *
     * @param postingDate_T
     *            Posting Date (Description)
     */
    public void setPostingDate_T( @Nullable final String postingDate_T )
    {
        rememberChangedField("PostingDate_T", this.postingDate_T);
        this.postingDate_T = postingDate_T;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @param fiscalYearVariant
     *            Fiscal Year Variant
     */
    public void setFiscalYearVariant( @Nullable final String fiscalYearVariant )
    {
        rememberChangedField("FiscalYearVariant", this.fiscalYearVariant);
        this.fiscalYearVariant = fiscalYearVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalAreaName</b>
     * </p>
     *
     * @param functionalAreaName
     *            Functional Area (Description)
     */
    public void setFunctionalAreaName( @Nullable final String functionalAreaName )
    {
        rememberChangedField("FunctionalAreaName", this.functionalAreaName);
        this.functionalAreaName = functionalAreaName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @param budgetPeriod
     *            Budget Period
     */
    public void setBudgetPeriod( @Nullable final String budgetPeriod )
    {
        rememberChangedField("BudgetPeriod", this.budgetPeriod);
        this.budgetPeriod = budgetPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CalendarWeek</b>
     * </p>
     *
     * @param calendarWeek
     *            Calendar Week
     */
    public void setCalendarWeek( @Nullable final String calendarWeek )
    {
        rememberChangedField("CalendarWeek", this.calendarWeek);
        this.calendarWeek = calendarWeek;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYear</b>
     * </p>
     *
     * @param calendarYear
     *            Calendar Year
     */
    public void setCalendarYear( @Nullable final String calendarYear )
    {
        rememberChangedField("CalendarYear", this.calendarYear);
        this.calendarYear = calendarYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDate</b>
     * </p>
     *
     * @param clearingDate
     *            Clearing Date
     */
    public void setClearingDate( @Nullable final String clearingDate )
    {
        rememberChangedField("ClearingDate", this.clearingDate);
        this.clearingDate = clearingDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDate_T</b>
     * </p>
     *
     * @param clearingDate_T
     *            Clearing Date (Description)
     */
    public void setClearingDate_T( @Nullable final String clearingDate_T )
    {
        rememberChangedField("ClearingDate_T", this.clearingDate_T);
        this.clearingDate_T = clearingDate_T;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterName</b>
     * </p>
     *
     * @param costCenterName
     *            Cost Center (Description)
     */
    public void setCostCenterName( @Nullable final String costCenterName )
    {
        rememberChangedField("CostCenterName", this.costCenterName);
        this.costCenterName = costCenterName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @param costObject
     *            Cost Object
     */
    public void setCostObject( @Nullable final String costObject )
    {
        rememberChangedField("CostObject", this.costObject);
        this.costObject = costObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @param fiscalPeriod
     *            Fiscal Period
     */
    public void setFiscalPeriod( @Nullable final String fiscalPeriod )
    {
        rememberChangedField("FiscalPeriod", this.fiscalPeriod);
        this.fiscalPeriod = fiscalPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalWeek</b>
     * </p>
     *
     * @param fiscalWeek
     *            Fiscal Week
     */
    public void setFiscalWeek( @Nullable final String fiscalWeek )
    {
        rememberChangedField("FiscalWeek", this.fiscalWeek);
        this.fiscalWeek = fiscalWeek;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @param fund
     *            Fund
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @param grantID
     *            Grant
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsReversal</b>
     * </p>
     *
     * @param isReversal
     *            Is Reversing
     */
    public void setIsReversal( @Nullable final String isReversal )
    {
        rememberChangedField("IsReversal", this.isReversal);
        this.isReversal = isReversal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsReversed</b>
     * </p>
     *
     * @param isReversed
     *            Is Reversed
     */
    public void setIsReversed( @Nullable final String isReversed )
    {
        rememberChangedField("IsReversed", this.isReversed);
        this.isReversed = isReversed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSettled</b>
     * </p>
     *
     * @param isSettled
     *            Is Settled
     */
    public void setIsSettled( @Nullable final String isSettled )
    {
        rememberChangedField("IsSettled", this.isSettled);
        this.isSettled = isSettled;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     *
     * @param jointVenture
     *            Joint Venture
     */
    public void setJointVenture( @Nullable final String jointVenture )
    {
        rememberChangedField("JointVenture", this.jointVenture);
        this.jointVenture = jointVenture;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Order ID
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFund</b>
     * </p>
     *
     * @param partnerFund
     *            Partner Fund
     */
    public void setPartnerFund( @Nullable final String partnerFund )
    {
        rememberChangedField("PartnerFund", this.partnerFund);
        this.partnerFund = partnerFund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerGrant</b>
     * </p>
     *
     * @param partnerGrant
     *            Partner Grant
     */
    public void setPartnerGrant( @Nullable final String partnerGrant )
    {
        rememberChangedField("PartnerGrant", this.partnerGrant);
        this.partnerGrant = partnerGrant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrder</b>
     * </p>
     *
     * @param partnerOrder
     *            Partner Order
     */
    public void setPartnerOrder( @Nullable final String partnerOrder )
    {
        rememberChangedField("PartnerOrder", this.partnerOrder);
        this.partnerOrder = partnerOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SoldMaterial</b>
     * </p>
     *
     * @param soldMaterial
     *            Product Sold (Deprecated)
     */
    public void setSoldMaterial( @Nullable final String soldMaterial )
    {
        rememberChangedField("SoldMaterial", this.soldMaterial);
        this.soldMaterial = soldMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SoldProduct</b>
     * </p>
     *
     * @param soldProduct
     *            Product Sold
     */
    public void setSoldProduct( @Nullable final String soldProduct )
    {
        rememberChangedField("SoldProduct", this.soldProduct);
        this.soldProduct = soldProduct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            WBS Element
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     *
     * @param houseBank
     *            House Bank
     */
    public void setHouseBank( @Nullable final String houseBank )
    {
        rememberChangedField("HouseBank", this.houseBank);
        this.houseBank = houseBank;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockValnType</b>
     * </p>
     *
     * @param inventorySpecialStockValnType
     *            Inv. Special Stock Val. Type -Deprecated
     */
    public void setInventorySpecialStockValnType( @Nullable final String inventorySpecialStockValnType )
    {
        rememberChangedField("InventorySpecialStockValnType", this.inventorySpecialStockValnType);
        this.inventorySpecialStockValnType = inventorySpecialStockValnType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @param ledger
     *            Ledger
     */
    public void setLedger( @Nullable final String ledger )
    {
        rememberChangedField("Ledger", this.ledger);
        this.ledger = ledger;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @param masterFixedAsset
     *            Fixed Asset
     */
    public void setMasterFixedAsset( @Nullable final String masterFixedAsset )
    {
        rememberChangedField("MasterFixedAsset", this.masterFixedAsset);
        this.masterFixedAsset = masterFixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingKey</b>
     * </p>
     *
     * @param postingKey
     *            Posting Key
     */
    public void setPostingKey( @Nullable final String postingKey )
    {
        rememberChangedField("PostingKey", this.postingKey);
        this.postingKey = postingKey;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PostingKeyName</b>
     * </p>
     *
     * @param postingKeyName
     *            Posting Key (Description)
     */
    public void setPostingKeyName( @Nullable final String postingKeyName )
    {
        rememberChangedField("PostingKeyName", this.postingKeyName);
        this.postingKeyName = postingKeyName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterName</b>
     * </p>
     *
     * @param profitCenterName
     *            Profit Center (Description)
     */
    public void setProfitCenterName( @Nullable final String profitCenterName )
    {
        rememberChangedField("ProfitCenterName", this.profitCenterName);
        this.profitCenterName = profitCenterName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @param segment
     *            Segment
     */
    public void setSegment( @Nullable final String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SegmentName</b>
     * </p>
     *
     * @param segmentName
     *            Segment (Description)
     */
    public void setSegmentName( @Nullable final String segmentName )
    {
        rememberChangedField("SegmentName", this.segmentName);
        this.segmentName = segmentName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLCode</b>
     * </p>
     *
     * @param specialGLCode
     *            Special G/L
     */
    public void setSpecialGLCode( @Nullable final String specialGLCode )
    {
        rememberChangedField("SpecialGLCode", this.specialGLCode);
        this.specialGLCode = specialGLCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @param financialTransactionType
     *            Financial Transaction Type
     */
    public void setFinancialTransactionType( @Nullable final String financialTransactionType )
    {
        rememberChangedField("FinancialTransactionType", this.financialTransactionType);
        this.financialTransactionType = financialTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @param fixedAsset
     *            Asset Subnumber
     */
    public void setFixedAsset( @Nullable final String fixedAsset )
    {
        rememberChangedField("FixedAsset", this.fixedAsset);
        this.fixedAsset = fixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityType</b>
     * </p>
     *
     * @param jointVentureEquityType
     *            Joint Venture Equity Type
     */
    public void setJointVentureEquityType( @Nullable final String jointVentureEquityType )
    {
        rememberChangedField("JointVentureEquityType", this.jointVentureEquityType);
        this.jointVentureEquityType = jointVentureEquityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount</b>
     * </p>
     *
     * @param houseBankAccount
     *            House Bank Account
     */
    public void setHouseBankAccount( @Nullable final String houseBankAccount )
    {
        rememberChangedField("HouseBankAccount", this.houseBankAccount);
        this.houseBankAccount = houseBankAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @param inventorySpecialStockType
     *            Inventory Special Stock Type
     */
    public void setInventorySpecialStockType( @Nullable final String inventorySpecialStockType )
    {
        rememberChangedField("InventorySpecialStockType", this.inventorySpecialStockType);
        this.inventorySpecialStockType = inventorySpecialStockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeGLAccount</b>
     * </p>
     *
     * @param alternativeGLAccount
     *            Alternative G/L Account
     */
    public void setAlternativeGLAccount( @Nullable final String alternativeGLAccount )
    {
        rememberChangedField("AlternativeGLAccount", this.alternativeGLAccount);
        this.alternativeGLAccount = alternativeGLAccount;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeGLAccount_T</b>
     * </p>
     *
     * @param alternativeGLAccount_T
     *            Alternative G/L Account (Description)
     */
    public void setAlternativeGLAccount_T( @Nullable final String alternativeGLAccount_T )
    {
        rememberChangedField("AlternativeGLAccount_T", this.alternativeGLAccount_T);
        this.alternativeGLAccount_T = alternativeGLAccount_T;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Product (Deprecated)
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Product Sold Group (Deprecated)
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlantName</b>
     * </p>
     *
     * @param plantName
     *            Plant (Description)
     */
    public void setPlantName( @Nullable final String plantName )
    {
        rememberChangedField("PlantName", this.plantName);
        this.plantName = plantName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrderCategory</b>
     * </p>
     *
     * @param orderCategory
     *            Order Category
     */
    public void setOrderCategory( @Nullable final String orderCategory )
    {
        rememberChangedField("OrderCategory", this.orderCategory);
        this.orderCategory = orderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @param materialName
     *            Product (Description)
     */
    public void setMaterialName( @Nullable final String materialName )
    {
        rememberChangedField("MaterialName", this.materialName);
        this.materialName = materialName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup</b>
     * </p>
     *
     * @param productGroup
     *            Product Group
     */
    public void setProductGroup( @Nullable final String productGroup )
    {
        rememberChangedField("ProductGroup", this.productGroup);
        this.productGroup = productGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @param project
     *            Project Definition
     */
    public void setProject( @Nullable final String project )
    {
        rememberChangedField("Project", this.project);
        this.project = project;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @param valuationArea
     *            Valuation Area
     */
    public void setValuationArea( @Nullable final String valuationArea )
    {
        rememberChangedField("ValuationArea", this.valuationArea);
        this.valuationArea = valuationArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @param customerGroup
     *            Customer Group
     */
    public void setCustomerGroup( @Nullable final String customerGroup )
    {
        rememberChangedField("CustomerGroup", this.customerGroup);
        this.customerGroup = customerGroup;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroupName</b>
     * </p>
     *
     * @param customerGroupName
     *            Customer Group (Description)
     */
    public void setCustomerGroupName( @Nullable final String customerGroupName )
    {
        rememberChangedField("CustomerGroupName", this.customerGroupName);
        this.customerGroupName = customerGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocument</b>
     * </p>
     *
     * @param inventorySpclStkSalesDocument
     *            Inventory Special Stock Sales Document
     */
    public void setInventorySpclStkSalesDocument( @Nullable final String inventorySpclStkSalesDocument )
    {
        rememberChangedField("InventorySpclStkSalesDocument", this.inventorySpclStkSalesDocument);
        this.inventorySpclStkSalesDocument = inventorySpclStkSalesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocItm</b>
     * </p>
     *
     * @param inventorySpclStkSalesDocItm
     *            Inventory Spcl Stock Sales Document Item
     */
    public void setInventorySpclStkSalesDocItm( @Nullable final String inventorySpclStkSalesDocItm )
    {
        rememberChangedField("InventorySpclStkSalesDocItm", this.inventorySpclStkSalesDocItm);
        this.inventorySpclStkSalesDocItm = inventorySpclStkSalesDocItm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpclStockWBSElmntIntID</b>
     * </p>
     *
     * @param invtrySpclStockWBSElmntIntID
     *            Inv. Special Stock WBS Element Int. ID
     */
    public void setInvtrySpclStockWBSElmntIntID( @Nullable final String invtrySpclStockWBSElmntIntID )
    {
        rememberChangedField("InvtrySpclStockWBSElmntIntID", this.invtrySpclStockWBSElmntIntID);
        this.invtrySpclStockWBSElmntIntID = invtrySpclStockWBSElmntIntID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStockWBSElement</b>
     * </p>
     *
     * @param inventorySpclStockWBSElement
     *            WBSElem of Inventory
     */
    public void setInventorySpclStockWBSElement( @Nullable final String inventorySpclStockWBSElement )
    {
        rememberChangedField("InventorySpclStockWBSElement", this.inventorySpclStockWBSElement);
        this.inventorySpclStockWBSElement = inventorySpclStockWBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYearMonth</b>
     * </p>
     *
     * @param calendarYearMonth
     *            Year Month
     */
    public void setCalendarYearMonth( @Nullable final String calendarYearMonth )
    {
        rememberChangedField("CalendarYearMonth", this.calendarYearMonth);
        this.calendarYearMonth = calendarYearMonth;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustomerName</b>
     * </p>
     *
     * @param customerName
     *            Customer (Description)
     */
    public void setCustomerName( @Nullable final String customerName )
    {
        rememberChangedField("CustomerName", this.customerName);
        this.customerName = customerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SupplierName</b>
     * </p>
     *
     * @param supplierName
     *            Supplier (Description)
     */
    public void setSupplierName( @Nullable final String supplierName )
    {
        rememberChangedField("SupplierName", this.supplierName);
        this.supplierName = supplierName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BalanceTransactionCurrency</b>
     * </p>
     *
     * @param balanceTransactionCurrency
     *            Balance Transaction Currency
     */
    public void setBalanceTransactionCurrency( @Nullable final String balanceTransactionCurrency )
    {
        rememberChangedField("BalanceTransactionCurrency", this.balanceTransactionCurrency);
        this.balanceTransactionCurrency = balanceTransactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @param assignmentReference
     *            Assignment Reference
     */
    public void setAssignmentReference( @Nullable final String assignmentReference )
    {
        rememberChangedField("AssignmentReference", this.assignmentReference);
        this.assignmentReference = assignmentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            WBS Element External ID
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @param organizationDivision
     *            Division
     */
    public void setOrganizationDivision( @Nullable final String organizationDivision )
    {
        rememberChangedField("OrganizationDivision", this.organizationDivision);
        this.organizationDivision = organizationDivision;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectNetworkActivity</b>
     * </p>
     *
     * @param partnerProjectNetworkActivity
     *            Partner Project Network Activity
     */
    public void setPartnerProjectNetworkActivity( @Nullable final String partnerProjectNetworkActivity )
    {
        rememberChangedField("PartnerProjectNetworkActivity", this.partnerProjectNetworkActivity);
        this.partnerProjectNetworkActivity = partnerProjectNetworkActivity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYearQuarter</b>
     * </p>
     *
     * @param calendarYearQuarter
     *            Year Quarter
     */
    public void setCalendarYearQuarter( @Nullable final String calendarYearQuarter )
    {
        rememberChangedField("CalendarYearQuarter", this.calendarYearQuarter);
        this.calendarYearQuarter = calendarYearQuarter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBalanceSheetAccount</b>
     * </p>
     *
     * @param isBalanceSheetAccount
     *            Balance sheet acct
     */
    public void setIsBalanceSheetAccount( @Nullable final String isBalanceSheetAccount )
    {
        rememberChangedField("IsBalanceSheetAccount", this.isBalanceSheetAccount);
        this.isBalanceSheetAccount = isBalanceSheetAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountAssignmentType</b>
     * </p>
     *
     * @param partnerAccountAssignmentType
     *            Partner Account Assignment Type
     */
    public void setPartnerAccountAssignmentType( @Nullable final String partnerAccountAssignmentType )
    {
        rememberChangedField("PartnerAccountAssignmentType", this.partnerAccountAssignmentType);
        this.partnerAccountAssignmentType = partnerAccountAssignmentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearWeek</b>
     * </p>
     *
     * @param fiscalYearWeek
     *            Fiscal Year Week
     */
    public void setFiscalYearWeek( @Nullable final String fiscalYearWeek )
    {
        rememberChangedField("FiscalYearWeek", this.fiscalYearWeek);
        this.fiscalYearWeek = fiscalYearWeek;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityGroup</b>
     * </p>
     *
     * @param jointVentureEquityGroup
     *            Joint Venture Equity Group
     */
    public void setJointVentureEquityGroup( @Nullable final String jointVentureEquityGroup )
    {
        rememberChangedField("JointVentureEquityGroup", this.jointVentureEquityGroup);
        this.jointVentureEquityGroup = jointVentureEquityGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @param financialManagementArea
     *            FM Area
     */
    public void setFinancialManagementArea( @Nullable final String financialManagementArea )
    {
        rememberChangedField("FinancialManagementArea", this.financialManagementArea);
        this.financialManagementArea = financialManagementArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @param costCtrActivityType
     *            Activity Type
     */
    public void setCostCtrActivityType( @Nullable final String costCtrActivityType )
    {
        rememberChangedField("CostCtrActivityType", this.costCtrActivityType);
        this.costCtrActivityType = costCtrActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SenderAccountAssignment</b>
     * </p>
     *
     * @param senderAccountAssignment
     *            Sender Account Assignment
     */
    public void setSenderAccountAssignment( @Nullable final String senderAccountAssignment )
    {
        rememberChangedField("SenderAccountAssignment", this.senderAccountAssignment);
        this.senderAccountAssignment = senderAccountAssignment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearQuarter</b>
     * </p>
     *
     * @param fiscalYearQuarter
     *            Fiscal Year Quarter
     */
    public void setFiscalYearQuarter( @Nullable final String fiscalYearQuarter )
    {
        rememberChangedField("FiscalYearQuarter", this.fiscalYearQuarter);
        this.fiscalYearQuarter = fiscalYearQuarter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     *
     * @param referenceDocumentType
     *            Reference Document Type
     */
    public void setReferenceDocumentType( @Nullable final String referenceDocumentType )
    {
        rememberChangedField("ReferenceDocumentType", this.referenceDocumentType);
        this.referenceDocumentType = referenceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GroupFixedAsset</b>
     * </p>
     *
     * @param groupFixedAsset
     *            Group Asset Subnmbr
     */
    public void setGroupFixedAsset( @Nullable final String groupFixedAsset )
    {
        rememberChangedField("GroupFixedAsset", this.groupFixedAsset);
        this.groupFixedAsset = groupFixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentItemGroup</b>
     * </p>
     *
     * @param referenceDocumentItemGroup
     *            Reference Document Item Group
     */
    public void setReferenceDocumentItemGroup( @Nullable final String referenceDocumentItemGroup )
    {
        rememberChangedField("ReferenceDocumentItemGroup", this.referenceDocumentItemGroup);
        this.referenceDocumentItemGroup = referenceDocumentItemGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssetDepreciationArea</b>
     * </p>
     *
     * @param assetDepreciationArea
     *            Depreciation Area
     */
    public void setAssetDepreciationArea( @Nullable final String assetDepreciationArea )
    {
        rememberChangedField("AssetDepreciationArea", this.assetDepreciationArea);
        this.assetDepreciationArea = assetDepreciationArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegment</b>
     * </p>
     *
     * @param partnerSegment
     *            Partner Segment
     */
    public void setPartnerSegment( @Nullable final String partnerSegment )
    {
        rememberChangedField("PartnerSegment", this.partnerSegment);
        this.partnerSegment = partnerSegment;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegmentName</b>
     * </p>
     *
     * @param partnerSegmentName
     *            Partner Segment (Description)
     */
    public void setPartnerSegmentName( @Nullable final String partnerSegmentName )
    {
        rememberChangedField("PartnerSegmentName", this.partnerSegmentName);
        this.partnerSegmentName = partnerSegmentName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingJournalEntry</b>
     * </p>
     *
     * @param clearingJournalEntry
     *            Clearing Journal Entry
     */
    public void setClearingJournalEntry( @Nullable final String clearingJournalEntry )
    {
        rememberChangedField("ClearingJournalEntry", this.clearingJournalEntry);
        this.clearingJournalEntry = clearingJournalEntry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperatingConcern</b>
     * </p>
     *
     * @param operatingConcern
     *            Operating Concern
     */
    public void setOperatingConcern( @Nullable final String operatingConcern )
    {
        rememberChangedField("OperatingConcern", this.operatingConcern);
        this.operatingConcern = operatingConcern;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpclStockWBSElmntExtID</b>
     * </p>
     *
     * @param invtrySpclStockWBSElmntExtID
     *            Inventory WBS Element External ID
     */
    public void setInvtrySpclStockWBSElmntExtID( @Nullable final String invtrySpclStockWBSElmntExtID )
    {
        rememberChangedField("InvtrySpclStockWBSElmntExtID", this.invtrySpclStockWBSElmntExtID);
        this.invtrySpclStockWBSElmntExtID = invtrySpclStockWBSElmntExtID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodEndDate</b>
     * </p>
     *
     * @param fiscalPeriodEndDate
     *            End of Fiscal Period
     */
    public void setFiscalPeriodEndDate( @Nullable final String fiscalPeriodEndDate )
    {
        rememberChangedField("FiscalPeriodEndDate", this.fiscalPeriodEndDate);
        this.fiscalPeriodEndDate = fiscalPeriodEndDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodEndDate_T</b>
     * </p>
     *
     * @param fiscalPeriodEndDate_T
     *            End of Fiscal Period (Description)
     */
    public void setFiscalPeriodEndDate_T( @Nullable final String fiscalPeriodEndDate_T )
    {
        rememberChangedField("FiscalPeriodEndDate_T", this.fiscalPeriodEndDate_T);
        this.fiscalPeriodEndDate_T = fiscalPeriodEndDate_T;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CountryChartOfAccounts</b>
     * </p>
     *
     * @param countryChartOfAccounts
     *            Alternative Chart of Accounts
     */
    public void setCountryChartOfAccounts( @Nullable final String countryChartOfAccounts )
    {
        rememberChangedField("CountryChartOfAccounts", this.countryChartOfAccounts);
        this.countryChartOfAccounts = countryChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodStartDate</b>
     * </p>
     *
     * @param fiscalPeriodStartDate
     *            Start Date
     */
    public void setFiscalPeriodStartDate( @Nullable final String fiscalPeriodStartDate )
    {
        rememberChangedField("FiscalPeriodStartDate", this.fiscalPeriodStartDate);
        this.fiscalPeriodStartDate = fiscalPeriodStartDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodStartDate_T</b>
     * </p>
     *
     * @param fiscalPeriodStartDate_T
     *            Start Date (Description)
     */
    public void setFiscalPeriodStartDate_T( @Nullable final String fiscalPeriodStartDate_T )
    {
        rememberChangedField("FiscalPeriodStartDate_T", this.fiscalPeriodStartDate_T);
        this.fiscalPeriodStartDate_T = fiscalPeriodStartDate_T;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency6</b>
     * </p>
     *
     * @param freeDefinedCurrency6
     *            Freely Defined Currency 6
     */
    public void setFreeDefinedCurrency6( @Nullable final String freeDefinedCurrency6 )
    {
        rememberChangedField("FreeDefinedCurrency6", this.freeDefinedCurrency6);
        this.freeDefinedCurrency6 = freeDefinedCurrency6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Transaction Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignment</b>
     * </p>
     *
     * @param accountAssignment
     *            Account Assignment
     */
    public void setAccountAssignment( @Nullable final String accountAssignment )
    {
        rememberChangedField("AccountAssignment", this.accountAssignment);
        this.accountAssignment = accountAssignment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCtrActivityType</b>
     * </p>
     *
     * @param partnerCostCtrActivityType
     *            Partner Cost Center Activity Type
     */
    public void setPartnerCostCtrActivityType( @Nullable final String partnerCostCtrActivityType )
    {
        rememberChangedField("PartnerCostCtrActivityType", this.partnerCostCtrActivityType);
        this.partnerCostCtrActivityType = partnerCostCtrActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessProcess</b>
     * </p>
     *
     * @param partnerBusinessProcess
     *            Partner Business Process
     */
    public void setPartnerBusinessProcess( @Nullable final String partnerBusinessProcess )
    {
        rememberChangedField("PartnerBusinessProcess", this.partnerBusinessProcess);
        this.partnerBusinessProcess = partnerBusinessProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RelatedNetworkActivity</b>
     * </p>
     *
     * @param relatedNetworkActivity
     *            Related Network Activity
     */
    public void setRelatedNetworkActivity( @Nullable final String relatedNetworkActivity )
    {
        rememberChangedField("RelatedNetworkActivity", this.relatedNetworkActivity);
        this.relatedNetworkActivity = relatedNetworkActivity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @param salesDocument
     *            Sales Document
     */
    public void setSalesDocument( @Nullable final String salesDocument )
    {
        rememberChangedField("SalesDocument", this.salesDocument);
        this.salesDocument = salesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency1</b>
     * </p>
     *
     * @param freeDefinedCurrency1
     *            Freely Defined Currency 1
     */
    public void setFreeDefinedCurrency1( @Nullable final String freeDefinedCurrency1 )
    {
        rememberChangedField("FreeDefinedCurrency1", this.freeDefinedCurrency1);
        this.freeDefinedCurrency1 = freeDefinedCurrency1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodDate</b>
     * </p>
     *
     * @param fiscalPeriodDate
     *            Fiscal Period Date
     */
    public void setFiscalPeriodDate( @Nullable final String fiscalPeriodDate )
    {
        rememberChangedField("FiscalPeriodDate", this.fiscalPeriodDate);
        this.fiscalPeriodDate = fiscalPeriodDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency3</b>
     * </p>
     *
     * @param freeDefinedCurrency3
     *            Freely Defined Currency 3
     */
    public void setFreeDefinedCurrency3( @Nullable final String freeDefinedCurrency3 )
    {
        rememberChangedField("FreeDefinedCurrency3", this.freeDefinedCurrency3);
        this.freeDefinedCurrency3 = freeDefinedCurrency3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AssetTransactionType</b>
     * </p>
     *
     * @param assetTransactionType
     *            Ast Transaction Type
     */
    public void setAssetTransactionType( @Nullable final String assetTransactionType )
    {
        rememberChangedField("AssetTransactionType", this.assetTransactionType);
        this.assetTransactionType = assetTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @param purchasingDocument
     *            Purchasing Document
     */
    public void setPurchasingDocument( @Nullable final String purchasingDocument )
    {
        rememberChangedField("PurchasingDocument", this.purchasingDocument);
        this.purchasingDocument = purchasingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpecialStockValnType_2</b>
     * </p>
     *
     * @param invtrySpecialStockValnType_2
     *            Inventory Special Stock Valuation Type
     */
    public void setInvtrySpecialStockValnType_2( @Nullable final String invtrySpecialStockValnType_2 )
    {
        rememberChangedField("InvtrySpecialStockValnType_2", this.invtrySpecialStockValnType_2);
        this.invtrySpecialStockValnType_2 = invtrySpecialStockValnType_2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EliminationProfitCenter</b>
     * </p>
     *
     * @param eliminationProfitCenter
     *            Elimination Profit Center
     */
    public void setEliminationProfitCenter( @Nullable final String eliminationProfitCenter )
    {
        rememberChangedField("EliminationProfitCenter", this.eliminationProfitCenter);
        this.eliminationProfitCenter = eliminationProfitCenter;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EliminationProfitCenterName</b>
     * </p>
     *
     * @param eliminationProfitCenterName
     *            Elimination Profit Center (Description)
     */
    public void setEliminationProfitCenterName( @Nullable final String eliminationProfitCenterName )
    {
        rememberChangedField("EliminationProfitCenterName", this.eliminationProfitCenterName);
        this.eliminationProfitCenterName = eliminationProfitCenterName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GlobalCurrency</b>
     * </p>
     *
     * @param globalCurrency
     *            Global Currency
     */
    public void setGlobalCurrency( @Nullable final String globalCurrency )
    {
        rememberChangedField("GlobalCurrency", this.globalCurrency);
        this.globalCurrency = globalCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorReferenceDocType</b>
     * </p>
     *
     * @param predecessorReferenceDocType
     *            Predecessor Reference Document Type
     */
    public void setPredecessorReferenceDocType( @Nullable final String predecessorReferenceDocType )
    {
        rememberChangedField("PredecessorReferenceDocType", this.predecessorReferenceDocType);
        this.predecessorReferenceDocType = predecessorReferenceDocType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LedgerFiscalYear</b>
     * </p>
     *
     * @param ledgerFiscalYear
     *            Fiscal Year of Ledger
     */
    public void setLedgerFiscalYear( @Nullable final String ledgerFiscalYear )
    {
        rememberChangedField("LedgerFiscalYear", this.ledgerFiscalYear);
        this.ledgerFiscalYear = ledgerFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocument</b>
     * </p>
     *
     * @param partnerSalesDocument
     *            Partner Sales Doc.
     */
    public void setPartnerSalesDocument( @Nullable final String partnerSalesDocument )
    {
        rememberChangedField("PartnerSalesDocument", this.partnerSalesDocument);
        this.partnerSalesDocument = partnerSalesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountAssignment</b>
     * </p>
     *
     * @param partnerAccountAssignment
     *            Partner Account Assignment
     */
    public void setPartnerAccountAssignment( @Nullable final String partnerAccountAssignment )
    {
        rememberChangedField("PartnerAccountAssignment", this.partnerAccountAssignment);
        this.partnerAccountAssignment = partnerAccountAssignment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccount</b>
     * </p>
     *
     * @param offsettingAccount
     *            Offsetting Account
     */
    public void setOffsettingAccount( @Nullable final String offsettingAccount )
    {
        rememberChangedField("OffsettingAccount", this.offsettingAccount);
        this.offsettingAccount = offsettingAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBudgetPeriod</b>
     * </p>
     *
     * @param partnerBudgetPeriod
     *            Partner Budget Period
     */
    public void setPartnerBudgetPeriod( @Nullable final String partnerBudgetPeriod )
    {
        rememberChangedField("PartnerBudgetPeriod", this.partnerBudgetPeriod);
        this.partnerBudgetPeriod = partnerBudgetPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocCreatedByUser</b>
     * </p>
     *
     * @param accountingDocCreatedByUser
     *            Journal Entry Created By
     */
    public void setAccountingDocCreatedByUser( @Nullable final String accountingDocCreatedByUser )
    {
        rememberChangedField("AccountingDocCreatedByUser", this.accountingDocCreatedByUser);
        this.accountingDocCreatedByUser = accountingDocCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency4</b>
     * </p>
     *
     * @param freeDefinedCurrency4
     *            Freely Defined Currency 4
     */
    public void setFreeDefinedCurrency4( @Nullable final String freeDefinedCurrency4 )
    {
        rememberChangedField("FreeDefinedCurrency4", this.freeDefinedCurrency4);
        this.freeDefinedCurrency4 = freeDefinedCurrency4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @param projectNetwork
     *            Network
     */
    public void setProjectNetwork( @Nullable final String projectNetwork )
    {
        rememberChangedField("ProjectNetwork", this.projectNetwork);
        this.projectNetwork = projectNetwork;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LineItemIsCompleted</b>
     * </p>
     *
     * @param lineItemIsCompleted
     *            Line Item is Completed
     */
    public void setLineItemIsCompleted( @Nullable final String lineItemIsCompleted )
    {
        rememberChangedField("LineItemIsCompleted", this.lineItemIsCompleted);
        this.lineItemIsCompleted = lineItemIsCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectInternalID</b>
     * </p>
     *
     * @param partnerProjectInternalID
     *            Partner Project Internal ID
     */
    public void setPartnerProjectInternalID( @Nullable final String partnerProjectInternalID )
    {
        rememberChangedField("PartnerProjectInternalID", this.partnerProjectInternalID);
        this.partnerProjectInternalID = partnerProjectInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureCostRecoveryCode</b>
     * </p>
     *
     * @param jointVentureCostRecoveryCode
     *            Joint Venture Cost Recovery Code
     */
    public void setJointVentureCostRecoveryCode( @Nullable final String jointVentureCostRecoveryCode )
    {
        rememberChangedField("JointVentureCostRecoveryCode", this.jointVentureCostRecoveryCode);
        this.jointVentureCostRecoveryCode = jointVentureCostRecoveryCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockSupplier</b>
     * </p>
     *
     * @param inventorySpecialStockSupplier
     *            Inventory Special Stock Supplier
     */
    public void setInventorySpecialStockSupplier( @Nullable final String inventorySpecialStockSupplier )
    {
        rememberChangedField("InventorySpecialStockSupplier", this.inventorySpecialStockSupplier);
        this.inventorySpecialStockSupplier = inventorySpecialStockSupplier;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpecialStockSupplierName</b>
     * </p>
     *
     * @param invtrySpecialStockSupplierName
     *            Inventory Special Stock Supplier (Description)
     */
    public void setInvtrySpecialStockSupplierName( @Nullable final String invtrySpecialStockSupplierName )
    {
        rememberChangedField("InvtrySpecialStockSupplierName", this.invtrySpecialStockSupplierName);
        this.invtrySpecialStockSupplierName = invtrySpecialStockSupplierName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentType</b>
     * </p>
     *
     * @param accountAssignmentType
     *            Account Assignment Type
     */
    public void setAccountAssignmentType( @Nullable final String accountAssignmentType )
    {
        rememberChangedField("AccountAssignmentType", this.accountAssignmentType);
        this.accountAssignmentType = accountAssignmentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductGroup</b>
     * </p>
     *
     * @param soldProductGroup
     *            Product Sold Group
     */
    public void setSoldProductGroup( @Nullable final String soldProductGroup )
    {
        rememberChangedField("SoldProductGroup", this.soldProductGroup);
        this.soldProductGroup = soldProductGroup;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupName</b>
     * </p>
     *
     * @param materialGroupName
     *            Product Sold Group (Description)
     */
    public void setMaterialGroupName( @Nullable final String materialGroupName )
    {
        rememberChangedField("MaterialGroupName", this.materialGroupName);
        this.materialGroupName = materialGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProject</b>
     * </p>
     *
     * @param partnerProject
     *            Partner Project
     */
    public void setPartnerProject( @Nullable final String partnerProject )
    {
        rememberChangedField("PartnerProject", this.partnerProject);
        this.partnerProject = partnerProject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ClearingJournalEntryFiscalYear</b>
     * </p>
     *
     * @param clearingJournalEntryFiscalYear
     *            Fiscal Year of Clearing Journal Entry
     */
    public void setClearingJournalEntryFiscalYear( @Nullable final String clearingJournalEntryFiscalYear )
    {
        rememberChangedField("ClearingJournalEntryFiscalYear", this.clearingJournalEntryFiscalYear);
        this.clearingJournalEntryFiscalYear = clearingJournalEntryFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     *
     * @param partnerCompany
     *            Trading Partner
     */
    public void setPartnerCompany( @Nullable final String partnerCompany )
    {
        rememberChangedField("PartnerCompany", this.partnerCompany);
        this.partnerCompany = partnerCompany;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     *
     * @param logicalSystem
     *            Logical System
     */
    public void setLogicalSystem( @Nullable final String logicalSystem )
    {
        rememberChangedField("LogicalSystem", this.logicalSystem);
        this.logicalSystem = logicalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelNumber</b>
     * </p>
     *
     * @param personnelNumber
     *            Personnel Number
     */
    public void setPersonnelNumber( @Nullable final String personnelNumber )
    {
        rememberChangedField("PersonnelNumber", this.personnelNumber);
        this.personnelNumber = personnelNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GroupMasterFixedAsset</b>
     * </p>
     *
     * @param groupMasterFixedAsset
     *            Group Asset
     */
    public void setGroupMasterFixedAsset( @Nullable final String groupMasterFixedAsset )
    {
        rememberChangedField("GroupMasterFixedAsset", this.groupMasterFixedAsset);
        this.groupMasterFixedAsset = groupMasterFixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @param salesDocumentItem
     *            Sales Document Item
     */
    public void setSalesDocumentItem( @Nullable final String salesDocumentItem )
    {
        rememberChangedField("SalesDocumentItem", this.salesDocumentItem);
        this.salesDocumentItem = salesDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrderCategory</b>
     * </p>
     *
     * @param partnerOrderCategory
     *            Partner Order Cat.
     */
    public void setPartnerOrderCategory( @Nullable final String partnerOrderCategory )
    {
        rememberChangedField("PartnerOrderCategory", this.partnerOrderCategory);
        this.partnerOrderCategory = partnerOrderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea</b>
     * </p>
     *
     * @param partnerBusinessArea
     *            Partner Bus. Area
     */
    public void setPartnerBusinessArea( @Nullable final String partnerBusinessArea )
    {
        rememberChangedField("PartnerBusinessArea", this.partnerBusinessArea);
        this.partnerBusinessArea = partnerBusinessArea;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessAreaName</b>
     * </p>
     *
     * @param partnerBusinessAreaName
     *            Partner Bus. Area (Description)
     */
    public void setPartnerBusinessAreaName( @Nullable final String partnerBusinessAreaName )
    {
        rememberChangedField("PartnerBusinessAreaName", this.partnerBusinessAreaName);
        this.partnerBusinessAreaName = partnerBusinessAreaName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalArea</b>
     * </p>
     *
     * @param partnerFunctionalArea
     *            Partner Func. Area
     */
    public void setPartnerFunctionalArea( @Nullable final String partnerFunctionalArea )
    {
        rememberChangedField("PartnerFunctionalArea", this.partnerFunctionalArea);
        this.partnerFunctionalArea = partnerFunctionalArea;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalAreaName</b>
     * </p>
     *
     * @param partnerFunctionalAreaName
     *            Partner Func. Area (Description)
     */
    public void setPartnerFunctionalAreaName( @Nullable final String partnerFunctionalAreaName )
    {
        rememberChangedField("PartnerFunctionalAreaName", this.partnerFunctionalAreaName);
        this.partnerFunctionalAreaName = partnerFunctionalAreaName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProjectExternalID</b>
     * </p>
     *
     * @param projectExternalID
     *            Project External ID
     */
    public void setProjectExternalID( @Nullable final String projectExternalID )
    {
        rememberChangedField("ProjectExternalID", this.projectExternalID);
        this.projectExternalID = projectExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OriginCostCenter</b>
     * </p>
     *
     * @param originCostCenter
     *            Origin Cost Center
     */
    public void setOriginCostCenter( @Nullable final String originCostCenter )
    {
        rememberChangedField("OriginCostCenter", this.originCostCenter);
        this.originCostCenter = originCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency5</b>
     * </p>
     *
     * @param freeDefinedCurrency5
     *            Freely Defined Currency 5
     */
    public void setFreeDefinedCurrency5( @Nullable final String freeDefinedCurrency5 )
    {
        rememberChangedField("FreeDefinedCurrency5", this.freeDefinedCurrency5);
        this.freeDefinedCurrency5 = freeDefinedCurrency5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @param companyCodeCurrency
     *            Company Code Currency
     */
    public void setCompanyCodeCurrency( @Nullable final String companyCodeCurrency )
    {
        rememberChangedField("CompanyCodeCurrency", this.companyCodeCurrency);
        this.companyCodeCurrency = companyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OriginObjectType</b>
     * </p>
     *
     * @param originObjectType
     *            Origin Object Type
     */
    public void setOriginObjectType( @Nullable final String originObjectType )
    {
        rememberChangedField("OriginObjectType", this.originObjectType);
        this.originObjectType = originObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectDebitType</b>
     * </p>
     *
     * @param controllingObjectDebitType
     *            Controlling Object Debit Type
     */
    public void setControllingObjectDebitType( @Nullable final String controllingObjectDebitType )
    {
        rememberChangedField("ControllingObjectDebitType", this.controllingObjectDebitType);
        this.controllingObjectDebitType = controllingObjectDebitType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElementInternalID</b>
     * </p>
     *
     * @param partnerWBSElementInternalID
     *            Partner WBS Element Internal ID
     */
    public void setPartnerWBSElementInternalID( @Nullable final String partnerWBSElementInternalID )
    {
        rememberChangedField("PartnerWBSElementInternalID", this.partnerWBSElementInternalID);
        this.partnerWBSElementInternalID = partnerWBSElementInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountHierarchy</b>
     * </p>
     *
     * @param gLAccountHierarchy
     *            G/L Account
     */
    public void setGLAccountHierarchy( @Nullable final String gLAccountHierarchy )
    {
        rememberChangedField("GLAccountHierarchy", this.gLAccountHierarchy);
        this.gLAccountHierarchy = gLAccountHierarchy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CustomerServiceNotification</b>
     * </p>
     *
     * @param customerServiceNotification
     *            Customer Service Notification
     */
    public void setCustomerServiceNotification( @Nullable final String customerServiceNotification )
    {
        rememberChangedField("CustomerServiceNotification", this.customerServiceNotification);
        this.customerServiceNotification = customerServiceNotification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency7</b>
     * </p>
     *
     * @param freeDefinedCurrency7
     *            Freely Defined Currency 7
     */
    public void setFreeDefinedCurrency7( @Nullable final String freeDefinedCurrency7 )
    {
        rememberChangedField("FreeDefinedCurrency7", this.freeDefinedCurrency7);
        this.freeDefinedCurrency7 = freeDefinedCurrency7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentNumber</b>
     * </p>
     *
     * @param accountAssignmentNumber
     *            Account Assignment Number
     */
    public void setAccountAssignmentNumber( @Nullable final String accountAssignmentNumber )
    {
        rememberChangedField("AccountAssignmentNumber", this.accountAssignmentNumber);
        this.accountAssignmentNumber = accountAssignmentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TransactionTypeDetermination</b>
     * </p>
     *
     * @param transactionTypeDetermination
     *            Transaction Key
     */
    public void setTransactionTypeDetermination( @Nullable final String transactionTypeDetermination )
    {
        rememberChangedField("TransactionTypeDetermination", this.transactionTypeDetermination);
        this.transactionTypeDetermination = transactionTypeDetermination;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectNetwork</b>
     * </p>
     *
     * @param partnerProjectNetwork
     *            Partner Project Network
     */
    public void setPartnerProjectNetwork( @Nullable final String partnerProjectNetwork )
    {
        rememberChangedField("PartnerProjectNetwork", this.partnerProjectNetwork);
        this.partnerProjectNetwork = partnerProjectNetwork;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompanyCode</b>
     * </p>
     *
     * @param partnerCompanyCode
     *            Partner Company Code
     */
    public void setPartnerCompanyCode( @Nullable final String partnerCompanyCode )
    {
        rememberChangedField("PartnerCompanyCode", this.partnerCompanyCode);
        this.partnerCompanyCode = partnerCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccountType</b>
     * </p>
     *
     * @param offsettingAccountType
     *            Offsetting Account Type
     */
    public void setOffsettingAccountType( @Nullable final String offsettingAccountType )
    {
        rememberChangedField("OffsettingAccountType", this.offsettingAccountType);
        this.offsettingAccountType = offsettingAccountType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYearWeek</b>
     * </p>
     *
     * @param calendarYearWeek
     *            Year and Calendar Week
     */
    public void setCalendarYearWeek( @Nullable final String calendarYearWeek )
    {
        rememberChangedField("CalendarYearWeek", this.calendarYearWeek);
        this.calendarYearWeek = calendarYearWeek;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SenderAccountAssignmentType</b>
     * </p>
     *
     * @param senderAccountAssignmentType
     *            Sender Account Assignment Type
     */
    public void setSenderAccountAssignmentType( @Nullable final String senderAccountAssignmentType )
    {
        rememberChangedField("SenderAccountAssignmentType", this.senderAccountAssignmentType);
        this.senderAccountAssignmentType = senderAccountAssignmentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @param purchasingDocumentItem
     *            Purchasing Doc. Item
     */
    public void setPurchasingDocumentItem( @Nullable final String purchasingDocumentItem )
    {
        rememberChangedField("PurchasingDocumentItem", this.purchasingDocumentItem);
        this.purchasingDocumentItem = purchasingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SenderGLAccount</b>
     * </p>
     *
     * @param senderGLAccount
     *            Sender G/L Account
     */
    public void setSenderGLAccount( @Nullable final String senderGLAccount )
    {
        rememberChangedField("SenderGLAccount", this.senderGLAccount);
        this.senderGLAccount = senderGLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocumentItem</b>
     * </p>
     *
     * @param partnerSalesDocumentItem
     *            Partner Sales Document Item
     */
    public void setPartnerSalesDocumentItem( @Nullable final String partnerSalesDocumentItem )
    {
        rememberChangedField("PartnerSalesDocumentItem", this.partnerSalesDocumentItem);
        this.partnerSalesDocumentItem = partnerSalesDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventoryValuationType</b>
     * </p>
     *
     * @param inventoryValuationType
     *            Inventory Valuation Type
     */
    public void setInventoryValuationType( @Nullable final String inventoryValuationType )
    {
        rememberChangedField("InventoryValuationType", this.inventoryValuationType);
        this.inventoryValuationType = inventoryValuationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SettlementReferenceDate</b>
     * </p>
     *
     * @param settlementReferenceDate
     *            Settlement Reference Date
     */
    public void setSettlementReferenceDate( @Nullable final String settlementReferenceDate )
    {
        rememberChangedField("SettlementReferenceDate", this.settlementReferenceDate);
        this.settlementReferenceDate = settlementReferenceDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SettlementReferenceDate_T</b>
     * </p>
     *
     * @param settlementReferenceDate_T
     *            Settlement Reference Date (Description)
     */
    public void setSettlementReferenceDate_T( @Nullable final String settlementReferenceDate_T )
    {
        rememberChangedField("SettlementReferenceDate_T", this.settlementReferenceDate_T);
        this.settlementReferenceDate_T = settlementReferenceDate_T;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    @Override
    protected String getEntityCollection()
    {
        return "IsSettlementResults";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("IsSettlement", getIsSettlement());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("IsSettlement", getIsSettlement());
        values.put("CompanyCode", getCompanyCode());
        values.put("CompanyCodeName", getCompanyCodeName());
        values.put("GLAccount", getGLAccount());
        values.put("GLAccountHierarchyName", getGLAccountHierarchyName());
        values.put("BusinessProcess", getBusinessProcess());
        values.put("FreeDefinedCurrency8", getFreeDefinedCurrency8());
        values.put("PartnerCostObject", getPartnerCostObject());
        values.put("AssetValueDate", getAssetValueDate());
        values.put("AssetValueDate_T", getAssetValueDate_T());
        values.put("FiscalYearPeriod", getFiscalYearPeriod());
        values.put("QuantityIsIncomplete", getQuantityIsIncomplete());
        values.put("IsOpenItemManaged", getIsOpenItemManaged());
        values.put("CorporateGroupAccount", getCorporateGroupAccount());
        values.put("CorporateGroupAccount_T", getCorporateGroupAccount_T());
        values.put("BillingDocumentType", getBillingDocumentType());
        values.put("FiscalQuarter", getFiscalQuarter());
        values.put("CorporateGroupChartOfAccounts", getCorporateGroupChartOfAccounts());
        values.put("ClearingDocFiscalYear", getClearingDocFiscalYear());
        values.put("PartnerWBSElement", getPartnerWBSElement());
        values.put("FreeDefinedCurrency2", getFreeDefinedCurrency2());
        values.put("PartnerProfitCenter", getPartnerProfitCenter());
        values.put("PartnerProfitCenterName", getPartnerProfitCenterName());
        values.put("PartnerControllingObjectClass", getPartnerControllingObjectClass());
        values.put("GLAccountType", getGLAccountType());
        values.put("AccountingDocumentCategory", getAccountingDocumentCategory());
        values.put("BusinessTransactionType", getBusinessTransactionType());
        values.put("CalendarMonth", getCalendarMonth());
        values.put("CalendarQuarter", getCalendarQuarter());
        values.put("ClearingAccountingDocument", getClearingAccountingDocument());
        values.put("AccountingDocumentType", getAccountingDocumentType());
        values.put("AccountingDocumentTypeName", getAccountingDocumentTypeName());
        values.put("FinancialAccountType", getFinancialAccountType());
        values.put("FinancialAccountTypeName", getFinancialAccountTypeName());
        values.put("BusinessArea", getBusinessArea());
        values.put("BusinessAreaName", getBusinessAreaName());
        values.put("OriginCostCtrActivityType", getOriginCostCtrActivityType());
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("ControllingArea", getControllingArea());
        values.put("ControllingAreaName", getControllingAreaName());
        values.put("ControllingObjectClass", getControllingObjectClass());
        values.put("PartnerCostCenter", getPartnerCostCenter());
        values.put("SenderCostCenterName", getSenderCostCenterName());
        values.put("DebitCreditCode", getDebitCreditCode());
        values.put("DebitCreditCodeName", getDebitCreditCodeName());
        values.put("PostingDate", getPostingDate());
        values.put("PostingDate_T", getPostingDate_T());
        values.put("FiscalYearVariant", getFiscalYearVariant());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("FunctionalAreaName", getFunctionalAreaName());
        values.put("FiscalYear", getFiscalYear());
        values.put("BudgetPeriod", getBudgetPeriod());
        values.put("CalendarWeek", getCalendarWeek());
        values.put("CalendarYear", getCalendarYear());
        values.put("ClearingDate", getClearingDate());
        values.put("ClearingDate_T", getClearingDate_T());
        values.put("CostCenter", getCostCenter());
        values.put("CostCenterName", getCostCenterName());
        values.put("CostObject", getCostObject());
        values.put("FiscalPeriod", getFiscalPeriod());
        values.put("FiscalWeek", getFiscalWeek());
        values.put("Fund", getFund());
        values.put("GrantID", getGrantID());
        values.put("IsReversal", getIsReversal());
        values.put("IsReversed", getIsReversed());
        values.put("IsSettled", getIsSettled());
        values.put("JointVenture", getJointVenture());
        values.put("OrderID", getOrderID());
        values.put("PartnerFund", getPartnerFund());
        values.put("PartnerGrant", getPartnerGrant());
        values.put("PartnerOrder", getPartnerOrder());
        values.put("SalesOrder", getSalesOrder());
        values.put("SoldMaterial", getSoldMaterial());
        values.put("SoldProduct", getSoldProduct());
        values.put("TaxCode", getTaxCode());
        values.put("WBSElement", getWBSElement());
        values.put("HouseBank", getHouseBank());
        values.put("InventorySpecialStockValnType", getInventorySpecialStockValnType());
        values.put("Ledger", getLedger());
        values.put("MasterFixedAsset", getMasterFixedAsset());
        values.put("PostingKey", getPostingKey());
        values.put("PostingKeyName", getPostingKeyName());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ProfitCenterName", getProfitCenterName());
        values.put("Segment", getSegment());
        values.put("SegmentName", getSegmentName());
        values.put("SpecialGLCode", getSpecialGLCode());
        values.put("FinancialTransactionType", getFinancialTransactionType());
        values.put("FixedAsset", getFixedAsset());
        values.put("JointVentureEquityType", getJointVentureEquityType());
        values.put("HouseBankAccount", getHouseBankAccount());
        values.put("InventorySpecialStockType", getInventorySpecialStockType());
        values.put("AlternativeGLAccount", getAlternativeGLAccount());
        values.put("AlternativeGLAccount_T", getAlternativeGLAccount_T());
        values.put("Material", getMaterial());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("Plant", getPlant());
        values.put("PlantName", getPlantName());
        values.put("OrderCategory", getOrderCategory());
        values.put("Product", getProduct());
        values.put("MaterialName", getMaterialName());
        values.put("ProductGroup", getProductGroup());
        values.put("Project", getProject());
        values.put("ValuationArea", getValuationArea());
        values.put("CustomerGroup", getCustomerGroup());
        values.put("CustomerGroupName", getCustomerGroupName());
        values.put("InventorySpclStkSalesDocument", getInventorySpclStkSalesDocument());
        values.put("InventorySpclStkSalesDocItm", getInventorySpclStkSalesDocItm());
        values.put("InvtrySpclStockWBSElmntIntID", getInvtrySpclStockWBSElmntIntID());
        values.put("InventorySpclStockWBSElement", getInventorySpclStockWBSElement());
        values.put("CalendarYearMonth", getCalendarYearMonth());
        values.put("Customer", getCustomer());
        values.put("CustomerName", getCustomerName());
        values.put("Supplier", getSupplier());
        values.put("SupplierName", getSupplierName());
        values.put("BalanceTransactionCurrency", getBalanceTransactionCurrency());
        values.put("AssignmentReference", getAssignmentReference());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        values.put("OrganizationDivision", getOrganizationDivision());
        values.put("PartnerProjectNetworkActivity", getPartnerProjectNetworkActivity());
        values.put("CalendarYearQuarter", getCalendarYearQuarter());
        values.put("IsBalanceSheetAccount", getIsBalanceSheetAccount());
        values.put("PartnerAccountAssignmentType", getPartnerAccountAssignmentType());
        values.put("FiscalYearWeek", getFiscalYearWeek());
        values.put("JointVentureEquityGroup", getJointVentureEquityGroup());
        values.put("FinancialManagementArea", getFinancialManagementArea());
        values.put("CostCtrActivityType", getCostCtrActivityType());
        values.put("SenderAccountAssignment", getSenderAccountAssignment());
        values.put("FiscalYearQuarter", getFiscalYearQuarter());
        values.put("ReferenceDocumentType", getReferenceDocumentType());
        values.put("GroupFixedAsset", getGroupFixedAsset());
        values.put("ReferenceDocumentItemGroup", getReferenceDocumentItemGroup());
        values.put("AssetDepreciationArea", getAssetDepreciationArea());
        values.put("PartnerSegment", getPartnerSegment());
        values.put("PartnerSegmentName", getPartnerSegmentName());
        values.put("ClearingJournalEntry", getClearingJournalEntry());
        values.put("OperatingConcern", getOperatingConcern());
        values.put("InvtrySpclStockWBSElmntExtID", getInvtrySpclStockWBSElmntExtID());
        values.put("FiscalPeriodEndDate", getFiscalPeriodEndDate());
        values.put("FiscalPeriodEndDate_T", getFiscalPeriodEndDate_T());
        values.put("CountryChartOfAccounts", getCountryChartOfAccounts());
        values.put("FiscalPeriodStartDate", getFiscalPeriodStartDate());
        values.put("FiscalPeriodStartDate_T", getFiscalPeriodStartDate_T());
        values.put("FreeDefinedCurrency6", getFreeDefinedCurrency6());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("AccountAssignment", getAccountAssignment());
        values.put("PartnerCostCtrActivityType", getPartnerCostCtrActivityType());
        values.put("PartnerBusinessProcess", getPartnerBusinessProcess());
        values.put("RelatedNetworkActivity", getRelatedNetworkActivity());
        values.put("SalesDocument", getSalesDocument());
        values.put("FreeDefinedCurrency1", getFreeDefinedCurrency1());
        values.put("FiscalPeriodDate", getFiscalPeriodDate());
        values.put("FreeDefinedCurrency3", getFreeDefinedCurrency3());
        values.put("AssetTransactionType", getAssetTransactionType());
        values.put("PurchasingDocument", getPurchasingDocument());
        values.put("InvtrySpecialStockValnType_2", getInvtrySpecialStockValnType_2());
        values.put("EliminationProfitCenter", getEliminationProfitCenter());
        values.put("EliminationProfitCenterName", getEliminationProfitCenterName());
        values.put("GlobalCurrency", getGlobalCurrency());
        values.put("PredecessorReferenceDocType", getPredecessorReferenceDocType());
        values.put("LedgerFiscalYear", getLedgerFiscalYear());
        values.put("PartnerSalesDocument", getPartnerSalesDocument());
        values.put("PartnerAccountAssignment", getPartnerAccountAssignment());
        values.put("OffsettingAccount", getOffsettingAccount());
        values.put("PartnerBudgetPeriod", getPartnerBudgetPeriod());
        values.put("AccountingDocCreatedByUser", getAccountingDocCreatedByUser());
        values.put("FreeDefinedCurrency4", getFreeDefinedCurrency4());
        values.put("ProjectNetwork", getProjectNetwork());
        values.put("LineItemIsCompleted", getLineItemIsCompleted());
        values.put("PartnerProjectInternalID", getPartnerProjectInternalID());
        values.put("JointVentureCostRecoveryCode", getJointVentureCostRecoveryCode());
        values.put("InventorySpecialStockSupplier", getInventorySpecialStockSupplier());
        values.put("InvtrySpecialStockSupplierName", getInvtrySpecialStockSupplierName());
        values.put("AccountAssignmentType", getAccountAssignmentType());
        values.put("SoldProductGroup", getSoldProductGroup());
        values.put("MaterialGroupName", getMaterialGroupName());
        values.put("PartnerProject", getPartnerProject());
        values.put("ClearingJournalEntryFiscalYear", getClearingJournalEntryFiscalYear());
        values.put("PartnerCompany", getPartnerCompany());
        values.put("LogicalSystem", getLogicalSystem());
        values.put("PersonnelNumber", getPersonnelNumber());
        values.put("GroupMasterFixedAsset", getGroupMasterFixedAsset());
        values.put("SalesDocumentItem", getSalesDocumentItem());
        values.put("PartnerOrderCategory", getPartnerOrderCategory());
        values.put("PartnerBusinessArea", getPartnerBusinessArea());
        values.put("PartnerBusinessAreaName", getPartnerBusinessAreaName());
        values.put("PartnerFunctionalArea", getPartnerFunctionalArea());
        values.put("PartnerFunctionalAreaName", getPartnerFunctionalAreaName());
        values.put("ProjectExternalID", getProjectExternalID());
        values.put("OriginCostCenter", getOriginCostCenter());
        values.put("FreeDefinedCurrency5", getFreeDefinedCurrency5());
        values.put("CompanyCodeCurrency", getCompanyCodeCurrency());
        values.put("OriginObjectType", getOriginObjectType());
        values.put("ControllingObjectDebitType", getControllingObjectDebitType());
        values.put("PartnerWBSElementInternalID", getPartnerWBSElementInternalID());
        values.put("GLAccountHierarchy", getGLAccountHierarchy());
        values.put("CustomerServiceNotification", getCustomerServiceNotification());
        values.put("FreeDefinedCurrency7", getFreeDefinedCurrency7());
        values.put("AccountAssignmentNumber", getAccountAssignmentNumber());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("TransactionTypeDetermination", getTransactionTypeDetermination());
        values.put("PartnerProjectNetwork", getPartnerProjectNetwork());
        values.put("PartnerCompanyCode", getPartnerCompanyCode());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("OffsettingAccountType", getOffsettingAccountType());
        values.put("CalendarYearWeek", getCalendarYearWeek());
        values.put("SenderAccountAssignmentType", getSenderAccountAssignmentType());
        values.put("PurchasingDocumentItem", getPurchasingDocumentItem());
        values.put("SenderGLAccount", getSenderGLAccount());
        values.put("PartnerSalesDocumentItem", getPartnerSalesDocumentItem());
        values.put("InventoryValuationType", getInventoryValuationType());
        values.put("SettlementReferenceDate", getSettlementReferenceDate());
        values.put("SettlementReferenceDate_T", getSettlementReferenceDate_T());
        values.put("DistributionChannel", getDistributionChannel());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("IsSettlement") ) {
                final Object value = values.remove("IsSettlement");
                if( (value == null) || (!value.equals(getIsSettlement())) ) {
                    setIsSettlement(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeName") ) {
                final Object value = values.remove("CompanyCodeName");
                if( (value == null) || (!value.equals(getCompanyCodeName())) ) {
                    setCompanyCodeName(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("GLAccountHierarchyName") ) {
                final Object value = values.remove("GLAccountHierarchyName");
                if( (value == null) || (!value.equals(getGLAccountHierarchyName())) ) {
                    setGLAccountHierarchyName(((String) value));
                }
            }
            if( values.containsKey("BusinessProcess") ) {
                final Object value = values.remove("BusinessProcess");
                if( (value == null) || (!value.equals(getBusinessProcess())) ) {
                    setBusinessProcess(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency8") ) {
                final Object value = values.remove("FreeDefinedCurrency8");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency8())) ) {
                    setFreeDefinedCurrency8(((String) value));
                }
            }
            if( values.containsKey("PartnerCostObject") ) {
                final Object value = values.remove("PartnerCostObject");
                if( (value == null) || (!value.equals(getPartnerCostObject())) ) {
                    setPartnerCostObject(((String) value));
                }
            }
            if( values.containsKey("AssetValueDate") ) {
                final Object value = values.remove("AssetValueDate");
                if( (value == null) || (!value.equals(getAssetValueDate())) ) {
                    setAssetValueDate(((String) value));
                }
            }
            if( values.containsKey("AssetValueDate_T") ) {
                final Object value = values.remove("AssetValueDate_T");
                if( (value == null) || (!value.equals(getAssetValueDate_T())) ) {
                    setAssetValueDate_T(((String) value));
                }
            }
            if( values.containsKey("FiscalYearPeriod") ) {
                final Object value = values.remove("FiscalYearPeriod");
                if( (value == null) || (!value.equals(getFiscalYearPeriod())) ) {
                    setFiscalYearPeriod(((String) value));
                }
            }
            if( values.containsKey("QuantityIsIncomplete") ) {
                final Object value = values.remove("QuantityIsIncomplete");
                if( (value == null) || (!value.equals(getQuantityIsIncomplete())) ) {
                    setQuantityIsIncomplete(((String) value));
                }
            }
            if( values.containsKey("IsOpenItemManaged") ) {
                final Object value = values.remove("IsOpenItemManaged");
                if( (value == null) || (!value.equals(getIsOpenItemManaged())) ) {
                    setIsOpenItemManaged(((String) value));
                }
            }
            if( values.containsKey("CorporateGroupAccount") ) {
                final Object value = values.remove("CorporateGroupAccount");
                if( (value == null) || (!value.equals(getCorporateGroupAccount())) ) {
                    setCorporateGroupAccount(((String) value));
                }
            }
            if( values.containsKey("CorporateGroupAccount_T") ) {
                final Object value = values.remove("CorporateGroupAccount_T");
                if( (value == null) || (!value.equals(getCorporateGroupAccount_T())) ) {
                    setCorporateGroupAccount_T(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentType") ) {
                final Object value = values.remove("BillingDocumentType");
                if( (value == null) || (!value.equals(getBillingDocumentType())) ) {
                    setBillingDocumentType(((String) value));
                }
            }
            if( values.containsKey("FiscalQuarter") ) {
                final Object value = values.remove("FiscalQuarter");
                if( (value == null) || (!value.equals(getFiscalQuarter())) ) {
                    setFiscalQuarter(((String) value));
                }
            }
            if( values.containsKey("CorporateGroupChartOfAccounts") ) {
                final Object value = values.remove("CorporateGroupChartOfAccounts");
                if( (value == null) || (!value.equals(getCorporateGroupChartOfAccounts())) ) {
                    setCorporateGroupChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ClearingDocFiscalYear") ) {
                final Object value = values.remove("ClearingDocFiscalYear");
                if( (value == null) || (!value.equals(getClearingDocFiscalYear())) ) {
                    setClearingDocFiscalYear(((String) value));
                }
            }
            if( values.containsKey("PartnerWBSElement") ) {
                final Object value = values.remove("PartnerWBSElement");
                if( (value == null) || (!value.equals(getPartnerWBSElement())) ) {
                    setPartnerWBSElement(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency2") ) {
                final Object value = values.remove("FreeDefinedCurrency2");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency2())) ) {
                    setFreeDefinedCurrency2(((String) value));
                }
            }
            if( values.containsKey("PartnerProfitCenter") ) {
                final Object value = values.remove("PartnerProfitCenter");
                if( (value == null) || (!value.equals(getPartnerProfitCenter())) ) {
                    setPartnerProfitCenter(((String) value));
                }
            }
            if( values.containsKey("PartnerProfitCenterName") ) {
                final Object value = values.remove("PartnerProfitCenterName");
                if( (value == null) || (!value.equals(getPartnerProfitCenterName())) ) {
                    setPartnerProfitCenterName(((String) value));
                }
            }
            if( values.containsKey("PartnerControllingObjectClass") ) {
                final Object value = values.remove("PartnerControllingObjectClass");
                if( (value == null) || (!value.equals(getPartnerControllingObjectClass())) ) {
                    setPartnerControllingObjectClass(((String) value));
                }
            }
            if( values.containsKey("GLAccountType") ) {
                final Object value = values.remove("GLAccountType");
                if( (value == null) || (!value.equals(getGLAccountType())) ) {
                    setGLAccountType(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentCategory") ) {
                final Object value = values.remove("AccountingDocumentCategory");
                if( (value == null) || (!value.equals(getAccountingDocumentCategory())) ) {
                    setAccountingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("BusinessTransactionType") ) {
                final Object value = values.remove("BusinessTransactionType");
                if( (value == null) || (!value.equals(getBusinessTransactionType())) ) {
                    setBusinessTransactionType(((String) value));
                }
            }
            if( values.containsKey("CalendarMonth") ) {
                final Object value = values.remove("CalendarMonth");
                if( (value == null) || (!value.equals(getCalendarMonth())) ) {
                    setCalendarMonth(((String) value));
                }
            }
            if( values.containsKey("CalendarQuarter") ) {
                final Object value = values.remove("CalendarQuarter");
                if( (value == null) || (!value.equals(getCalendarQuarter())) ) {
                    setCalendarQuarter(((String) value));
                }
            }
            if( values.containsKey("ClearingAccountingDocument") ) {
                final Object value = values.remove("ClearingAccountingDocument");
                if( (value == null) || (!value.equals(getClearingAccountingDocument())) ) {
                    setClearingAccountingDocument(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentType") ) {
                final Object value = values.remove("AccountingDocumentType");
                if( (value == null) || (!value.equals(getAccountingDocumentType())) ) {
                    setAccountingDocumentType(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentTypeName") ) {
                final Object value = values.remove("AccountingDocumentTypeName");
                if( (value == null) || (!value.equals(getAccountingDocumentTypeName())) ) {
                    setAccountingDocumentTypeName(((String) value));
                }
            }
            if( values.containsKey("FinancialAccountType") ) {
                final Object value = values.remove("FinancialAccountType");
                if( (value == null) || (!value.equals(getFinancialAccountType())) ) {
                    setFinancialAccountType(((String) value));
                }
            }
            if( values.containsKey("FinancialAccountTypeName") ) {
                final Object value = values.remove("FinancialAccountTypeName");
                if( (value == null) || (!value.equals(getFinancialAccountTypeName())) ) {
                    setFinancialAccountTypeName(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("BusinessAreaName") ) {
                final Object value = values.remove("BusinessAreaName");
                if( (value == null) || (!value.equals(getBusinessAreaName())) ) {
                    setBusinessAreaName(((String) value));
                }
            }
            if( values.containsKey("OriginCostCtrActivityType") ) {
                final Object value = values.remove("OriginCostCtrActivityType");
                if( (value == null) || (!value.equals(getOriginCostCtrActivityType())) ) {
                    setOriginCostCtrActivityType(((String) value));
                }
            }
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("ControllingAreaName") ) {
                final Object value = values.remove("ControllingAreaName");
                if( (value == null) || (!value.equals(getControllingAreaName())) ) {
                    setControllingAreaName(((String) value));
                }
            }
            if( values.containsKey("ControllingObjectClass") ) {
                final Object value = values.remove("ControllingObjectClass");
                if( (value == null) || (!value.equals(getControllingObjectClass())) ) {
                    setControllingObjectClass(((String) value));
                }
            }
            if( values.containsKey("PartnerCostCenter") ) {
                final Object value = values.remove("PartnerCostCenter");
                if( (value == null) || (!value.equals(getPartnerCostCenter())) ) {
                    setPartnerCostCenter(((String) value));
                }
            }
            if( values.containsKey("SenderCostCenterName") ) {
                final Object value = values.remove("SenderCostCenterName");
                if( (value == null) || (!value.equals(getSenderCostCenterName())) ) {
                    setSenderCostCenterName(((String) value));
                }
            }
            if( values.containsKey("DebitCreditCode") ) {
                final Object value = values.remove("DebitCreditCode");
                if( (value == null) || (!value.equals(getDebitCreditCode())) ) {
                    setDebitCreditCode(((String) value));
                }
            }
            if( values.containsKey("DebitCreditCodeName") ) {
                final Object value = values.remove("DebitCreditCodeName");
                if( (value == null) || (!value.equals(getDebitCreditCodeName())) ) {
                    setDebitCreditCodeName(((String) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((String) value));
                }
            }
            if( values.containsKey("PostingDate_T") ) {
                final Object value = values.remove("PostingDate_T");
                if( (value == null) || (!value.equals(getPostingDate_T())) ) {
                    setPostingDate_T(((String) value));
                }
            }
            if( values.containsKey("FiscalYearVariant") ) {
                final Object value = values.remove("FiscalYearVariant");
                if( (value == null) || (!value.equals(getFiscalYearVariant())) ) {
                    setFiscalYearVariant(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("FunctionalAreaName") ) {
                final Object value = values.remove("FunctionalAreaName");
                if( (value == null) || (!value.equals(getFunctionalAreaName())) ) {
                    setFunctionalAreaName(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("BudgetPeriod") ) {
                final Object value = values.remove("BudgetPeriod");
                if( (value == null) || (!value.equals(getBudgetPeriod())) ) {
                    setBudgetPeriod(((String) value));
                }
            }
            if( values.containsKey("CalendarWeek") ) {
                final Object value = values.remove("CalendarWeek");
                if( (value == null) || (!value.equals(getCalendarWeek())) ) {
                    setCalendarWeek(((String) value));
                }
            }
            if( values.containsKey("CalendarYear") ) {
                final Object value = values.remove("CalendarYear");
                if( (value == null) || (!value.equals(getCalendarYear())) ) {
                    setCalendarYear(((String) value));
                }
            }
            if( values.containsKey("ClearingDate") ) {
                final Object value = values.remove("ClearingDate");
                if( (value == null) || (!value.equals(getClearingDate())) ) {
                    setClearingDate(((String) value));
                }
            }
            if( values.containsKey("ClearingDate_T") ) {
                final Object value = values.remove("ClearingDate_T");
                if( (value == null) || (!value.equals(getClearingDate_T())) ) {
                    setClearingDate_T(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("CostCenterName") ) {
                final Object value = values.remove("CostCenterName");
                if( (value == null) || (!value.equals(getCostCenterName())) ) {
                    setCostCenterName(((String) value));
                }
            }
            if( values.containsKey("CostObject") ) {
                final Object value = values.remove("CostObject");
                if( (value == null) || (!value.equals(getCostObject())) ) {
                    setCostObject(((String) value));
                }
            }
            if( values.containsKey("FiscalPeriod") ) {
                final Object value = values.remove("FiscalPeriod");
                if( (value == null) || (!value.equals(getFiscalPeriod())) ) {
                    setFiscalPeriod(((String) value));
                }
            }
            if( values.containsKey("FiscalWeek") ) {
                final Object value = values.remove("FiscalWeek");
                if( (value == null) || (!value.equals(getFiscalWeek())) ) {
                    setFiscalWeek(((String) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("IsReversal") ) {
                final Object value = values.remove("IsReversal");
                if( (value == null) || (!value.equals(getIsReversal())) ) {
                    setIsReversal(((String) value));
                }
            }
            if( values.containsKey("IsReversed") ) {
                final Object value = values.remove("IsReversed");
                if( (value == null) || (!value.equals(getIsReversed())) ) {
                    setIsReversed(((String) value));
                }
            }
            if( values.containsKey("IsSettled") ) {
                final Object value = values.remove("IsSettled");
                if( (value == null) || (!value.equals(getIsSettled())) ) {
                    setIsSettled(((String) value));
                }
            }
            if( values.containsKey("JointVenture") ) {
                final Object value = values.remove("JointVenture");
                if( (value == null) || (!value.equals(getJointVenture())) ) {
                    setJointVenture(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("PartnerFund") ) {
                final Object value = values.remove("PartnerFund");
                if( (value == null) || (!value.equals(getPartnerFund())) ) {
                    setPartnerFund(((String) value));
                }
            }
            if( values.containsKey("PartnerGrant") ) {
                final Object value = values.remove("PartnerGrant");
                if( (value == null) || (!value.equals(getPartnerGrant())) ) {
                    setPartnerGrant(((String) value));
                }
            }
            if( values.containsKey("PartnerOrder") ) {
                final Object value = values.remove("PartnerOrder");
                if( (value == null) || (!value.equals(getPartnerOrder())) ) {
                    setPartnerOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SoldMaterial") ) {
                final Object value = values.remove("SoldMaterial");
                if( (value == null) || (!value.equals(getSoldMaterial())) ) {
                    setSoldMaterial(((String) value));
                }
            }
            if( values.containsKey("SoldProduct") ) {
                final Object value = values.remove("SoldProduct");
                if( (value == null) || (!value.equals(getSoldProduct())) ) {
                    setSoldProduct(((String) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("HouseBank") ) {
                final Object value = values.remove("HouseBank");
                if( (value == null) || (!value.equals(getHouseBank())) ) {
                    setHouseBank(((String) value));
                }
            }
            if( values.containsKey("InventorySpecialStockValnType") ) {
                final Object value = values.remove("InventorySpecialStockValnType");
                if( (value == null) || (!value.equals(getInventorySpecialStockValnType())) ) {
                    setInventorySpecialStockValnType(((String) value));
                }
            }
            if( values.containsKey("Ledger") ) {
                final Object value = values.remove("Ledger");
                if( (value == null) || (!value.equals(getLedger())) ) {
                    setLedger(((String) value));
                }
            }
            if( values.containsKey("MasterFixedAsset") ) {
                final Object value = values.remove("MasterFixedAsset");
                if( (value == null) || (!value.equals(getMasterFixedAsset())) ) {
                    setMasterFixedAsset(((String) value));
                }
            }
            if( values.containsKey("PostingKey") ) {
                final Object value = values.remove("PostingKey");
                if( (value == null) || (!value.equals(getPostingKey())) ) {
                    setPostingKey(((String) value));
                }
            }
            if( values.containsKey("PostingKeyName") ) {
                final Object value = values.remove("PostingKeyName");
                if( (value == null) || (!value.equals(getPostingKeyName())) ) {
                    setPostingKeyName(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ProfitCenterName") ) {
                final Object value = values.remove("ProfitCenterName");
                if( (value == null) || (!value.equals(getProfitCenterName())) ) {
                    setProfitCenterName(((String) value));
                }
            }
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((String) value));
                }
            }
            if( values.containsKey("SegmentName") ) {
                final Object value = values.remove("SegmentName");
                if( (value == null) || (!value.equals(getSegmentName())) ) {
                    setSegmentName(((String) value));
                }
            }
            if( values.containsKey("SpecialGLCode") ) {
                final Object value = values.remove("SpecialGLCode");
                if( (value == null) || (!value.equals(getSpecialGLCode())) ) {
                    setSpecialGLCode(((String) value));
                }
            }
            if( values.containsKey("FinancialTransactionType") ) {
                final Object value = values.remove("FinancialTransactionType");
                if( (value == null) || (!value.equals(getFinancialTransactionType())) ) {
                    setFinancialTransactionType(((String) value));
                }
            }
            if( values.containsKey("FixedAsset") ) {
                final Object value = values.remove("FixedAsset");
                if( (value == null) || (!value.equals(getFixedAsset())) ) {
                    setFixedAsset(((String) value));
                }
            }
            if( values.containsKey("JointVentureEquityType") ) {
                final Object value = values.remove("JointVentureEquityType");
                if( (value == null) || (!value.equals(getJointVentureEquityType())) ) {
                    setJointVentureEquityType(((String) value));
                }
            }
            if( values.containsKey("HouseBankAccount") ) {
                final Object value = values.remove("HouseBankAccount");
                if( (value == null) || (!value.equals(getHouseBankAccount())) ) {
                    setHouseBankAccount(((String) value));
                }
            }
            if( values.containsKey("InventorySpecialStockType") ) {
                final Object value = values.remove("InventorySpecialStockType");
                if( (value == null) || (!value.equals(getInventorySpecialStockType())) ) {
                    setInventorySpecialStockType(((String) value));
                }
            }
            if( values.containsKey("AlternativeGLAccount") ) {
                final Object value = values.remove("AlternativeGLAccount");
                if( (value == null) || (!value.equals(getAlternativeGLAccount())) ) {
                    setAlternativeGLAccount(((String) value));
                }
            }
            if( values.containsKey("AlternativeGLAccount_T") ) {
                final Object value = values.remove("AlternativeGLAccount_T");
                if( (value == null) || (!value.equals(getAlternativeGLAccount_T())) ) {
                    setAlternativeGLAccount_T(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("PlantName") ) {
                final Object value = values.remove("PlantName");
                if( (value == null) || (!value.equals(getPlantName())) ) {
                    setPlantName(((String) value));
                }
            }
            if( values.containsKey("OrderCategory") ) {
                final Object value = values.remove("OrderCategory");
                if( (value == null) || (!value.equals(getOrderCategory())) ) {
                    setOrderCategory(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("MaterialName") ) {
                final Object value = values.remove("MaterialName");
                if( (value == null) || (!value.equals(getMaterialName())) ) {
                    setMaterialName(((String) value));
                }
            }
            if( values.containsKey("ProductGroup") ) {
                final Object value = values.remove("ProductGroup");
                if( (value == null) || (!value.equals(getProductGroup())) ) {
                    setProductGroup(((String) value));
                }
            }
            if( values.containsKey("Project") ) {
                final Object value = values.remove("Project");
                if( (value == null) || (!value.equals(getProject())) ) {
                    setProject(((String) value));
                }
            }
            if( values.containsKey("ValuationArea") ) {
                final Object value = values.remove("ValuationArea");
                if( (value == null) || (!value.equals(getValuationArea())) ) {
                    setValuationArea(((String) value));
                }
            }
            if( values.containsKey("CustomerGroup") ) {
                final Object value = values.remove("CustomerGroup");
                if( (value == null) || (!value.equals(getCustomerGroup())) ) {
                    setCustomerGroup(((String) value));
                }
            }
            if( values.containsKey("CustomerGroupName") ) {
                final Object value = values.remove("CustomerGroupName");
                if( (value == null) || (!value.equals(getCustomerGroupName())) ) {
                    setCustomerGroupName(((String) value));
                }
            }
            if( values.containsKey("InventorySpclStkSalesDocument") ) {
                final Object value = values.remove("InventorySpclStkSalesDocument");
                if( (value == null) || (!value.equals(getInventorySpclStkSalesDocument())) ) {
                    setInventorySpclStkSalesDocument(((String) value));
                }
            }
            if( values.containsKey("InventorySpclStkSalesDocItm") ) {
                final Object value = values.remove("InventorySpclStkSalesDocItm");
                if( (value == null) || (!value.equals(getInventorySpclStkSalesDocItm())) ) {
                    setInventorySpclStkSalesDocItm(((String) value));
                }
            }
            if( values.containsKey("InvtrySpclStockWBSElmntIntID") ) {
                final Object value = values.remove("InvtrySpclStockWBSElmntIntID");
                if( (value == null) || (!value.equals(getInvtrySpclStockWBSElmntIntID())) ) {
                    setInvtrySpclStockWBSElmntIntID(((String) value));
                }
            }
            if( values.containsKey("InventorySpclStockWBSElement") ) {
                final Object value = values.remove("InventorySpclStockWBSElement");
                if( (value == null) || (!value.equals(getInventorySpclStockWBSElement())) ) {
                    setInventorySpclStockWBSElement(((String) value));
                }
            }
            if( values.containsKey("CalendarYearMonth") ) {
                final Object value = values.remove("CalendarYearMonth");
                if( (value == null) || (!value.equals(getCalendarYearMonth())) ) {
                    setCalendarYearMonth(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("CustomerName") ) {
                final Object value = values.remove("CustomerName");
                if( (value == null) || (!value.equals(getCustomerName())) ) {
                    setCustomerName(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("SupplierName") ) {
                final Object value = values.remove("SupplierName");
                if( (value == null) || (!value.equals(getSupplierName())) ) {
                    setSupplierName(((String) value));
                }
            }
            if( values.containsKey("BalanceTransactionCurrency") ) {
                final Object value = values.remove("BalanceTransactionCurrency");
                if( (value == null) || (!value.equals(getBalanceTransactionCurrency())) ) {
                    setBalanceTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("AssignmentReference") ) {
                final Object value = values.remove("AssignmentReference");
                if( (value == null) || (!value.equals(getAssignmentReference())) ) {
                    setAssignmentReference(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("OrganizationDivision") ) {
                final Object value = values.remove("OrganizationDivision");
                if( (value == null) || (!value.equals(getOrganizationDivision())) ) {
                    setOrganizationDivision(((String) value));
                }
            }
            if( values.containsKey("PartnerProjectNetworkActivity") ) {
                final Object value = values.remove("PartnerProjectNetworkActivity");
                if( (value == null) || (!value.equals(getPartnerProjectNetworkActivity())) ) {
                    setPartnerProjectNetworkActivity(((String) value));
                }
            }
            if( values.containsKey("CalendarYearQuarter") ) {
                final Object value = values.remove("CalendarYearQuarter");
                if( (value == null) || (!value.equals(getCalendarYearQuarter())) ) {
                    setCalendarYearQuarter(((String) value));
                }
            }
            if( values.containsKey("IsBalanceSheetAccount") ) {
                final Object value = values.remove("IsBalanceSheetAccount");
                if( (value == null) || (!value.equals(getIsBalanceSheetAccount())) ) {
                    setIsBalanceSheetAccount(((String) value));
                }
            }
            if( values.containsKey("PartnerAccountAssignmentType") ) {
                final Object value = values.remove("PartnerAccountAssignmentType");
                if( (value == null) || (!value.equals(getPartnerAccountAssignmentType())) ) {
                    setPartnerAccountAssignmentType(((String) value));
                }
            }
            if( values.containsKey("FiscalYearWeek") ) {
                final Object value = values.remove("FiscalYearWeek");
                if( (value == null) || (!value.equals(getFiscalYearWeek())) ) {
                    setFiscalYearWeek(((String) value));
                }
            }
            if( values.containsKey("JointVentureEquityGroup") ) {
                final Object value = values.remove("JointVentureEquityGroup");
                if( (value == null) || (!value.equals(getJointVentureEquityGroup())) ) {
                    setJointVentureEquityGroup(((String) value));
                }
            }
            if( values.containsKey("FinancialManagementArea") ) {
                final Object value = values.remove("FinancialManagementArea");
                if( (value == null) || (!value.equals(getFinancialManagementArea())) ) {
                    setFinancialManagementArea(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityType") ) {
                final Object value = values.remove("CostCtrActivityType");
                if( (value == null) || (!value.equals(getCostCtrActivityType())) ) {
                    setCostCtrActivityType(((String) value));
                }
            }
            if( values.containsKey("SenderAccountAssignment") ) {
                final Object value = values.remove("SenderAccountAssignment");
                if( (value == null) || (!value.equals(getSenderAccountAssignment())) ) {
                    setSenderAccountAssignment(((String) value));
                }
            }
            if( values.containsKey("FiscalYearQuarter") ) {
                final Object value = values.remove("FiscalYearQuarter");
                if( (value == null) || (!value.equals(getFiscalYearQuarter())) ) {
                    setFiscalYearQuarter(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentType") ) {
                final Object value = values.remove("ReferenceDocumentType");
                if( (value == null) || (!value.equals(getReferenceDocumentType())) ) {
                    setReferenceDocumentType(((String) value));
                }
            }
            if( values.containsKey("GroupFixedAsset") ) {
                final Object value = values.remove("GroupFixedAsset");
                if( (value == null) || (!value.equals(getGroupFixedAsset())) ) {
                    setGroupFixedAsset(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentItemGroup") ) {
                final Object value = values.remove("ReferenceDocumentItemGroup");
                if( (value == null) || (!value.equals(getReferenceDocumentItemGroup())) ) {
                    setReferenceDocumentItemGroup(((String) value));
                }
            }
            if( values.containsKey("AssetDepreciationArea") ) {
                final Object value = values.remove("AssetDepreciationArea");
                if( (value == null) || (!value.equals(getAssetDepreciationArea())) ) {
                    setAssetDepreciationArea(((String) value));
                }
            }
            if( values.containsKey("PartnerSegment") ) {
                final Object value = values.remove("PartnerSegment");
                if( (value == null) || (!value.equals(getPartnerSegment())) ) {
                    setPartnerSegment(((String) value));
                }
            }
            if( values.containsKey("PartnerSegmentName") ) {
                final Object value = values.remove("PartnerSegmentName");
                if( (value == null) || (!value.equals(getPartnerSegmentName())) ) {
                    setPartnerSegmentName(((String) value));
                }
            }
            if( values.containsKey("ClearingJournalEntry") ) {
                final Object value = values.remove("ClearingJournalEntry");
                if( (value == null) || (!value.equals(getClearingJournalEntry())) ) {
                    setClearingJournalEntry(((String) value));
                }
            }
            if( values.containsKey("OperatingConcern") ) {
                final Object value = values.remove("OperatingConcern");
                if( (value == null) || (!value.equals(getOperatingConcern())) ) {
                    setOperatingConcern(((String) value));
                }
            }
            if( values.containsKey("InvtrySpclStockWBSElmntExtID") ) {
                final Object value = values.remove("InvtrySpclStockWBSElmntExtID");
                if( (value == null) || (!value.equals(getInvtrySpclStockWBSElmntExtID())) ) {
                    setInvtrySpclStockWBSElmntExtID(((String) value));
                }
            }
            if( values.containsKey("FiscalPeriodEndDate") ) {
                final Object value = values.remove("FiscalPeriodEndDate");
                if( (value == null) || (!value.equals(getFiscalPeriodEndDate())) ) {
                    setFiscalPeriodEndDate(((String) value));
                }
            }
            if( values.containsKey("FiscalPeriodEndDate_T") ) {
                final Object value = values.remove("FiscalPeriodEndDate_T");
                if( (value == null) || (!value.equals(getFiscalPeriodEndDate_T())) ) {
                    setFiscalPeriodEndDate_T(((String) value));
                }
            }
            if( values.containsKey("CountryChartOfAccounts") ) {
                final Object value = values.remove("CountryChartOfAccounts");
                if( (value == null) || (!value.equals(getCountryChartOfAccounts())) ) {
                    setCountryChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("FiscalPeriodStartDate") ) {
                final Object value = values.remove("FiscalPeriodStartDate");
                if( (value == null) || (!value.equals(getFiscalPeriodStartDate())) ) {
                    setFiscalPeriodStartDate(((String) value));
                }
            }
            if( values.containsKey("FiscalPeriodStartDate_T") ) {
                final Object value = values.remove("FiscalPeriodStartDate_T");
                if( (value == null) || (!value.equals(getFiscalPeriodStartDate_T())) ) {
                    setFiscalPeriodStartDate_T(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency6") ) {
                final Object value = values.remove("FreeDefinedCurrency6");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency6())) ) {
                    setFreeDefinedCurrency6(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("AccountAssignment") ) {
                final Object value = values.remove("AccountAssignment");
                if( (value == null) || (!value.equals(getAccountAssignment())) ) {
                    setAccountAssignment(((String) value));
                }
            }
            if( values.containsKey("PartnerCostCtrActivityType") ) {
                final Object value = values.remove("PartnerCostCtrActivityType");
                if( (value == null) || (!value.equals(getPartnerCostCtrActivityType())) ) {
                    setPartnerCostCtrActivityType(((String) value));
                }
            }
            if( values.containsKey("PartnerBusinessProcess") ) {
                final Object value = values.remove("PartnerBusinessProcess");
                if( (value == null) || (!value.equals(getPartnerBusinessProcess())) ) {
                    setPartnerBusinessProcess(((String) value));
                }
            }
            if( values.containsKey("RelatedNetworkActivity") ) {
                final Object value = values.remove("RelatedNetworkActivity");
                if( (value == null) || (!value.equals(getRelatedNetworkActivity())) ) {
                    setRelatedNetworkActivity(((String) value));
                }
            }
            if( values.containsKey("SalesDocument") ) {
                final Object value = values.remove("SalesDocument");
                if( (value == null) || (!value.equals(getSalesDocument())) ) {
                    setSalesDocument(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency1") ) {
                final Object value = values.remove("FreeDefinedCurrency1");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency1())) ) {
                    setFreeDefinedCurrency1(((String) value));
                }
            }
            if( values.containsKey("FiscalPeriodDate") ) {
                final Object value = values.remove("FiscalPeriodDate");
                if( (value == null) || (!value.equals(getFiscalPeriodDate())) ) {
                    setFiscalPeriodDate(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency3") ) {
                final Object value = values.remove("FreeDefinedCurrency3");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency3())) ) {
                    setFreeDefinedCurrency3(((String) value));
                }
            }
            if( values.containsKey("AssetTransactionType") ) {
                final Object value = values.remove("AssetTransactionType");
                if( (value == null) || (!value.equals(getAssetTransactionType())) ) {
                    setAssetTransactionType(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocument") ) {
                final Object value = values.remove("PurchasingDocument");
                if( (value == null) || (!value.equals(getPurchasingDocument())) ) {
                    setPurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("InvtrySpecialStockValnType_2") ) {
                final Object value = values.remove("InvtrySpecialStockValnType_2");
                if( (value == null) || (!value.equals(getInvtrySpecialStockValnType_2())) ) {
                    setInvtrySpecialStockValnType_2(((String) value));
                }
            }
            if( values.containsKey("EliminationProfitCenter") ) {
                final Object value = values.remove("EliminationProfitCenter");
                if( (value == null) || (!value.equals(getEliminationProfitCenter())) ) {
                    setEliminationProfitCenter(((String) value));
                }
            }
            if( values.containsKey("EliminationProfitCenterName") ) {
                final Object value = values.remove("EliminationProfitCenterName");
                if( (value == null) || (!value.equals(getEliminationProfitCenterName())) ) {
                    setEliminationProfitCenterName(((String) value));
                }
            }
            if( values.containsKey("GlobalCurrency") ) {
                final Object value = values.remove("GlobalCurrency");
                if( (value == null) || (!value.equals(getGlobalCurrency())) ) {
                    setGlobalCurrency(((String) value));
                }
            }
            if( values.containsKey("PredecessorReferenceDocType") ) {
                final Object value = values.remove("PredecessorReferenceDocType");
                if( (value == null) || (!value.equals(getPredecessorReferenceDocType())) ) {
                    setPredecessorReferenceDocType(((String) value));
                }
            }
            if( values.containsKey("LedgerFiscalYear") ) {
                final Object value = values.remove("LedgerFiscalYear");
                if( (value == null) || (!value.equals(getLedgerFiscalYear())) ) {
                    setLedgerFiscalYear(((String) value));
                }
            }
            if( values.containsKey("PartnerSalesDocument") ) {
                final Object value = values.remove("PartnerSalesDocument");
                if( (value == null) || (!value.equals(getPartnerSalesDocument())) ) {
                    setPartnerSalesDocument(((String) value));
                }
            }
            if( values.containsKey("PartnerAccountAssignment") ) {
                final Object value = values.remove("PartnerAccountAssignment");
                if( (value == null) || (!value.equals(getPartnerAccountAssignment())) ) {
                    setPartnerAccountAssignment(((String) value));
                }
            }
            if( values.containsKey("OffsettingAccount") ) {
                final Object value = values.remove("OffsettingAccount");
                if( (value == null) || (!value.equals(getOffsettingAccount())) ) {
                    setOffsettingAccount(((String) value));
                }
            }
            if( values.containsKey("PartnerBudgetPeriod") ) {
                final Object value = values.remove("PartnerBudgetPeriod");
                if( (value == null) || (!value.equals(getPartnerBudgetPeriod())) ) {
                    setPartnerBudgetPeriod(((String) value));
                }
            }
            if( values.containsKey("AccountingDocCreatedByUser") ) {
                final Object value = values.remove("AccountingDocCreatedByUser");
                if( (value == null) || (!value.equals(getAccountingDocCreatedByUser())) ) {
                    setAccountingDocCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency4") ) {
                final Object value = values.remove("FreeDefinedCurrency4");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency4())) ) {
                    setFreeDefinedCurrency4(((String) value));
                }
            }
            if( values.containsKey("ProjectNetwork") ) {
                final Object value = values.remove("ProjectNetwork");
                if( (value == null) || (!value.equals(getProjectNetwork())) ) {
                    setProjectNetwork(((String) value));
                }
            }
            if( values.containsKey("LineItemIsCompleted") ) {
                final Object value = values.remove("LineItemIsCompleted");
                if( (value == null) || (!value.equals(getLineItemIsCompleted())) ) {
                    setLineItemIsCompleted(((String) value));
                }
            }
            if( values.containsKey("PartnerProjectInternalID") ) {
                final Object value = values.remove("PartnerProjectInternalID");
                if( (value == null) || (!value.equals(getPartnerProjectInternalID())) ) {
                    setPartnerProjectInternalID(((String) value));
                }
            }
            if( values.containsKey("JointVentureCostRecoveryCode") ) {
                final Object value = values.remove("JointVentureCostRecoveryCode");
                if( (value == null) || (!value.equals(getJointVentureCostRecoveryCode())) ) {
                    setJointVentureCostRecoveryCode(((String) value));
                }
            }
            if( values.containsKey("InventorySpecialStockSupplier") ) {
                final Object value = values.remove("InventorySpecialStockSupplier");
                if( (value == null) || (!value.equals(getInventorySpecialStockSupplier())) ) {
                    setInventorySpecialStockSupplier(((String) value));
                }
            }
            if( values.containsKey("InvtrySpecialStockSupplierName") ) {
                final Object value = values.remove("InvtrySpecialStockSupplierName");
                if( (value == null) || (!value.equals(getInvtrySpecialStockSupplierName())) ) {
                    setInvtrySpecialStockSupplierName(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentType") ) {
                final Object value = values.remove("AccountAssignmentType");
                if( (value == null) || (!value.equals(getAccountAssignmentType())) ) {
                    setAccountAssignmentType(((String) value));
                }
            }
            if( values.containsKey("SoldProductGroup") ) {
                final Object value = values.remove("SoldProductGroup");
                if( (value == null) || (!value.equals(getSoldProductGroup())) ) {
                    setSoldProductGroup(((String) value));
                }
            }
            if( values.containsKey("MaterialGroupName") ) {
                final Object value = values.remove("MaterialGroupName");
                if( (value == null) || (!value.equals(getMaterialGroupName())) ) {
                    setMaterialGroupName(((String) value));
                }
            }
            if( values.containsKey("PartnerProject") ) {
                final Object value = values.remove("PartnerProject");
                if( (value == null) || (!value.equals(getPartnerProject())) ) {
                    setPartnerProject(((String) value));
                }
            }
            if( values.containsKey("ClearingJournalEntryFiscalYear") ) {
                final Object value = values.remove("ClearingJournalEntryFiscalYear");
                if( (value == null) || (!value.equals(getClearingJournalEntryFiscalYear())) ) {
                    setClearingJournalEntryFiscalYear(((String) value));
                }
            }
            if( values.containsKey("PartnerCompany") ) {
                final Object value = values.remove("PartnerCompany");
                if( (value == null) || (!value.equals(getPartnerCompany())) ) {
                    setPartnerCompany(((String) value));
                }
            }
            if( values.containsKey("LogicalSystem") ) {
                final Object value = values.remove("LogicalSystem");
                if( (value == null) || (!value.equals(getLogicalSystem())) ) {
                    setLogicalSystem(((String) value));
                }
            }
            if( values.containsKey("PersonnelNumber") ) {
                final Object value = values.remove("PersonnelNumber");
                if( (value == null) || (!value.equals(getPersonnelNumber())) ) {
                    setPersonnelNumber(((String) value));
                }
            }
            if( values.containsKey("GroupMasterFixedAsset") ) {
                final Object value = values.remove("GroupMasterFixedAsset");
                if( (value == null) || (!value.equals(getGroupMasterFixedAsset())) ) {
                    setGroupMasterFixedAsset(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentItem") ) {
                final Object value = values.remove("SalesDocumentItem");
                if( (value == null) || (!value.equals(getSalesDocumentItem())) ) {
                    setSalesDocumentItem(((String) value));
                }
            }
            if( values.containsKey("PartnerOrderCategory") ) {
                final Object value = values.remove("PartnerOrderCategory");
                if( (value == null) || (!value.equals(getPartnerOrderCategory())) ) {
                    setPartnerOrderCategory(((String) value));
                }
            }
            if( values.containsKey("PartnerBusinessArea") ) {
                final Object value = values.remove("PartnerBusinessArea");
                if( (value == null) || (!value.equals(getPartnerBusinessArea())) ) {
                    setPartnerBusinessArea(((String) value));
                }
            }
            if( values.containsKey("PartnerBusinessAreaName") ) {
                final Object value = values.remove("PartnerBusinessAreaName");
                if( (value == null) || (!value.equals(getPartnerBusinessAreaName())) ) {
                    setPartnerBusinessAreaName(((String) value));
                }
            }
            if( values.containsKey("PartnerFunctionalArea") ) {
                final Object value = values.remove("PartnerFunctionalArea");
                if( (value == null) || (!value.equals(getPartnerFunctionalArea())) ) {
                    setPartnerFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("PartnerFunctionalAreaName") ) {
                final Object value = values.remove("PartnerFunctionalAreaName");
                if( (value == null) || (!value.equals(getPartnerFunctionalAreaName())) ) {
                    setPartnerFunctionalAreaName(((String) value));
                }
            }
            if( values.containsKey("ProjectExternalID") ) {
                final Object value = values.remove("ProjectExternalID");
                if( (value == null) || (!value.equals(getProjectExternalID())) ) {
                    setProjectExternalID(((String) value));
                }
            }
            if( values.containsKey("OriginCostCenter") ) {
                final Object value = values.remove("OriginCostCenter");
                if( (value == null) || (!value.equals(getOriginCostCenter())) ) {
                    setOriginCostCenter(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency5") ) {
                final Object value = values.remove("FreeDefinedCurrency5");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency5())) ) {
                    setFreeDefinedCurrency5(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeCurrency") ) {
                final Object value = values.remove("CompanyCodeCurrency");
                if( (value == null) || (!value.equals(getCompanyCodeCurrency())) ) {
                    setCompanyCodeCurrency(((String) value));
                }
            }
            if( values.containsKey("OriginObjectType") ) {
                final Object value = values.remove("OriginObjectType");
                if( (value == null) || (!value.equals(getOriginObjectType())) ) {
                    setOriginObjectType(((String) value));
                }
            }
            if( values.containsKey("ControllingObjectDebitType") ) {
                final Object value = values.remove("ControllingObjectDebitType");
                if( (value == null) || (!value.equals(getControllingObjectDebitType())) ) {
                    setControllingObjectDebitType(((String) value));
                }
            }
            if( values.containsKey("PartnerWBSElementInternalID") ) {
                final Object value = values.remove("PartnerWBSElementInternalID");
                if( (value == null) || (!value.equals(getPartnerWBSElementInternalID())) ) {
                    setPartnerWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("GLAccountHierarchy") ) {
                final Object value = values.remove("GLAccountHierarchy");
                if( (value == null) || (!value.equals(getGLAccountHierarchy())) ) {
                    setGLAccountHierarchy(((String) value));
                }
            }
            if( values.containsKey("CustomerServiceNotification") ) {
                final Object value = values.remove("CustomerServiceNotification");
                if( (value == null) || (!value.equals(getCustomerServiceNotification())) ) {
                    setCustomerServiceNotification(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency7") ) {
                final Object value = values.remove("FreeDefinedCurrency7");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency7())) ) {
                    setFreeDefinedCurrency7(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentNumber") ) {
                final Object value = values.remove("AccountAssignmentNumber");
                if( (value == null) || (!value.equals(getAccountAssignmentNumber())) ) {
                    setAccountAssignmentNumber(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("TransactionTypeDetermination") ) {
                final Object value = values.remove("TransactionTypeDetermination");
                if( (value == null) || (!value.equals(getTransactionTypeDetermination())) ) {
                    setTransactionTypeDetermination(((String) value));
                }
            }
            if( values.containsKey("PartnerProjectNetwork") ) {
                final Object value = values.remove("PartnerProjectNetwork");
                if( (value == null) || (!value.equals(getPartnerProjectNetwork())) ) {
                    setPartnerProjectNetwork(((String) value));
                }
            }
            if( values.containsKey("PartnerCompanyCode") ) {
                final Object value = values.remove("PartnerCompanyCode");
                if( (value == null) || (!value.equals(getPartnerCompanyCode())) ) {
                    setPartnerCompanyCode(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("OffsettingAccountType") ) {
                final Object value = values.remove("OffsettingAccountType");
                if( (value == null) || (!value.equals(getOffsettingAccountType())) ) {
                    setOffsettingAccountType(((String) value));
                }
            }
            if( values.containsKey("CalendarYearWeek") ) {
                final Object value = values.remove("CalendarYearWeek");
                if( (value == null) || (!value.equals(getCalendarYearWeek())) ) {
                    setCalendarYearWeek(((String) value));
                }
            }
            if( values.containsKey("SenderAccountAssignmentType") ) {
                final Object value = values.remove("SenderAccountAssignmentType");
                if( (value == null) || (!value.equals(getSenderAccountAssignmentType())) ) {
                    setSenderAccountAssignmentType(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItem") ) {
                final Object value = values.remove("PurchasingDocumentItem");
                if( (value == null) || (!value.equals(getPurchasingDocumentItem())) ) {
                    setPurchasingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("SenderGLAccount") ) {
                final Object value = values.remove("SenderGLAccount");
                if( (value == null) || (!value.equals(getSenderGLAccount())) ) {
                    setSenderGLAccount(((String) value));
                }
            }
            if( values.containsKey("PartnerSalesDocumentItem") ) {
                final Object value = values.remove("PartnerSalesDocumentItem");
                if( (value == null) || (!value.equals(getPartnerSalesDocumentItem())) ) {
                    setPartnerSalesDocumentItem(((String) value));
                }
            }
            if( values.containsKey("InventoryValuationType") ) {
                final Object value = values.remove("InventoryValuationType");
                if( (value == null) || (!value.equals(getInventoryValuationType())) ) {
                    setInventoryValuationType(((String) value));
                }
            }
            if( values.containsKey("SettlementReferenceDate") ) {
                final Object value = values.remove("SettlementReferenceDate");
                if( (value == null) || (!value.equals(getSettlementReferenceDate())) ) {
                    setSettlementReferenceDate(((String) value));
                }
            }
            if( values.containsKey("SettlementReferenceDate_T") ) {
                final Object value = values.remove("SettlementReferenceDate_T");
                if( (value == null) || (!value.equals(getSettlementReferenceDate_T())) ) {
                    setSettlementReferenceDate_T(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> IsSettlementResultField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new IsSettlementResultField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> IsSettlementResultField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new IsSettlementResultField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
