/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.LineItemIsCompletedField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.LineItemIsCompletedSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Line Item is Completed (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>LineItemIsCompleted</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LineItemIsCompleted extends VdmEntity<LineItemIsCompleted>
{

    /**
     * Selector for all available fields of LineItemIsCompleted.
     *
     */
    public final static LineItemIsCompletedSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LineItemIsCompleted_ID</b>
     * </p>
     *
     * @return Line Item is Completed
     */
    @Key
    @SerializedName( "LineItemIsCompleted_ID" )
    @JsonProperty( "LineItemIsCompleted_ID" )
    @Nullable
    @ODataField( odataName = "LineItemIsCompleted_ID" )
    private String lineItemIsCompleted_ID;
    /**
     * Use with available fluent helpers to apply the <b>LineItemIsCompleted_ID</b> field to query operations.
     *
     */
    public final static LineItemIsCompletedField<String> LINE_ITEM_IS_COMPLETED_ID =
        new LineItemIsCompletedField<String>("LineItemIsCompleted_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LineItemIsCompletedText</b>
     * </p>
     *
     * @return Line Item is Completed (Description)
     */
    @SerializedName( "LineItemIsCompletedText" )
    @JsonProperty( "LineItemIsCompletedText" )
    @Nullable
    @ODataField( odataName = "LineItemIsCompletedText" )
    private String lineItemIsCompletedText;
    /**
     * Use with available fluent helpers to apply the <b>LineItemIsCompletedText</b> field to query operations.
     *
     */
    public final static LineItemIsCompletedField<String> LINE_ITEM_IS_COMPLETED_TEXT =
        new LineItemIsCompletedField<String>("LineItemIsCompletedText");

    @Nonnull
    @Override
    public Class<LineItemIsCompleted> getType()
    {
        return LineItemIsCompleted.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LineItemIsCompleted_ID</b>
     * </p>
     *
     * @param lineItemIsCompleted_ID
     *            Line Item is Completed
     */
    public void setLineItemIsCompleted_ID( @Nullable final String lineItemIsCompleted_ID )
    {
        rememberChangedField("LineItemIsCompleted_ID", this.lineItemIsCompleted_ID);
        this.lineItemIsCompleted_ID = lineItemIsCompleted_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LineItemIsCompletedText</b>
     * </p>
     *
     * @param lineItemIsCompletedText
     *            Line Item is Completed (Description)
     */
    public void setLineItemIsCompletedText( @Nullable final String lineItemIsCompletedText )
    {
        rememberChangedField("LineItemIsCompletedText", this.lineItemIsCompletedText);
        this.lineItemIsCompletedText = lineItemIsCompletedText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "LineItemIsCompleted";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LineItemIsCompleted_ID", getLineItemIsCompleted_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LineItemIsCompleted_ID", getLineItemIsCompleted_ID());
        values.put("LineItemIsCompletedText", getLineItemIsCompletedText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LineItemIsCompleted_ID") ) {
                final Object value = values.remove("LineItemIsCompleted_ID");
                if( (value == null) || (!value.equals(getLineItemIsCompleted_ID())) ) {
                    setLineItemIsCompleted_ID(((String) value));
                }
            }
            if( values.containsKey("LineItemIsCompletedText") ) {
                final Object value = values.remove("LineItemIsCompletedText");
                if( (value == null) || (!value.equals(getLineItemIsCompletedText())) ) {
                    setLineItemIsCompletedText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LineItemIsCompletedField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LineItemIsCompletedField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LineItemIsCompletedField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LineItemIsCompletedField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
