/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.LineItemIsCompletedSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LineItemIsCompleted LineItemIsCompleted}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class LineItemIsCompletedByKeyFluentHelper
    extends
    FluentHelperByKey<LineItemIsCompletedByKeyFluentHelper, LineItemIsCompleted, LineItemIsCompletedSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LineItemIsCompleted LineItemIsCompleted}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code LineItemIsCompleted}
     * @param lineItemIsCompleted_ID
     *            Line Item is Completed
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code LineItemIsCompleted}
     */
    public LineItemIsCompletedByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String lineItemIsCompleted_ID )
    {
        super(servicePath, entityCollection);
        this.key.put("LineItemIsCompleted_ID", lineItemIsCompleted_ID);
    }

    @Override
    @Nonnull
    protected Class<LineItemIsCompleted> getEntityClass()
    {
        return LineItemIsCompleted.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
