/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.LogicalSystemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.LogicalSystemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Logical System (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>LogicalSystem</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LogicalSystem extends VdmEntity<LogicalSystem>
{

    /**
     * Selector for all available fields of LogicalSystem.
     *
     */
    public final static LogicalSystemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem_ID</b>
     * </p>
     *
     * @return Logical System
     */
    @Key
    @SerializedName( "LogicalSystem_ID" )
    @JsonProperty( "LogicalSystem_ID" )
    @Nullable
    @ODataField( odataName = "LogicalSystem_ID" )
    private String logicalSystem_ID;
    /**
     * Use with available fluent helpers to apply the <b>LogicalSystem_ID</b> field to query operations.
     *
     */
    public final static LogicalSystemField<String> LOGICAL_SYSTEM_ID =
        new LogicalSystemField<String>("LogicalSystem_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystemText</b>
     * </p>
     *
     * @return Logical System (Description)
     */
    @SerializedName( "LogicalSystemText" )
    @JsonProperty( "LogicalSystemText" )
    @Nullable
    @ODataField( odataName = "LogicalSystemText" )
    private String logicalSystemText;
    /**
     * Use with available fluent helpers to apply the <b>LogicalSystemText</b> field to query operations.
     *
     */
    public final static LogicalSystemField<String> LOGICAL_SYSTEM_TEXT =
        new LogicalSystemField<String>("LogicalSystemText");

    @Nonnull
    @Override
    public Class<LogicalSystem> getType()
    {
        return LogicalSystem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem_ID</b>
     * </p>
     *
     * @param logicalSystem_ID
     *            Logical System
     */
    public void setLogicalSystem_ID( @Nullable final String logicalSystem_ID )
    {
        rememberChangedField("LogicalSystem_ID", this.logicalSystem_ID);
        this.logicalSystem_ID = logicalSystem_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystemText</b>
     * </p>
     *
     * @param logicalSystemText
     *            Logical System (Description)
     */
    public void setLogicalSystemText( @Nullable final String logicalSystemText )
    {
        rememberChangedField("LogicalSystemText", this.logicalSystemText);
        this.logicalSystemText = logicalSystemText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "LogicalSystem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LogicalSystem_ID", getLogicalSystem_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LogicalSystem_ID", getLogicalSystem_ID());
        values.put("LogicalSystemText", getLogicalSystemText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LogicalSystem_ID") ) {
                final Object value = values.remove("LogicalSystem_ID");
                if( (value == null) || (!value.equals(getLogicalSystem_ID())) ) {
                    setLogicalSystem_ID(((String) value));
                }
            }
            if( values.containsKey("LogicalSystemText") ) {
                final Object value = values.remove("LogicalSystemText");
                if( (value == null) || (!value.equals(getLogicalSystemText())) ) {
                    setLogicalSystemText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> LogicalSystemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LogicalSystemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LogicalSystemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LogicalSystemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
