/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.MasterFixedAssetField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.MasterFixedAssetSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Fixed Asset (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MasterFixedAsset</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MasterFixedAsset extends VdmEntity<MasterFixedAsset>
{

    /**
     * Selector for all available fields of MasterFixedAsset.
     *
     */
    public final static MasterFixedAssetSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset_ID</b>
     * </p>
     *
     * @return Fixed Asset
     */
    @Key
    @SerializedName( "MasterFixedAsset_ID" )
    @JsonProperty( "MasterFixedAsset_ID" )
    @Nullable
    @ODataField( odataName = "MasterFixedAsset_ID" )
    private String masterFixedAsset_ID;
    /**
     * Use with available fluent helpers to apply the <b>MasterFixedAsset_ID</b> field to query operations.
     *
     */
    public final static MasterFixedAssetField<String> MASTER_FIXED_ASSET_ID =
        new MasterFixedAssetField<String>("MasterFixedAsset_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAssetText</b>
     * </p>
     *
     * @return Fixed Asset (Description)
     */
    @SerializedName( "MasterFixedAssetText" )
    @JsonProperty( "MasterFixedAssetText" )
    @Nullable
    @ODataField( odataName = "MasterFixedAssetText" )
    private String masterFixedAssetText;
    /**
     * Use with available fluent helpers to apply the <b>MasterFixedAssetText</b> field to query operations.
     *
     */
    public final static MasterFixedAssetField<String> MASTER_FIXED_ASSET_TEXT =
        new MasterFixedAssetField<String>("MasterFixedAssetText");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Fixed Asset (Company Code)
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static MasterFixedAssetField<String> COMPANY_CODE = new MasterFixedAssetField<String>("CompanyCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @return Company Code (Description) (Parent Description)
     */
    @SerializedName( "CompanyCodeName" )
    @JsonProperty( "CompanyCodeName" )
    @Nullable
    @ODataField( odataName = "CompanyCodeName" )
    private String companyCodeName;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeName</b> field to query operations.
     *
     */
    public final static MasterFixedAssetField<String> COMPANY_CODE_NAME =
        new MasterFixedAssetField<String>("CompanyCodeName");

    @Nonnull
    @Override
    public Class<MasterFixedAsset> getType()
    {
        return MasterFixedAsset.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset_ID</b>
     * </p>
     *
     * @param masterFixedAsset_ID
     *            Fixed Asset
     */
    public void setMasterFixedAsset_ID( @Nullable final String masterFixedAsset_ID )
    {
        rememberChangedField("MasterFixedAsset_ID", this.masterFixedAsset_ID);
        this.masterFixedAsset_ID = masterFixedAsset_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAssetText</b>
     * </p>
     *
     * @param masterFixedAssetText
     *            Fixed Asset (Description)
     */
    public void setMasterFixedAssetText( @Nullable final String masterFixedAssetText )
    {
        rememberChangedField("MasterFixedAssetText", this.masterFixedAssetText);
        this.masterFixedAssetText = masterFixedAssetText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Fixed Asset (Company Code)
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @param companyCodeName
     *            Company Code (Description) (Parent Description)
     */
    public void setCompanyCodeName( @Nullable final String companyCodeName )
    {
        rememberChangedField("CompanyCodeName", this.companyCodeName);
        this.companyCodeName = companyCodeName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MasterFixedAsset";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MasterFixedAsset_ID", getMasterFixedAsset_ID());
        result.put("CompanyCode", getCompanyCode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MasterFixedAsset_ID", getMasterFixedAsset_ID());
        values.put("MasterFixedAssetText", getMasterFixedAssetText());
        values.put("CompanyCode", getCompanyCode());
        values.put("CompanyCodeName", getCompanyCodeName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MasterFixedAsset_ID") ) {
                final Object value = values.remove("MasterFixedAsset_ID");
                if( (value == null) || (!value.equals(getMasterFixedAsset_ID())) ) {
                    setMasterFixedAsset_ID(((String) value));
                }
            }
            if( values.containsKey("MasterFixedAssetText") ) {
                final Object value = values.remove("MasterFixedAssetText");
                if( (value == null) || (!value.equals(getMasterFixedAssetText())) ) {
                    setMasterFixedAssetText(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeName") ) {
                final Object value = values.remove("CompanyCodeName");
                if( (value == null) || (!value.equals(getCompanyCodeName())) ) {
                    setCompanyCodeName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MasterFixedAssetField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MasterFixedAssetField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MasterFixedAssetField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MasterFixedAssetField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
