/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.MasterFixedAssetSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MasterFixedAsset MasterFixedAsset} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class MasterFixedAssetByKeyFluentHelper
    extends
    FluentHelperByKey<MasterFixedAssetByKeyFluentHelper, MasterFixedAsset, MasterFixedAssetSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MasterFixedAsset MasterFixedAsset} entity
     * with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param companyCode
     *            Fixed Asset (Company Code)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MasterFixedAsset}
     * @param servicePath
     *            Service path to be used to fetch a single {@code MasterFixedAsset}
     * @param masterFixedAsset_ID
     *            Fixed Asset
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     */
    public MasterFixedAssetByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String masterFixedAsset_ID,
        final String companyCode )
    {
        super(servicePath, entityCollection);
        this.key.put("MasterFixedAsset_ID", masterFixedAsset_ID);
        this.key.put("CompanyCode", companyCode);
    }

    @Override
    @Nonnull
    protected Class<MasterFixedAsset> getEntityClass()
    {
        return MasterFixedAsset.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
