/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.MaterialField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.MaterialSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Product (Deprecated) (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>Material</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Material extends VdmEntity<Material>
{

    /**
     * Selector for all available fields of Material.
     *
     */
    public final static MaterialSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material_ID</b>
     * </p>
     *
     * @return Product (Deprecated)
     */
    @Key
    @SerializedName( "Material_ID" )
    @JsonProperty( "Material_ID" )
    @Nullable
    @ODataField( odataName = "Material_ID" )
    private String material_ID;
    /**
     * Use with available fluent helpers to apply the <b>Material_ID</b> field to query operations.
     *
     */
    public final static MaterialField<String> MATERIAL_ID = new MaterialField<String>("Material_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialText</b>
     * </p>
     *
     * @return Product (Deprecated) (Description)
     */
    @SerializedName( "MaterialText" )
    @JsonProperty( "MaterialText" )
    @Nullable
    @ODataField( odataName = "MaterialText" )
    private String materialText;
    /**
     * Use with available fluent helpers to apply the <b>MaterialText</b> field to query operations.
     *
     */
    public final static MaterialField<String> MATERIAL_TEXT = new MaterialField<String>("MaterialText");

    @Nonnull
    @Override
    public Class<Material> getType()
    {
        return Material.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material_ID</b>
     * </p>
     *
     * @param material_ID
     *            Product (Deprecated)
     */
    public void setMaterial_ID( @Nullable final String material_ID )
    {
        rememberChangedField("Material_ID", this.material_ID);
        this.material_ID = material_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialText</b>
     * </p>
     *
     * @param materialText
     *            Product (Deprecated) (Description)
     */
    public void setMaterialText( @Nullable final String materialText )
    {
        rememberChangedField("MaterialText", this.materialText);
        this.materialText = materialText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Material";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material_ID", getMaterial_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material_ID", getMaterial_ID());
        values.put("MaterialText", getMaterialText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material_ID") ) {
                final Object value = values.remove("Material_ID");
                if( (value == null) || (!value.equals(getMaterial_ID())) ) {
                    setMaterial_ID(((String) value));
                }
            }
            if( values.containsKey("MaterialText") ) {
                final Object value = values.remove("MaterialText");
                if( (value == null) || (!value.equals(getMaterialText())) ) {
                    setMaterialText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> MaterialField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaterialField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaterialField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaterialField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
