/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.MaterialGroupField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.MaterialGroupSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Product Sold Group (Deprecated) (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaterialGroup</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaterialGroup extends VdmEntity<MaterialGroup>
{

    /**
     * Selector for all available fields of MaterialGroup.
     *
     */
    public final static MaterialGroupSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup_ID</b>
     * </p>
     *
     * @return Product Sold Group (Deprecated)
     */
    @Key
    @SerializedName( "MaterialGroup_ID" )
    @JsonProperty( "MaterialGroup_ID" )
    @Nullable
    @ODataField( odataName = "MaterialGroup_ID" )
    private String materialGroup_ID;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup_ID</b> field to query operations.
     *
     */
    public final static MaterialGroupField<String> MATERIAL_GROUP_ID =
        new MaterialGroupField<String>("MaterialGroup_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupText</b>
     * </p>
     *
     * @return Product Sold Group (Deprecated) (Description)
     */
    @SerializedName( "MaterialGroupText" )
    @JsonProperty( "MaterialGroupText" )
    @Nullable
    @ODataField( odataName = "MaterialGroupText" )
    private String materialGroupText;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroupText</b> field to query operations.
     *
     */
    public final static MaterialGroupField<String> MATERIAL_GROUP_TEXT =
        new MaterialGroupField<String>("MaterialGroupText");

    @Nonnull
    @Override
    public Class<MaterialGroup> getType()
    {
        return MaterialGroup.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup_ID</b>
     * </p>
     *
     * @param materialGroup_ID
     *            Product Sold Group (Deprecated)
     */
    public void setMaterialGroup_ID( @Nullable final String materialGroup_ID )
    {
        rememberChangedField("MaterialGroup_ID", this.materialGroup_ID);
        this.materialGroup_ID = materialGroup_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupText</b>
     * </p>
     *
     * @param materialGroupText
     *            Product Sold Group (Deprecated) (Description)
     */
    public void setMaterialGroupText( @Nullable final String materialGroupText )
    {
        rememberChangedField("MaterialGroupText", this.materialGroupText);
        this.materialGroupText = materialGroupText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaterialGroup";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaterialGroup_ID", getMaterialGroup_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaterialGroup_ID", getMaterialGroup_ID());
        values.put("MaterialGroupText", getMaterialGroupText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaterialGroup_ID") ) {
                final Object value = values.remove("MaterialGroup_ID");
                if( (value == null) || (!value.equals(getMaterialGroup_ID())) ) {
                    setMaterialGroup_ID(((String) value));
                }
            }
            if( values.containsKey("MaterialGroupText") ) {
                final Object value = values.remove("MaterialGroupText");
                if( (value == null) || (!value.equals(getMaterialGroupText())) ) {
                    setMaterialGroupText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> MaterialGroupField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaterialGroupField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaterialGroupField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaterialGroupField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
