/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.ODataQueryAdditionalMetadataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.ODataQueryAdditionalMetadataSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>ODataQueryAdditionalMetadata</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ODataQueryAdditionalMetadata extends VdmEntity<ODataQueryAdditionalMetadata>
{

    /**
     * Selector for all available fields of ODataQueryAdditionalMetadata.
     *
     */
    public final static ODataQueryAdditionalMetadataSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ODataQueryMetadata</b>
     * </p>
     *
     * @return The oDataQueryMetadata contained in this entity.
     */
    @Key
    @SerializedName( "ODataQueryMetadata" )
    @JsonProperty( "ODataQueryMetadata" )
    @Nullable
    @ODataField( odataName = "ODataQueryMetadata" )
    private String oDataQueryMetadata;
    /**
     * Use with available fluent helpers to apply the <b>ODataQueryMetadata</b> field to query operations.
     *
     */
    public final static ODataQueryAdditionalMetadataField<String> O_DATA_QUERY_METADATA =
        new ODataQueryAdditionalMetadataField<String>("ODataQueryMetadata");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ODataQueryMetadataValue_Current</b>
     * </p>
     *
     * @return The oDataQueryMetadataValue_Current contained in this entity.
     */
    @SerializedName( "ODataQueryMetadataValue_Current" )
    @JsonProperty( "ODataQueryMetadataValue_Current" )
    @Nullable
    @ODataField( odataName = "ODataQueryMetadataValue_Current" )
    private String oDataQueryMetadataValue_Current;
    /**
     * Use with available fluent helpers to apply the <b>ODataQueryMetadataValue_Current</b> field to query operations.
     *
     */
    public final static ODataQueryAdditionalMetadataField<String> O_DATA_QUERY_METADATA_VALUE_CURRENT =
        new ODataQueryAdditionalMetadataField<String>("ODataQueryMetadataValue_Current");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ODataQueryMetadataValueAtDefine</b>
     * </p>
     *
     * @return The oDataQueryMetadataValueAtDefine contained in this entity.
     */
    @SerializedName( "ODataQueryMetadataValueAtDefine" )
    @JsonProperty( "ODataQueryMetadataValueAtDefine" )
    @Nullable
    @ODataField( odataName = "ODataQueryMetadataValueAtDefine" )
    private String oDataQueryMetadataValueAtDefine;
    /**
     * Use with available fluent helpers to apply the <b>ODataQueryMetadataValueAtDefine</b> field to query operations.
     *
     */
    public final static ODataQueryAdditionalMetadataField<String> O_DATA_QUERY_METADATA_VALUE_AT_DEFINE =
        new ODataQueryAdditionalMetadataField<String>("ODataQueryMetadataValueAtDefine");

    @Nonnull
    @Override
    public Class<ODataQueryAdditionalMetadata> getType()
    {
        return ODataQueryAdditionalMetadata.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ODataQueryMetadata</b>
     * </p>
     *
     * @param oDataQueryMetadata
     *            The oDataQueryMetadata to set.
     */
    public void setODataQueryMetadata( @Nullable final String oDataQueryMetadata )
    {
        rememberChangedField("ODataQueryMetadata", this.oDataQueryMetadata);
        this.oDataQueryMetadata = oDataQueryMetadata;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ODataQueryMetadataValue_Current</b>
     * </p>
     *
     * @param oDataQueryMetadataValue_Current
     *            The oDataQueryMetadataValue_Current to set.
     */
    public void setODataQueryMetadataValue_Current( @Nullable final String oDataQueryMetadataValue_Current )
    {
        rememberChangedField("ODataQueryMetadataValue_Current", this.oDataQueryMetadataValue_Current);
        this.oDataQueryMetadataValue_Current = oDataQueryMetadataValue_Current;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ODataQueryMetadataValueAtDefine</b>
     * </p>
     *
     * @param oDataQueryMetadataValueAtDefine
     *            The oDataQueryMetadataValueAtDefine to set.
     */
    public void setODataQueryMetadataValueAtDefine( @Nullable final String oDataQueryMetadataValueAtDefine )
    {
        rememberChangedField("ODataQueryMetadataValueAtDefine", this.oDataQueryMetadataValueAtDefine);
        this.oDataQueryMetadataValueAtDefine = oDataQueryMetadataValueAtDefine;
    }

    @Override
    protected String getEntityCollection()
    {
        return "AdditionalMetadata";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ODataQueryMetadata", getODataQueryMetadata());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ODataQueryMetadata", getODataQueryMetadata());
        values.put("ODataQueryMetadataValue_Current", getODataQueryMetadataValue_Current());
        values.put("ODataQueryMetadataValueAtDefine", getODataQueryMetadataValueAtDefine());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ODataQueryMetadata") ) {
                final Object value = values.remove("ODataQueryMetadata");
                if( (value == null) || (!value.equals(getODataQueryMetadata())) ) {
                    setODataQueryMetadata(((String) value));
                }
            }
            if( values.containsKey("ODataQueryMetadataValue_Current") ) {
                final Object value = values.remove("ODataQueryMetadataValue_Current");
                if( (value == null) || (!value.equals(getODataQueryMetadataValue_Current())) ) {
                    setODataQueryMetadataValue_Current(((String) value));
                }
            }
            if( values.containsKey("ODataQueryMetadataValueAtDefine") ) {
                final Object value = values.remove("ODataQueryMetadataValueAtDefine");
                if( (value == null) || (!value.equals(getODataQueryMetadataValueAtDefine())) ) {
                    setODataQueryMetadataValueAtDefine(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ODataQueryAdditionalMetadataField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ODataQueryAdditionalMetadataField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ODataQueryAdditionalMetadataField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ODataQueryAdditionalMetadataField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
