/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.OffsettingAccountField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.OffsettingAccountSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Offsetting Account (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>OffsettingAccount</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class OffsettingAccount extends VdmEntity<OffsettingAccount>
{

    /**
     * Selector for all available fields of OffsettingAccount.
     *
     */
    public final static OffsettingAccountSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccount_ID</b>
     * </p>
     *
     * @return Offsetting Account
     */
    @Key
    @SerializedName( "OffsettingAccount_ID" )
    @JsonProperty( "OffsettingAccount_ID" )
    @Nullable
    @ODataField( odataName = "OffsettingAccount_ID" )
    private String offsettingAccount_ID;
    /**
     * Use with available fluent helpers to apply the <b>OffsettingAccount_ID</b> field to query operations.
     *
     */
    public final static OffsettingAccountField<String> OFFSETTING_ACCOUNT_ID =
        new OffsettingAccountField<String>("OffsettingAccount_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccountText</b>
     * </p>
     *
     * @return Offsetting Account (Description)
     */
    @SerializedName( "OffsettingAccountText" )
    @JsonProperty( "OffsettingAccountText" )
    @Nullable
    @ODataField( odataName = "OffsettingAccountText" )
    private String offsettingAccountText;
    /**
     * Use with available fluent helpers to apply the <b>OffsettingAccountText</b> field to query operations.
     *
     */
    public final static OffsettingAccountField<String> OFFSETTING_ACCOUNT_TEXT =
        new OffsettingAccountField<String>("OffsettingAccountText");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccountType</b>
     * </p>
     *
     * @return Offsetting Account (Offsetting Account Type)
     */
    @Key
    @SerializedName( "OffsettingAccountType" )
    @JsonProperty( "OffsettingAccountType" )
    @Nullable
    @ODataField( odataName = "OffsettingAccountType" )
    private String offsettingAccountType;
    /**
     * Use with available fluent helpers to apply the <b>OffsettingAccountType</b> field to query operations.
     *
     */
    public final static OffsettingAccountField<String> OFFSETTING_ACCOUNT_TYPE =
        new OffsettingAccountField<String>("OffsettingAccountType");

    @Nonnull
    @Override
    public Class<OffsettingAccount> getType()
    {
        return OffsettingAccount.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccount_ID</b>
     * </p>
     *
     * @param offsettingAccount_ID
     *            Offsetting Account
     */
    public void setOffsettingAccount_ID( @Nullable final String offsettingAccount_ID )
    {
        rememberChangedField("OffsettingAccount_ID", this.offsettingAccount_ID);
        this.offsettingAccount_ID = offsettingAccount_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccountText</b>
     * </p>
     *
     * @param offsettingAccountText
     *            Offsetting Account (Description)
     */
    public void setOffsettingAccountText( @Nullable final String offsettingAccountText )
    {
        rememberChangedField("OffsettingAccountText", this.offsettingAccountText);
        this.offsettingAccountText = offsettingAccountText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccountType</b>
     * </p>
     *
     * @param offsettingAccountType
     *            Offsetting Account (Offsetting Account Type)
     */
    public void setOffsettingAccountType( @Nullable final String offsettingAccountType )
    {
        rememberChangedField("OffsettingAccountType", this.offsettingAccountType);
        this.offsettingAccountType = offsettingAccountType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "OffsettingAccount";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("OffsettingAccount_ID", getOffsettingAccount_ID());
        result.put("OffsettingAccountType", getOffsettingAccountType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("OffsettingAccount_ID", getOffsettingAccount_ID());
        values.put("OffsettingAccountText", getOffsettingAccountText());
        values.put("OffsettingAccountType", getOffsettingAccountType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("OffsettingAccount_ID") ) {
                final Object value = values.remove("OffsettingAccount_ID");
                if( (value == null) || (!value.equals(getOffsettingAccount_ID())) ) {
                    setOffsettingAccount_ID(((String) value));
                }
            }
            if( values.containsKey("OffsettingAccountText") ) {
                final Object value = values.remove("OffsettingAccountText");
                if( (value == null) || (!value.equals(getOffsettingAccountText())) ) {
                    setOffsettingAccountText(((String) value));
                }
            }
            if( values.containsKey("OffsettingAccountType") ) {
                final Object value = values.remove("OffsettingAccountType");
                if( (value == null) || (!value.equals(getOffsettingAccountType())) ) {
                    setOffsettingAccountType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> OffsettingAccountField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new OffsettingAccountField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> OffsettingAccountField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new OffsettingAccountField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
