/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.OffsettingAccountSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount OffsettingAccount} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class OffsettingAccountByKeyFluentHelper
    extends
    FluentHelperByKey<OffsettingAccountByKeyFluentHelper, OffsettingAccount, OffsettingAccountSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount OffsettingAccount}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code OffsettingAccount}
     * @param offsettingAccount_ID
     *            Offsetting Account
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code OffsettingAccount}
     * @param offsettingAccountType
     *            Offsetting Account (Offsetting Account Type)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     */
    public OffsettingAccountByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String offsettingAccount_ID,
        final String offsettingAccountType )
    {
        super(servicePath, entityCollection);
        this.key.put("OffsettingAccount_ID", offsettingAccount_ID);
        this.key.put("OffsettingAccountType", offsettingAccountType);
    }

    @Override
    @Nonnull
    protected Class<OffsettingAccount> getEntityClass()
    {
        return OffsettingAccount.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
