/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.OffsettingAccount_2Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.OffsettingAccount_2Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Offsetting Account Type (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>OffsettingAccountType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class OffsettingAccount_2 extends VdmEntity<OffsettingAccount_2>
{

    /**
     * Selector for all available fields of OffsettingAccount_2.
     *
     */
    public final static OffsettingAccount_2Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccountType_ID</b>
     * </p>
     *
     * @return Offsetting Account Type
     */
    @Key
    @SerializedName( "OffsettingAccountType_ID" )
    @JsonProperty( "OffsettingAccountType_ID" )
    @Nullable
    @ODataField( odataName = "OffsettingAccountType_ID" )
    private String offsettingAccountType_ID;
    /**
     * Use with available fluent helpers to apply the <b>OffsettingAccountType_ID</b> field to query operations.
     *
     */
    public final static OffsettingAccount_2Field<String> OFFSETTING_ACCOUNT_TYPE_ID =
        new OffsettingAccount_2Field<String>("OffsettingAccountType_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccountTypeText</b>
     * </p>
     *
     * @return Offsetting Account Type (Description)
     */
    @SerializedName( "OffsettingAccountTypeText" )
    @JsonProperty( "OffsettingAccountTypeText" )
    @Nullable
    @ODataField( odataName = "OffsettingAccountTypeText" )
    private String offsettingAccountTypeText;
    /**
     * Use with available fluent helpers to apply the <b>OffsettingAccountTypeText</b> field to query operations.
     *
     */
    public final static OffsettingAccount_2Field<String> OFFSETTING_ACCOUNT_TYPE_TEXT =
        new OffsettingAccount_2Field<String>("OffsettingAccountTypeText");

    @Nonnull
    @Override
    public Class<OffsettingAccount_2> getType()
    {
        return OffsettingAccount_2.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccountType_ID</b>
     * </p>
     *
     * @param offsettingAccountType_ID
     *            Offsetting Account Type
     */
    public void setOffsettingAccountType_ID( @Nullable final String offsettingAccountType_ID )
    {
        rememberChangedField("OffsettingAccountType_ID", this.offsettingAccountType_ID);
        this.offsettingAccountType_ID = offsettingAccountType_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccountTypeText</b>
     * </p>
     *
     * @param offsettingAccountTypeText
     *            Offsetting Account Type (Description)
     */
    public void setOffsettingAccountTypeText( @Nullable final String offsettingAccountTypeText )
    {
        rememberChangedField("OffsettingAccountTypeText", this.offsettingAccountTypeText);
        this.offsettingAccountTypeText = offsettingAccountTypeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "OffsettingAccountType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("OffsettingAccountType_ID", getOffsettingAccountType_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("OffsettingAccountType_ID", getOffsettingAccountType_ID());
        values.put("OffsettingAccountTypeText", getOffsettingAccountTypeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("OffsettingAccountType_ID") ) {
                final Object value = values.remove("OffsettingAccountType_ID");
                if( (value == null) || (!value.equals(getOffsettingAccountType_ID())) ) {
                    setOffsettingAccountType_ID(((String) value));
                }
            }
            if( values.containsKey("OffsettingAccountTypeText") ) {
                final Object value = values.remove("OffsettingAccountTypeText");
                if( (value == null) || (!value.equals(getOffsettingAccountTypeText())) ) {
                    setOffsettingAccountTypeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> OffsettingAccount_2Field<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new OffsettingAccount_2Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> OffsettingAccount_2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new OffsettingAccount_2Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
