/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.OffsettingAccount_2Selectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount_2 OffsettingAccount_2}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class OffsettingAccount_2ByKeyFluentHelper
    extends
    FluentHelperByKey<OffsettingAccount_2ByKeyFluentHelper, OffsettingAccount_2, OffsettingAccount_2Selectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount_2 OffsettingAccount_2}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code OffsettingAccount_2}
     * @param offsettingAccountType_ID
     *            Offsetting Account Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code OffsettingAccount_2}
     */
    public OffsettingAccount_2ByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String offsettingAccountType_ID )
    {
        super(servicePath, entityCollection);
        this.key.put("OffsettingAccountType_ID", offsettingAccountType_ID);
    }

    @Override
    @Nonnull
    protected Class<OffsettingAccount_2> getEntityClass()
    {
        return OffsettingAccount_2.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
