/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.OperatingConcernField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.OperatingConcernSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Operating Concern (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>OperatingConcern</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class OperatingConcern extends VdmEntity<OperatingConcern>
{

    /**
     * Selector for all available fields of OperatingConcern.
     *
     */
    public final static OperatingConcernSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperatingConcern_ID</b>
     * </p>
     *
     * @return Operating Concern
     */
    @Key
    @SerializedName( "OperatingConcern_ID" )
    @JsonProperty( "OperatingConcern_ID" )
    @Nullable
    @ODataField( odataName = "OperatingConcern_ID" )
    private String operatingConcern_ID;
    /**
     * Use with available fluent helpers to apply the <b>OperatingConcern_ID</b> field to query operations.
     *
     */
    public final static OperatingConcernField<String> OPERATING_CONCERN_ID =
        new OperatingConcernField<String>("OperatingConcern_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OperatingConcernText</b>
     * </p>
     *
     * @return Operating Concern (Description)
     */
    @SerializedName( "OperatingConcernText" )
    @JsonProperty( "OperatingConcernText" )
    @Nullable
    @ODataField( odataName = "OperatingConcernText" )
    private String operatingConcernText;
    /**
     * Use with available fluent helpers to apply the <b>OperatingConcernText</b> field to query operations.
     *
     */
    public final static OperatingConcernField<String> OPERATING_CONCERN_TEXT =
        new OperatingConcernField<String>("OperatingConcernText");

    @Nonnull
    @Override
    public Class<OperatingConcern> getType()
    {
        return OperatingConcern.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperatingConcern_ID</b>
     * </p>
     *
     * @param operatingConcern_ID
     *            Operating Concern
     */
    public void setOperatingConcern_ID( @Nullable final String operatingConcern_ID )
    {
        rememberChangedField("OperatingConcern_ID", this.operatingConcern_ID);
        this.operatingConcern_ID = operatingConcern_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OperatingConcernText</b>
     * </p>
     *
     * @param operatingConcernText
     *            Operating Concern (Description)
     */
    public void setOperatingConcernText( @Nullable final String operatingConcernText )
    {
        rememberChangedField("OperatingConcernText", this.operatingConcernText);
        this.operatingConcernText = operatingConcernText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "OperatingConcern";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("OperatingConcern_ID", getOperatingConcern_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("OperatingConcern_ID", getOperatingConcern_ID());
        values.put("OperatingConcernText", getOperatingConcernText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("OperatingConcern_ID") ) {
                final Object value = values.remove("OperatingConcern_ID");
                if( (value == null) || (!value.equals(getOperatingConcern_ID())) ) {
                    setOperatingConcern_ID(((String) value));
                }
            }
            if( values.containsKey("OperatingConcernText") ) {
                final Object value = values.remove("OperatingConcernText");
                if( (value == null) || (!value.equals(getOperatingConcernText())) ) {
                    setOperatingConcernText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> OperatingConcernField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new OperatingConcernField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> OperatingConcernField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new OperatingConcernField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
