/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.OrderCategorySelectable;

/**
 * Fluent helper to fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderCategory
 * OrderCategory} entity using key fields. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class OrderCategoryByKeyFluentHelper
    extends
    FluentHelperByKey<OrderCategoryByKeyFluentHelper, OrderCategory, OrderCategorySelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderCategory OrderCategory} entity with
     * the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method on
     * the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code OrderCategory}
     * @param servicePath
     *            Service path to be used to fetch a single {@code OrderCategory}
     * @param orderCategory_ID
     *            Order Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public OrderCategoryByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String orderCategory_ID )
    {
        super(servicePath, entityCollection);
        this.key.put("OrderCategory_ID", orderCategory_ID);
    }

    @Override
    @Nonnull
    protected Class<OrderCategory> getEntityClass()
    {
        return OrderCategory.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
