/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.OriginCostCtrActivityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.OriginCostCtrActivitySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Origin Cost Center Activity Type (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>OriginCostCtrActivityType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class OriginCostCtrActivity extends VdmEntity<OriginCostCtrActivity>
{

    /**
     * Selector for all available fields of OriginCostCtrActivity.
     *
     */
    public final static OriginCostCtrActivitySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OriginCostCtrActivityType_ID</b>
     * </p>
     *
     * @return Origin Cost Center Activity Type
     */
    @Key
    @SerializedName( "OriginCostCtrActivityType_ID" )
    @JsonProperty( "OriginCostCtrActivityType_ID" )
    @Nullable
    @ODataField( odataName = "OriginCostCtrActivityType_ID" )
    private String originCostCtrActivityType_ID;
    /**
     * Use with available fluent helpers to apply the <b>OriginCostCtrActivityType_ID</b> field to query operations.
     *
     */
    public final static OriginCostCtrActivityField<String> ORIGIN_COST_CTR_ACTIVITY_TYPE_ID =
        new OriginCostCtrActivityField<String>("OriginCostCtrActivityType_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OriginCostCtrActivityTypeText</b>
     * </p>
     *
     * @return Origin Cost Center Activity Type (Description)
     */
    @SerializedName( "OriginCostCtrActivityTypeText" )
    @JsonProperty( "OriginCostCtrActivityTypeText" )
    @Nullable
    @ODataField( odataName = "OriginCostCtrActivityTypeText" )
    private String originCostCtrActivityTypeText;
    /**
     * Use with available fluent helpers to apply the <b>OriginCostCtrActivityTypeText</b> field to query operations.
     *
     */
    public final static OriginCostCtrActivityField<String> ORIGIN_COST_CTR_ACTIVITY_TYPE_TEXT =
        new OriginCostCtrActivityField<String>("OriginCostCtrActivityTypeText");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Origin Cost Center Activity Type (Controlling Area)
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static OriginCostCtrActivityField<String> CONTROLLING_AREA =
        new OriginCostCtrActivityField<String>("ControllingArea");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaName</b>
     * </p>
     *
     * @return Controlling Area (Description) (Parent Description)
     */
    @SerializedName( "ControllingAreaName" )
    @JsonProperty( "ControllingAreaName" )
    @Nullable
    @ODataField( odataName = "ControllingAreaName" )
    private String controllingAreaName;
    /**
     * Use with available fluent helpers to apply the <b>ControllingAreaName</b> field to query operations.
     *
     */
    public final static OriginCostCtrActivityField<String> CONTROLLING_AREA_NAME =
        new OriginCostCtrActivityField<String>("ControllingAreaName");

    @Nonnull
    @Override
    public Class<OriginCostCtrActivity> getType()
    {
        return OriginCostCtrActivity.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OriginCostCtrActivityType_ID</b>
     * </p>
     *
     * @param originCostCtrActivityType_ID
     *            Origin Cost Center Activity Type
     */
    public void setOriginCostCtrActivityType_ID( @Nullable final String originCostCtrActivityType_ID )
    {
        rememberChangedField("OriginCostCtrActivityType_ID", this.originCostCtrActivityType_ID);
        this.originCostCtrActivityType_ID = originCostCtrActivityType_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OriginCostCtrActivityTypeText</b>
     * </p>
     *
     * @param originCostCtrActivityTypeText
     *            Origin Cost Center Activity Type (Description)
     */
    public void setOriginCostCtrActivityTypeText( @Nullable final String originCostCtrActivityTypeText )
    {
        rememberChangedField("OriginCostCtrActivityTypeText", this.originCostCtrActivityTypeText);
        this.originCostCtrActivityTypeText = originCostCtrActivityTypeText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Origin Cost Center Activity Type (Controlling Area)
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaName</b>
     * </p>
     *
     * @param controllingAreaName
     *            Controlling Area (Description) (Parent Description)
     */
    public void setControllingAreaName( @Nullable final String controllingAreaName )
    {
        rememberChangedField("ControllingAreaName", this.controllingAreaName);
        this.controllingAreaName = controllingAreaName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "OriginCostCtrActivityType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("OriginCostCtrActivityType_ID", getOriginCostCtrActivityType_ID());
        result.put("ControllingArea", getControllingArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("OriginCostCtrActivityType_ID", getOriginCostCtrActivityType_ID());
        values.put("OriginCostCtrActivityTypeText", getOriginCostCtrActivityTypeText());
        values.put("ControllingArea", getControllingArea());
        values.put("ControllingAreaName", getControllingAreaName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("OriginCostCtrActivityType_ID") ) {
                final Object value = values.remove("OriginCostCtrActivityType_ID");
                if( (value == null) || (!value.equals(getOriginCostCtrActivityType_ID())) ) {
                    setOriginCostCtrActivityType_ID(((String) value));
                }
            }
            if( values.containsKey("OriginCostCtrActivityTypeText") ) {
                final Object value = values.remove("OriginCostCtrActivityTypeText");
                if( (value == null) || (!value.equals(getOriginCostCtrActivityTypeText())) ) {
                    setOriginCostCtrActivityTypeText(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("ControllingAreaName") ) {
                final Object value = values.remove("ControllingAreaName");
                if( (value == null) || (!value.equals(getControllingAreaName())) ) {
                    setControllingAreaName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> OriginCostCtrActivityField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new OriginCostCtrActivityField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> OriginCostCtrActivityField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new OriginCostCtrActivityField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
