/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.OriginObjectField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.OriginObjectSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Origin Object Type (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>OriginObjectType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class OriginObject extends VdmEntity<OriginObject>
{

    /**
     * Selector for all available fields of OriginObject.
     *
     */
    public final static OriginObjectSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OriginObjectType_ID</b>
     * </p>
     *
     * @return Origin Object Type
     */
    @Key
    @SerializedName( "OriginObjectType_ID" )
    @JsonProperty( "OriginObjectType_ID" )
    @Nullable
    @ODataField( odataName = "OriginObjectType_ID" )
    private String originObjectType_ID;
    /**
     * Use with available fluent helpers to apply the <b>OriginObjectType_ID</b> field to query operations.
     *
     */
    public final static OriginObjectField<String> ORIGIN_OBJECT_TYPE_ID =
        new OriginObjectField<String>("OriginObjectType_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OriginObjectTypeText</b>
     * </p>
     *
     * @return Origin Object Type (Description)
     */
    @SerializedName( "OriginObjectTypeText" )
    @JsonProperty( "OriginObjectTypeText" )
    @Nullable
    @ODataField( odataName = "OriginObjectTypeText" )
    private String originObjectTypeText;
    /**
     * Use with available fluent helpers to apply the <b>OriginObjectTypeText</b> field to query operations.
     *
     */
    public final static OriginObjectField<String> ORIGIN_OBJECT_TYPE_TEXT =
        new OriginObjectField<String>("OriginObjectTypeText");

    @Nonnull
    @Override
    public Class<OriginObject> getType()
    {
        return OriginObject.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OriginObjectType_ID</b>
     * </p>
     *
     * @param originObjectType_ID
     *            Origin Object Type
     */
    public void setOriginObjectType_ID( @Nullable final String originObjectType_ID )
    {
        rememberChangedField("OriginObjectType_ID", this.originObjectType_ID);
        this.originObjectType_ID = originObjectType_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OriginObjectTypeText</b>
     * </p>
     *
     * @param originObjectTypeText
     *            Origin Object Type (Description)
     */
    public void setOriginObjectTypeText( @Nullable final String originObjectTypeText )
    {
        rememberChangedField("OriginObjectTypeText", this.originObjectTypeText);
        this.originObjectTypeText = originObjectTypeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "OriginObjectType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("OriginObjectType_ID", getOriginObjectType_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("OriginObjectType_ID", getOriginObjectType_ID());
        values.put("OriginObjectTypeText", getOriginObjectTypeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("OriginObjectType_ID") ) {
                final Object value = values.remove("OriginObjectType_ID");
                if( (value == null) || (!value.equals(getOriginObjectType_ID())) ) {
                    setOriginObjectType_ID(((String) value));
                }
            }
            if( values.containsKey("OriginObjectTypeText") ) {
                final Object value = values.remove("OriginObjectTypeText");
                if( (value == null) || (!value.equals(getOriginObjectTypeText())) ) {
                    setOriginObjectTypeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> OriginObjectField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new OriginObjectField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> OriginObjectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new OriginObjectField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
