/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerBudgetPeriodField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerBudgetPeriodSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Partner Budget Period
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerBudgetPeriod</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerBudgetPeriod extends VdmEntity<PartnerBudgetPeriod>
{

    /**
     * Selector for all available fields of PartnerBudgetPeriod.
     *
     */
    public final static PartnerBudgetPeriodSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBudgetPeriod</b>
     * </p>
     *
     * @return Partner Budget Period
     */
    @Key
    @SerializedName( "PartnerBudgetPeriod" )
    @JsonProperty( "PartnerBudgetPeriod" )
    @Nullable
    @ODataField( odataName = "PartnerBudgetPeriod" )
    private String partnerBudgetPeriod;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBudgetPeriod</b> field to query operations.
     *
     */
    public final static PartnerBudgetPeriodField<String> PARTNER_BUDGET_PERIOD =
        new PartnerBudgetPeriodField<String>("PartnerBudgetPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBudgetPeriodText</b>
     * </p>
     *
     * @return Partner Budget Period (Description)
     */
    @SerializedName( "PartnerBudgetPeriodText" )
    @JsonProperty( "PartnerBudgetPeriodText" )
    @Nullable
    @ODataField( odataName = "PartnerBudgetPeriodText" )
    private String partnerBudgetPeriodText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBudgetPeriodText</b> field to query operations.
     *
     */
    public final static PartnerBudgetPeriodField<String> PARTNER_BUDGET_PERIOD_TEXT =
        new PartnerBudgetPeriodField<String>("PartnerBudgetPeriodText");

    @Nonnull
    @Override
    public Class<PartnerBudgetPeriod> getType()
    {
        return PartnerBudgetPeriod.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBudgetPeriod</b>
     * </p>
     *
     * @param partnerBudgetPeriod
     *            Partner Budget Period
     */
    public void setPartnerBudgetPeriod( @Nullable final String partnerBudgetPeriod )
    {
        rememberChangedField("PartnerBudgetPeriod", this.partnerBudgetPeriod);
        this.partnerBudgetPeriod = partnerBudgetPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBudgetPeriodText</b>
     * </p>
     *
     * @param partnerBudgetPeriodText
     *            Partner Budget Period (Description)
     */
    public void setPartnerBudgetPeriodText( @Nullable final String partnerBudgetPeriodText )
    {
        rememberChangedField("PartnerBudgetPeriodText", this.partnerBudgetPeriodText);
        this.partnerBudgetPeriodText = partnerBudgetPeriodText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerBudgetPeriod";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PartnerBudgetPeriod", getPartnerBudgetPeriod());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PartnerBudgetPeriod", getPartnerBudgetPeriod());
        values.put("PartnerBudgetPeriodText", getPartnerBudgetPeriodText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PartnerBudgetPeriod") ) {
                final Object value = values.remove("PartnerBudgetPeriod");
                if( (value == null) || (!value.equals(getPartnerBudgetPeriod())) ) {
                    setPartnerBudgetPeriod(((String) value));
                }
            }
            if( values.containsKey("PartnerBudgetPeriodText") ) {
                final Object value = values.remove("PartnerBudgetPeriodText");
                if( (value == null) || (!value.equals(getPartnerBudgetPeriodText())) ) {
                    setPartnerBudgetPeriodText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerBudgetPeriodField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerBudgetPeriodField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerBudgetPeriodField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerBudgetPeriodField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
