/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerBusinessAreaField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerBusinessAreaSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Partner Bus. Area (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerBusinessArea</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerBusinessArea extends VdmEntity<PartnerBusinessArea>
{

    /**
     * Selector for all available fields of PartnerBusinessArea.
     *
     */
    public final static PartnerBusinessAreaSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea_ID</b>
     * </p>
     *
     * @return Partner Bus. Area
     */
    @Key
    @SerializedName( "PartnerBusinessArea_ID" )
    @JsonProperty( "PartnerBusinessArea_ID" )
    @Nullable
    @ODataField( odataName = "PartnerBusinessArea_ID" )
    private String partnerBusinessArea_ID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBusinessArea_ID</b> field to query operations.
     *
     */
    public final static PartnerBusinessAreaField<String> PARTNER_BUSINESS_AREA_ID =
        new PartnerBusinessAreaField<String>("PartnerBusinessArea_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessAreaText</b>
     * </p>
     *
     * @return Partner Bus. Area (Description)
     */
    @SerializedName( "PartnerBusinessAreaText" )
    @JsonProperty( "PartnerBusinessAreaText" )
    @Nullable
    @ODataField( odataName = "PartnerBusinessAreaText" )
    private String partnerBusinessAreaText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBusinessAreaText</b> field to query operations.
     *
     */
    public final static PartnerBusinessAreaField<String> PARTNER_BUSINESS_AREA_TEXT =
        new PartnerBusinessAreaField<String>("PartnerBusinessAreaText");

    @Nonnull
    @Override
    public Class<PartnerBusinessArea> getType()
    {
        return PartnerBusinessArea.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea_ID</b>
     * </p>
     *
     * @param partnerBusinessArea_ID
     *            Partner Bus. Area
     */
    public void setPartnerBusinessArea_ID( @Nullable final String partnerBusinessArea_ID )
    {
        rememberChangedField("PartnerBusinessArea_ID", this.partnerBusinessArea_ID);
        this.partnerBusinessArea_ID = partnerBusinessArea_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessAreaText</b>
     * </p>
     *
     * @param partnerBusinessAreaText
     *            Partner Bus. Area (Description)
     */
    public void setPartnerBusinessAreaText( @Nullable final String partnerBusinessAreaText )
    {
        rememberChangedField("PartnerBusinessAreaText", this.partnerBusinessAreaText);
        this.partnerBusinessAreaText = partnerBusinessAreaText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerBusinessArea";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PartnerBusinessArea_ID", getPartnerBusinessArea_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PartnerBusinessArea_ID", getPartnerBusinessArea_ID());
        values.put("PartnerBusinessAreaText", getPartnerBusinessAreaText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PartnerBusinessArea_ID") ) {
                final Object value = values.remove("PartnerBusinessArea_ID");
                if( (value == null) || (!value.equals(getPartnerBusinessArea_ID())) ) {
                    setPartnerBusinessArea_ID(((String) value));
                }
            }
            if( values.containsKey("PartnerBusinessAreaText") ) {
                final Object value = values.remove("PartnerBusinessAreaText");
                if( (value == null) || (!value.equals(getPartnerBusinessAreaText())) ) {
                    setPartnerBusinessAreaText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerBusinessAreaField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerBusinessAreaField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerBusinessAreaField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerBusinessAreaField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
