/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerBusinessProcessSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessProcess
 * PartnerBusinessProcess} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class PartnerBusinessProcessByKeyFluentHelper
    extends
    FluentHelperByKey<PartnerBusinessProcessByKeyFluentHelper, PartnerBusinessProcess, PartnerBusinessProcessSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessProcess
     * PartnerBusinessProcess} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PartnerBusinessProcess}
     * @param partnerBusinessProcess
     *            Partner Business Process
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PartnerBusinessProcess}
     */
    public PartnerBusinessProcessByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String partnerBusinessProcess )
    {
        super(servicePath, entityCollection);
        this.key.put("PartnerBusinessProcess", partnerBusinessProcess);
    }

    @Override
    @Nonnull
    protected Class<PartnerBusinessProcess> getEntityClass()
    {
        return PartnerBusinessProcess.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
