/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerCompanyCodeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerCompanyCodeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Partner Company Code (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerCompanyCode</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerCompanyCode extends VdmEntity<PartnerCompanyCode>
{

    /**
     * Selector for all available fields of PartnerCompanyCode.
     *
     */
    public final static PartnerCompanyCodeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompanyCode_ID</b>
     * </p>
     *
     * @return Partner Company Code
     */
    @Key
    @SerializedName( "PartnerCompanyCode_ID" )
    @JsonProperty( "PartnerCompanyCode_ID" )
    @Nullable
    @ODataField( odataName = "PartnerCompanyCode_ID" )
    private String partnerCompanyCode_ID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCompanyCode_ID</b> field to query operations.
     *
     */
    public final static PartnerCompanyCodeField<String> PARTNER_COMPANY_CODE_ID =
        new PartnerCompanyCodeField<String>("PartnerCompanyCode_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompanyCodeText</b>
     * </p>
     *
     * @return Partner Company Code (Description)
     */
    @SerializedName( "PartnerCompanyCodeText" )
    @JsonProperty( "PartnerCompanyCodeText" )
    @Nullable
    @ODataField( odataName = "PartnerCompanyCodeText" )
    private String partnerCompanyCodeText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCompanyCodeText</b> field to query operations.
     *
     */
    public final static PartnerCompanyCodeField<String> PARTNER_COMPANY_CODE_TEXT =
        new PartnerCompanyCodeField<String>("PartnerCompanyCodeText");

    @Nonnull
    @Override
    public Class<PartnerCompanyCode> getType()
    {
        return PartnerCompanyCode.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompanyCode_ID</b>
     * </p>
     *
     * @param partnerCompanyCode_ID
     *            Partner Company Code
     */
    public void setPartnerCompanyCode_ID( @Nullable final String partnerCompanyCode_ID )
    {
        rememberChangedField("PartnerCompanyCode_ID", this.partnerCompanyCode_ID);
        this.partnerCompanyCode_ID = partnerCompanyCode_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompanyCodeText</b>
     * </p>
     *
     * @param partnerCompanyCodeText
     *            Partner Company Code (Description)
     */
    public void setPartnerCompanyCodeText( @Nullable final String partnerCompanyCodeText )
    {
        rememberChangedField("PartnerCompanyCodeText", this.partnerCompanyCodeText);
        this.partnerCompanyCodeText = partnerCompanyCodeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerCompanyCode";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PartnerCompanyCode_ID", getPartnerCompanyCode_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PartnerCompanyCode_ID", getPartnerCompanyCode_ID());
        values.put("PartnerCompanyCodeText", getPartnerCompanyCodeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PartnerCompanyCode_ID") ) {
                final Object value = values.remove("PartnerCompanyCode_ID");
                if( (value == null) || (!value.equals(getPartnerCompanyCode_ID())) ) {
                    setPartnerCompanyCode_ID(((String) value));
                }
            }
            if( values.containsKey("PartnerCompanyCodeText") ) {
                final Object value = values.remove("PartnerCompanyCodeText");
                if( (value == null) || (!value.equals(getPartnerCompanyCodeText())) ) {
                    setPartnerCompanyCodeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerCompanyCodeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerCompanyCodeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerCompanyCodeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerCompanyCodeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
