/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerControllingObjectClassField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerControllingObjectClassSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Partner Controlling Object Class (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerControllingObjectClass</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerControllingObjectClass extends VdmEntity<PartnerControllingObjectClass>
{

    /**
     * Selector for all available fields of PartnerControllingObjectClass.
     *
     */
    public final static PartnerControllingObjectClassSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerControllingObjectClass_ID</b>
     * </p>
     *
     * @return Partner Controlling Object Class
     */
    @Key
    @SerializedName( "PartnerControllingObjectClass_ID" )
    @JsonProperty( "PartnerControllingObjectClass_ID" )
    @Nullable
    @ODataField( odataName = "PartnerControllingObjectClass_ID" )
    private String partnerControllingObjectClass_ID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerControllingObjectClass_ID</b> field to query operations.
     *
     */
    public final static PartnerControllingObjectClassField<String> PARTNER_CONTROLLING_OBJECT_CLASS_ID =
        new PartnerControllingObjectClassField<String>("PartnerControllingObjectClass_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerControllingObjectClassText</b>
     * </p>
     *
     * @return Partner Controlling Object Class (Description)
     */
    @SerializedName( "PartnerControllingObjectClassText" )
    @JsonProperty( "PartnerControllingObjectClassText" )
    @Nullable
    @ODataField( odataName = "PartnerControllingObjectClassText" )
    private String partnerControllingObjectClassText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerControllingObjectClassText</b> field to query
     * operations.
     *
     */
    public final static PartnerControllingObjectClassField<String> PARTNER_CONTROLLING_OBJECT_CLASS_TEXT =
        new PartnerControllingObjectClassField<String>("PartnerControllingObjectClassText");

    @Nonnull
    @Override
    public Class<PartnerControllingObjectClass> getType()
    {
        return PartnerControllingObjectClass.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerControllingObjectClass_ID</b>
     * </p>
     *
     * @param partnerControllingObjectClass_ID
     *            Partner Controlling Object Class
     */
    public void setPartnerControllingObjectClass_ID( @Nullable final String partnerControllingObjectClass_ID )
    {
        rememberChangedField("PartnerControllingObjectClass_ID", this.partnerControllingObjectClass_ID);
        this.partnerControllingObjectClass_ID = partnerControllingObjectClass_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerControllingObjectClassText</b>
     * </p>
     *
     * @param partnerControllingObjectClassText
     *            Partner Controlling Object Class (Description)
     */
    public void setPartnerControllingObjectClassText( @Nullable final String partnerControllingObjectClassText )
    {
        rememberChangedField("PartnerControllingObjectClassText", this.partnerControllingObjectClassText);
        this.partnerControllingObjectClassText = partnerControllingObjectClassText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerControllingObjectClass";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PartnerControllingObjectClass_ID", getPartnerControllingObjectClass_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PartnerControllingObjectClass_ID", getPartnerControllingObjectClass_ID());
        values.put("PartnerControllingObjectClassText", getPartnerControllingObjectClassText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PartnerControllingObjectClass_ID") ) {
                final Object value = values.remove("PartnerControllingObjectClass_ID");
                if( (value == null) || (!value.equals(getPartnerControllingObjectClass_ID())) ) {
                    setPartnerControllingObjectClass_ID(((String) value));
                }
            }
            if( values.containsKey("PartnerControllingObjectClassText") ) {
                final Object value = values.remove("PartnerControllingObjectClassText");
                if( (value == null) || (!value.equals(getPartnerControllingObjectClassText())) ) {
                    setPartnerControllingObjectClassText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PartnerControllingObjectClassField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new PartnerControllingObjectClassField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerControllingObjectClassField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerControllingObjectClassField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
