/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerCostCenterField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerCostCenterSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Partner Cost Center (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerCostCenter</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerCostCenter extends VdmEntity<PartnerCostCenter>
{

    /**
     * Selector for all available fields of PartnerCostCenter.
     *
     */
    public final static PartnerCostCenterSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenter_ID</b>
     * </p>
     *
     * @return Partner Cost Center
     */
    @Key
    @SerializedName( "PartnerCostCenter_ID" )
    @JsonProperty( "PartnerCostCenter_ID" )
    @Nullable
    @ODataField( odataName = "PartnerCostCenter_ID" )
    private String partnerCostCenter_ID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCostCenter_ID</b> field to query operations.
     *
     */
    public final static PartnerCostCenterField<String> PARTNER_COST_CENTER_ID =
        new PartnerCostCenterField<String>("PartnerCostCenter_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenterText</b>
     * </p>
     *
     * @return Partner Cost Center (Description)
     */
    @SerializedName( "PartnerCostCenterText" )
    @JsonProperty( "PartnerCostCenterText" )
    @Nullable
    @ODataField( odataName = "PartnerCostCenterText" )
    private String partnerCostCenterText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCostCenterText</b> field to query operations.
     *
     */
    public final static PartnerCostCenterField<String> PARTNER_COST_CENTER_TEXT =
        new PartnerCostCenterField<String>("PartnerCostCenterText");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Partner Cost Center (Controlling Area)
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static PartnerCostCenterField<String> CONTROLLING_AREA =
        new PartnerCostCenterField<String>("ControllingArea");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaName</b>
     * </p>
     *
     * @return Controlling Area (Description) (Parent Description)
     */
    @SerializedName( "ControllingAreaName" )
    @JsonProperty( "ControllingAreaName" )
    @Nullable
    @ODataField( odataName = "ControllingAreaName" )
    private String controllingAreaName;
    /**
     * Use with available fluent helpers to apply the <b>ControllingAreaName</b> field to query operations.
     *
     */
    public final static PartnerCostCenterField<String> CONTROLLING_AREA_NAME =
        new PartnerCostCenterField<String>("ControllingAreaName");

    @Nonnull
    @Override
    public Class<PartnerCostCenter> getType()
    {
        return PartnerCostCenter.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenter_ID</b>
     * </p>
     *
     * @param partnerCostCenter_ID
     *            Partner Cost Center
     */
    public void setPartnerCostCenter_ID( @Nullable final String partnerCostCenter_ID )
    {
        rememberChangedField("PartnerCostCenter_ID", this.partnerCostCenter_ID);
        this.partnerCostCenter_ID = partnerCostCenter_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenterText</b>
     * </p>
     *
     * @param partnerCostCenterText
     *            Partner Cost Center (Description)
     */
    public void setPartnerCostCenterText( @Nullable final String partnerCostCenterText )
    {
        rememberChangedField("PartnerCostCenterText", this.partnerCostCenterText);
        this.partnerCostCenterText = partnerCostCenterText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Partner Cost Center (Controlling Area)
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaName</b>
     * </p>
     *
     * @param controllingAreaName
     *            Controlling Area (Description) (Parent Description)
     */
    public void setControllingAreaName( @Nullable final String controllingAreaName )
    {
        rememberChangedField("ControllingAreaName", this.controllingAreaName);
        this.controllingAreaName = controllingAreaName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerCostCenter";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PartnerCostCenter_ID", getPartnerCostCenter_ID());
        result.put("ControllingArea", getControllingArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PartnerCostCenter_ID", getPartnerCostCenter_ID());
        values.put("PartnerCostCenterText", getPartnerCostCenterText());
        values.put("ControllingArea", getControllingArea());
        values.put("ControllingAreaName", getControllingAreaName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PartnerCostCenter_ID") ) {
                final Object value = values.remove("PartnerCostCenter_ID");
                if( (value == null) || (!value.equals(getPartnerCostCenter_ID())) ) {
                    setPartnerCostCenter_ID(((String) value));
                }
            }
            if( values.containsKey("PartnerCostCenterText") ) {
                final Object value = values.remove("PartnerCostCenterText");
                if( (value == null) || (!value.equals(getPartnerCostCenterText())) ) {
                    setPartnerCostCenterText(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("ControllingAreaName") ) {
                final Object value = values.remove("ControllingAreaName");
                if( (value == null) || (!value.equals(getControllingAreaName())) ) {
                    setControllingAreaName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerCostCenterField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerCostCenterField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerCostCenterField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerCostCenterField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
