/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerFunctionalAreaField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerFunctionalAreaSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Partner Func. Area (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerFunctionalArea</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerFunctionalArea extends VdmEntity<PartnerFunctionalArea>
{

    /**
     * Selector for all available fields of PartnerFunctionalArea.
     *
     */
    public final static PartnerFunctionalAreaSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalArea_ID</b>
     * </p>
     *
     * @return Partner Func. Area
     */
    @Key
    @SerializedName( "PartnerFunctionalArea_ID" )
    @JsonProperty( "PartnerFunctionalArea_ID" )
    @Nullable
    @ODataField( odataName = "PartnerFunctionalArea_ID" )
    private String partnerFunctionalArea_ID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunctionalArea_ID</b> field to query operations.
     *
     */
    public final static PartnerFunctionalAreaField<String> PARTNER_FUNCTIONAL_AREA_ID =
        new PartnerFunctionalAreaField<String>("PartnerFunctionalArea_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalAreaText</b>
     * </p>
     *
     * @return Partner Func. Area (Description)
     */
    @SerializedName( "PartnerFunctionalAreaText" )
    @JsonProperty( "PartnerFunctionalAreaText" )
    @Nullable
    @ODataField( odataName = "PartnerFunctionalAreaText" )
    private String partnerFunctionalAreaText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunctionalAreaText</b> field to query operations.
     *
     */
    public final static PartnerFunctionalAreaField<String> PARTNER_FUNCTIONAL_AREA_TEXT =
        new PartnerFunctionalAreaField<String>("PartnerFunctionalAreaText");

    @Nonnull
    @Override
    public Class<PartnerFunctionalArea> getType()
    {
        return PartnerFunctionalArea.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalArea_ID</b>
     * </p>
     *
     * @param partnerFunctionalArea_ID
     *            Partner Func. Area
     */
    public void setPartnerFunctionalArea_ID( @Nullable final String partnerFunctionalArea_ID )
    {
        rememberChangedField("PartnerFunctionalArea_ID", this.partnerFunctionalArea_ID);
        this.partnerFunctionalArea_ID = partnerFunctionalArea_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalAreaText</b>
     * </p>
     *
     * @param partnerFunctionalAreaText
     *            Partner Func. Area (Description)
     */
    public void setPartnerFunctionalAreaText( @Nullable final String partnerFunctionalAreaText )
    {
        rememberChangedField("PartnerFunctionalAreaText", this.partnerFunctionalAreaText);
        this.partnerFunctionalAreaText = partnerFunctionalAreaText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerFunctionalArea";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PartnerFunctionalArea_ID", getPartnerFunctionalArea_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PartnerFunctionalArea_ID", getPartnerFunctionalArea_ID());
        values.put("PartnerFunctionalAreaText", getPartnerFunctionalAreaText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PartnerFunctionalArea_ID") ) {
                final Object value = values.remove("PartnerFunctionalArea_ID");
                if( (value == null) || (!value.equals(getPartnerFunctionalArea_ID())) ) {
                    setPartnerFunctionalArea_ID(((String) value));
                }
            }
            if( values.containsKey("PartnerFunctionalAreaText") ) {
                final Object value = values.remove("PartnerFunctionalAreaText");
                if( (value == null) || (!value.equals(getPartnerFunctionalAreaText())) ) {
                    setPartnerFunctionalAreaText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerFunctionalAreaField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerFunctionalAreaField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerFunctionalAreaField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerFunctionalAreaField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
