/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerFundField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerFundSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Partner Fund
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerFund</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerFund extends VdmEntity<PartnerFund>
{

    /**
     * Selector for all available fields of PartnerFund.
     *
     */
    public final static PartnerFundSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFund</b>
     * </p>
     *
     * @return Partner Fund
     */
    @Key
    @SerializedName( "PartnerFund" )
    @JsonProperty( "PartnerFund" )
    @Nullable
    @ODataField( odataName = "PartnerFund" )
    private String partnerFund;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFund</b> field to query operations.
     *
     */
    public final static PartnerFundField<String> PARTNER_FUND = new PartnerFundField<String>("PartnerFund");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFundText</b>
     * </p>
     *
     * @return Partner Fund (Description)
     */
    @SerializedName( "PartnerFundText" )
    @JsonProperty( "PartnerFundText" )
    @Nullable
    @ODataField( odataName = "PartnerFundText" )
    private String partnerFundText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFundText</b> field to query operations.
     *
     */
    public final static PartnerFundField<String> PARTNER_FUND_TEXT = new PartnerFundField<String>("PartnerFundText");

    @Nonnull
    @Override
    public Class<PartnerFund> getType()
    {
        return PartnerFund.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFund</b>
     * </p>
     *
     * @param partnerFund
     *            Partner Fund
     */
    public void setPartnerFund( @Nullable final String partnerFund )
    {
        rememberChangedField("PartnerFund", this.partnerFund);
        this.partnerFund = partnerFund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFundText</b>
     * </p>
     *
     * @param partnerFundText
     *            Partner Fund (Description)
     */
    public void setPartnerFundText( @Nullable final String partnerFundText )
    {
        rememberChangedField("PartnerFundText", this.partnerFundText);
        this.partnerFundText = partnerFundText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerFund";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PartnerFund", getPartnerFund());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PartnerFund", getPartnerFund());
        values.put("PartnerFundText", getPartnerFundText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PartnerFund") ) {
                final Object value = values.remove("PartnerFund");
                if( (value == null) || (!value.equals(getPartnerFund())) ) {
                    setPartnerFund(((String) value));
                }
            }
            if( values.containsKey("PartnerFundText") ) {
                final Object value = values.remove("PartnerFundText");
                if( (value == null) || (!value.equals(getPartnerFundText())) ) {
                    setPartnerFundText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PartnerFundField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerFundField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerFundField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerFundField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
