/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerFundSelectable;

/**
 * Fluent helper to fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFund
 * PartnerFund} entity using key fields. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class PartnerFundByKeyFluentHelper
    extends
    FluentHelperByKey<PartnerFundByKeyFluentHelper, PartnerFund, PartnerFundSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFund PartnerFund} entity with the
     * provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PartnerFund}
     * @param servicePath
     *            Service path to be used to fetch a single {@code PartnerFund}
     * @param partnerFund
     *            Partner Fund
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public PartnerFundByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String partnerFund )
    {
        super(servicePath, entityCollection);
        this.key.put("PartnerFund", partnerFund);
    }

    @Override
    @Nonnull
    protected Class<PartnerFund> getEntityClass()
    {
        return PartnerFund.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
