/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerGrantField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerGrantSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Partner Grant
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerGrant</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerGrant extends VdmEntity<PartnerGrant>
{

    /**
     * Selector for all available fields of PartnerGrant.
     *
     */
    public final static PartnerGrantSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PartnerGrant</b>
     * </p>
     *
     * @return Partner Grant
     */
    @Key
    @SerializedName( "PartnerGrant" )
    @JsonProperty( "PartnerGrant" )
    @Nullable
    @ODataField( odataName = "PartnerGrant" )
    private String partnerGrant;
    /**
     * Use with available fluent helpers to apply the <b>PartnerGrant</b> field to query operations.
     *
     */
    public final static PartnerGrantField<String> PARTNER_GRANT = new PartnerGrantField<String>("PartnerGrant");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PartnerGrantText</b>
     * </p>
     *
     * @return Partner Grant (Description)
     */
    @SerializedName( "PartnerGrantText" )
    @JsonProperty( "PartnerGrantText" )
    @Nullable
    @ODataField( odataName = "PartnerGrantText" )
    private String partnerGrantText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerGrantText</b> field to query operations.
     *
     */
    public final static PartnerGrantField<String> PARTNER_GRANT_TEXT =
        new PartnerGrantField<String>("PartnerGrantText");

    @Nonnull
    @Override
    public Class<PartnerGrant> getType()
    {
        return PartnerGrant.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PartnerGrant</b>
     * </p>
     *
     * @param partnerGrant
     *            Partner Grant
     */
    public void setPartnerGrant( @Nullable final String partnerGrant )
    {
        rememberChangedField("PartnerGrant", this.partnerGrant);
        this.partnerGrant = partnerGrant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PartnerGrantText</b>
     * </p>
     *
     * @param partnerGrantText
     *            Partner Grant (Description)
     */
    public void setPartnerGrantText( @Nullable final String partnerGrantText )
    {
        rememberChangedField("PartnerGrantText", this.partnerGrantText);
        this.partnerGrantText = partnerGrantText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerGrant";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PartnerGrant", getPartnerGrant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PartnerGrant", getPartnerGrant());
        values.put("PartnerGrantText", getPartnerGrantText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PartnerGrant") ) {
                final Object value = values.remove("PartnerGrant");
                if( (value == null) || (!value.equals(getPartnerGrant())) ) {
                    setPartnerGrant(((String) value));
                }
            }
            if( values.containsKey("PartnerGrantText") ) {
                final Object value = values.remove("PartnerGrantText");
                if( (value == null) || (!value.equals(getPartnerGrantText())) ) {
                    setPartnerGrantText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PartnerGrantField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerGrantField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerGrantField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerGrantField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
