/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerOrderCategoryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerOrderCategorySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Partner Order Cat. (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerOrderCategory</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerOrderCategory extends VdmEntity<PartnerOrderCategory>
{

    /**
     * Selector for all available fields of PartnerOrderCategory.
     *
     */
    public final static PartnerOrderCategorySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrderCategory_ID</b>
     * </p>
     *
     * @return Partner Order Cat.
     */
    @Key
    @SerializedName( "PartnerOrderCategory_ID" )
    @JsonProperty( "PartnerOrderCategory_ID" )
    @Nullable
    @ODataField( odataName = "PartnerOrderCategory_ID" )
    private String partnerOrderCategory_ID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerOrderCategory_ID</b> field to query operations.
     *
     */
    public final static PartnerOrderCategoryField<String> PARTNER_ORDER_CATEGORY_ID =
        new PartnerOrderCategoryField<String>("PartnerOrderCategory_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrderCategoryText</b>
     * </p>
     *
     * @return Partner Order Cat. (Description)
     */
    @SerializedName( "PartnerOrderCategoryText" )
    @JsonProperty( "PartnerOrderCategoryText" )
    @Nullable
    @ODataField( odataName = "PartnerOrderCategoryText" )
    private String partnerOrderCategoryText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerOrderCategoryText</b> field to query operations.
     *
     */
    public final static PartnerOrderCategoryField<String> PARTNER_ORDER_CATEGORY_TEXT =
        new PartnerOrderCategoryField<String>("PartnerOrderCategoryText");

    @Nonnull
    @Override
    public Class<PartnerOrderCategory> getType()
    {
        return PartnerOrderCategory.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrderCategory_ID</b>
     * </p>
     *
     * @param partnerOrderCategory_ID
     *            Partner Order Cat.
     */
    public void setPartnerOrderCategory_ID( @Nullable final String partnerOrderCategory_ID )
    {
        rememberChangedField("PartnerOrderCategory_ID", this.partnerOrderCategory_ID);
        this.partnerOrderCategory_ID = partnerOrderCategory_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrderCategoryText</b>
     * </p>
     *
     * @param partnerOrderCategoryText
     *            Partner Order Cat. (Description)
     */
    public void setPartnerOrderCategoryText( @Nullable final String partnerOrderCategoryText )
    {
        rememberChangedField("PartnerOrderCategoryText", this.partnerOrderCategoryText);
        this.partnerOrderCategoryText = partnerOrderCategoryText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerOrderCategory";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PartnerOrderCategory_ID", getPartnerOrderCategory_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PartnerOrderCategory_ID", getPartnerOrderCategory_ID());
        values.put("PartnerOrderCategoryText", getPartnerOrderCategoryText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PartnerOrderCategory_ID") ) {
                final Object value = values.remove("PartnerOrderCategory_ID");
                if( (value == null) || (!value.equals(getPartnerOrderCategory_ID())) ) {
                    setPartnerOrderCategory_ID(((String) value));
                }
            }
            if( values.containsKey("PartnerOrderCategoryText") ) {
                final Object value = values.remove("PartnerOrderCategoryText");
                if( (value == null) || (!value.equals(getPartnerOrderCategoryText())) ) {
                    setPartnerOrderCategoryText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerOrderCategoryField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerOrderCategoryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerOrderCategoryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerOrderCategoryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
