/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerProfitCenterField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerProfitCenterSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Partner Profit Center (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerProfitCenter</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerProfitCenter extends VdmEntity<PartnerProfitCenter>
{

    /**
     * Selector for all available fields of PartnerProfitCenter.
     *
     */
    public final static PartnerProfitCenterSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenter_ID</b>
     * </p>
     *
     * @return Partner Profit Center
     */
    @Key
    @SerializedName( "PartnerProfitCenter_ID" )
    @JsonProperty( "PartnerProfitCenter_ID" )
    @Nullable
    @ODataField( odataName = "PartnerProfitCenter_ID" )
    private String partnerProfitCenter_ID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProfitCenter_ID</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterField<String> PARTNER_PROFIT_CENTER_ID =
        new PartnerProfitCenterField<String>("PartnerProfitCenter_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenterText</b>
     * </p>
     *
     * @return Partner Profit Center (Description)
     */
    @SerializedName( "PartnerProfitCenterText" )
    @JsonProperty( "PartnerProfitCenterText" )
    @Nullable
    @ODataField( odataName = "PartnerProfitCenterText" )
    private String partnerProfitCenterText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProfitCenterText</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterField<String> PARTNER_PROFIT_CENTER_TEXT =
        new PartnerProfitCenterField<String>("PartnerProfitCenterText");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Partner Profit Center (Controlling Area)
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterField<String> CONTROLLING_AREA =
        new PartnerProfitCenterField<String>("ControllingArea");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaName</b>
     * </p>
     *
     * @return Controlling Area (Description) (Parent Description)
     */
    @SerializedName( "ControllingAreaName" )
    @JsonProperty( "ControllingAreaName" )
    @Nullable
    @ODataField( odataName = "ControllingAreaName" )
    private String controllingAreaName;
    /**
     * Use with available fluent helpers to apply the <b>ControllingAreaName</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterField<String> CONTROLLING_AREA_NAME =
        new PartnerProfitCenterField<String>("ControllingAreaName");

    @Nonnull
    @Override
    public Class<PartnerProfitCenter> getType()
    {
        return PartnerProfitCenter.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenter_ID</b>
     * </p>
     *
     * @param partnerProfitCenter_ID
     *            Partner Profit Center
     */
    public void setPartnerProfitCenter_ID( @Nullable final String partnerProfitCenter_ID )
    {
        rememberChangedField("PartnerProfitCenter_ID", this.partnerProfitCenter_ID);
        this.partnerProfitCenter_ID = partnerProfitCenter_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenterText</b>
     * </p>
     *
     * @param partnerProfitCenterText
     *            Partner Profit Center (Description)
     */
    public void setPartnerProfitCenterText( @Nullable final String partnerProfitCenterText )
    {
        rememberChangedField("PartnerProfitCenterText", this.partnerProfitCenterText);
        this.partnerProfitCenterText = partnerProfitCenterText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Partner Profit Center (Controlling Area)
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaName</b>
     * </p>
     *
     * @param controllingAreaName
     *            Controlling Area (Description) (Parent Description)
     */
    public void setControllingAreaName( @Nullable final String controllingAreaName )
    {
        rememberChangedField("ControllingAreaName", this.controllingAreaName);
        this.controllingAreaName = controllingAreaName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerProfitCenter";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PartnerProfitCenter_ID", getPartnerProfitCenter_ID());
        result.put("ControllingArea", getControllingArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PartnerProfitCenter_ID", getPartnerProfitCenter_ID());
        values.put("PartnerProfitCenterText", getPartnerProfitCenterText());
        values.put("ControllingArea", getControllingArea());
        values.put("ControllingAreaName", getControllingAreaName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PartnerProfitCenter_ID") ) {
                final Object value = values.remove("PartnerProfitCenter_ID");
                if( (value == null) || (!value.equals(getPartnerProfitCenter_ID())) ) {
                    setPartnerProfitCenter_ID(((String) value));
                }
            }
            if( values.containsKey("PartnerProfitCenterText") ) {
                final Object value = values.remove("PartnerProfitCenterText");
                if( (value == null) || (!value.equals(getPartnerProfitCenterText())) ) {
                    setPartnerProfitCenterText(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("ControllingAreaName") ) {
                final Object value = values.remove("ControllingAreaName");
                if( (value == null) || (!value.equals(getControllingAreaName())) ) {
                    setControllingAreaName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerProfitCenterField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerProfitCenterField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerProfitCenterField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerProfitCenterField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
