/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerProjectField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerProjectSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Partner Project
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerProject</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerProject extends VdmEntity<PartnerProject>
{

    /**
     * Selector for all available fields of PartnerProject.
     *
     */
    public final static PartnerProjectSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProject</b>
     * </p>
     *
     * @return Partner Project
     */
    @Key
    @SerializedName( "PartnerProject" )
    @JsonProperty( "PartnerProject" )
    @Nullable
    @ODataField( odataName = "PartnerProject" )
    private String partnerProject;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProject</b> field to query operations.
     *
     */
    public final static PartnerProjectField<String> PARTNER_PROJECT = new PartnerProjectField<String>("PartnerProject");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectText</b>
     * </p>
     *
     * @return Partner Project (Description)
     */
    @SerializedName( "PartnerProjectText" )
    @JsonProperty( "PartnerProjectText" )
    @Nullable
    @ODataField( odataName = "PartnerProjectText" )
    private String partnerProjectText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProjectText</b> field to query operations.
     *
     */
    public final static PartnerProjectField<String> PARTNER_PROJECT_TEXT =
        new PartnerProjectField<String>("PartnerProjectText");

    @Nonnull
    @Override
    public Class<PartnerProject> getType()
    {
        return PartnerProject.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProject</b>
     * </p>
     *
     * @param partnerProject
     *            Partner Project
     */
    public void setPartnerProject( @Nullable final String partnerProject )
    {
        rememberChangedField("PartnerProject", this.partnerProject);
        this.partnerProject = partnerProject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectText</b>
     * </p>
     *
     * @param partnerProjectText
     *            Partner Project (Description)
     */
    public void setPartnerProjectText( @Nullable final String partnerProjectText )
    {
        rememberChangedField("PartnerProjectText", this.partnerProjectText);
        this.partnerProjectText = partnerProjectText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerProject";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PartnerProject", getPartnerProject());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PartnerProject", getPartnerProject());
        values.put("PartnerProjectText", getPartnerProjectText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PartnerProject") ) {
                final Object value = values.remove("PartnerProject");
                if( (value == null) || (!value.equals(getPartnerProject())) ) {
                    setPartnerProject(((String) value));
                }
            }
            if( values.containsKey("PartnerProjectText") ) {
                final Object value = values.remove("PartnerProjectText");
                if( (value == null) || (!value.equals(getPartnerProjectText())) ) {
                    setPartnerProjectText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PartnerProjectField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerProjectField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerProjectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerProjectField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
