/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerProjectInternalIDField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerProjectInternalIDSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Partner Project Internal ID (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerProjectInternalID</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerProjectInternalID extends VdmEntity<PartnerProjectInternalID>
{

    /**
     * Selector for all available fields of PartnerProjectInternalID.
     *
     */
    public final static PartnerProjectInternalIDSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectInternalID_ID</b>
     * </p>
     *
     * @return Partner Project Internal ID
     */
    @Key
    @SerializedName( "PartnerProjectInternalID_ID" )
    @JsonProperty( "PartnerProjectInternalID_ID" )
    @Nullable
    @ODataField( odataName = "PartnerProjectInternalID_ID" )
    private String partnerProjectInternalID_ID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProjectInternalID_ID</b> field to query operations.
     *
     */
    public final static PartnerProjectInternalIDField<String> PARTNER_PROJECT_INTERNAL_IDID =
        new PartnerProjectInternalIDField<String>("PartnerProjectInternalID_ID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectExternalID</b>
     * </p>
     *
     * @return Partner Project External ID
     */
    @SerializedName( "PartnerProjectExternalID" )
    @JsonProperty( "PartnerProjectExternalID" )
    @Nullable
    @ODataField( odataName = "PartnerProjectExternalID" )
    private String partnerProjectExternalID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProjectExternalID</b> field to query operations.
     *
     */
    public final static PartnerProjectInternalIDField<String> PARTNER_PROJECT_EXTERNAL_ID =
        new PartnerProjectInternalIDField<String>("PartnerProjectExternalID");

    @Nonnull
    @Override
    public Class<PartnerProjectInternalID> getType()
    {
        return PartnerProjectInternalID.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectInternalID_ID</b>
     * </p>
     *
     * @param partnerProjectInternalID_ID
     *            Partner Project Internal ID
     */
    public void setPartnerProjectInternalID_ID( @Nullable final String partnerProjectInternalID_ID )
    {
        rememberChangedField("PartnerProjectInternalID_ID", this.partnerProjectInternalID_ID);
        this.partnerProjectInternalID_ID = partnerProjectInternalID_ID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectExternalID</b>
     * </p>
     *
     * @param partnerProjectExternalID
     *            Partner Project External ID
     */
    public void setPartnerProjectExternalID( @Nullable final String partnerProjectExternalID )
    {
        rememberChangedField("PartnerProjectExternalID", this.partnerProjectExternalID);
        this.partnerProjectExternalID = partnerProjectExternalID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerProjectInternalID";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PartnerProjectInternalID_ID", getPartnerProjectInternalID_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PartnerProjectInternalID_ID", getPartnerProjectInternalID_ID());
        values.put("PartnerProjectExternalID", getPartnerProjectExternalID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PartnerProjectInternalID_ID") ) {
                final Object value = values.remove("PartnerProjectInternalID_ID");
                if( (value == null) || (!value.equals(getPartnerProjectInternalID_ID())) ) {
                    setPartnerProjectInternalID_ID(((String) value));
                }
            }
            if( values.containsKey("PartnerProjectExternalID") ) {
                final Object value = values.remove("PartnerProjectExternalID");
                if( (value == null) || (!value.equals(getPartnerProjectExternalID())) ) {
                    setPartnerProjectExternalID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerProjectInternalIDField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerProjectInternalIDField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerProjectInternalIDField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerProjectInternalIDField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
