/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerSalesDocumentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerSalesDocumentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Partner Sales Doc.
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerSalesDocument</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerSalesDocument extends VdmEntity<PartnerSalesDocument>
{

    /**
     * Selector for all available fields of PartnerSalesDocument.
     *
     */
    public final static PartnerSalesDocumentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocument</b>
     * </p>
     *
     * @return Partner Sales Doc.
     */
    @Key
    @SerializedName( "PartnerSalesDocument" )
    @JsonProperty( "PartnerSalesDocument" )
    @Nullable
    @ODataField( odataName = "PartnerSalesDocument" )
    private String partnerSalesDocument;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSalesDocument</b> field to query operations.
     *
     */
    public final static PartnerSalesDocumentField<String> PARTNER_SALES_DOCUMENT =
        new PartnerSalesDocumentField<String>("PartnerSalesDocument");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocumentText</b>
     * </p>
     *
     * @return Partner Sales Doc. (Description)
     */
    @SerializedName( "PartnerSalesDocumentText" )
    @JsonProperty( "PartnerSalesDocumentText" )
    @Nullable
    @ODataField( odataName = "PartnerSalesDocumentText" )
    private String partnerSalesDocumentText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSalesDocumentText</b> field to query operations.
     *
     */
    public final static PartnerSalesDocumentField<String> PARTNER_SALES_DOCUMENT_TEXT =
        new PartnerSalesDocumentField<String>("PartnerSalesDocumentText");

    @Nonnull
    @Override
    public Class<PartnerSalesDocument> getType()
    {
        return PartnerSalesDocument.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocument</b>
     * </p>
     *
     * @param partnerSalesDocument
     *            Partner Sales Doc.
     */
    public void setPartnerSalesDocument( @Nullable final String partnerSalesDocument )
    {
        rememberChangedField("PartnerSalesDocument", this.partnerSalesDocument);
        this.partnerSalesDocument = partnerSalesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocumentText</b>
     * </p>
     *
     * @param partnerSalesDocumentText
     *            Partner Sales Doc. (Description)
     */
    public void setPartnerSalesDocumentText( @Nullable final String partnerSalesDocumentText )
    {
        rememberChangedField("PartnerSalesDocumentText", this.partnerSalesDocumentText);
        this.partnerSalesDocumentText = partnerSalesDocumentText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerSalesDocument";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PartnerSalesDocument", getPartnerSalesDocument());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PartnerSalesDocument", getPartnerSalesDocument());
        values.put("PartnerSalesDocumentText", getPartnerSalesDocumentText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PartnerSalesDocument") ) {
                final Object value = values.remove("PartnerSalesDocument");
                if( (value == null) || (!value.equals(getPartnerSalesDocument())) ) {
                    setPartnerSalesDocument(((String) value));
                }
            }
            if( values.containsKey("PartnerSalesDocumentText") ) {
                final Object value = values.remove("PartnerSalesDocumentText");
                if( (value == null) || (!value.equals(getPartnerSalesDocumentText())) ) {
                    setPartnerSalesDocumentText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerSalesDocumentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerSalesDocumentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerSalesDocumentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerSalesDocumentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
