/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerSalesDocumentSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocument PartnerSalesDocument}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class PartnerSalesDocumentByKeyFluentHelper
    extends
    FluentHelperByKey<PartnerSalesDocumentByKeyFluentHelper, PartnerSalesDocument, PartnerSalesDocumentSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocument
     * PartnerSalesDocument} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PartnerSalesDocument}
     * @param servicePath
     *            Service path to be used to fetch a single {@code PartnerSalesDocument}
     * @param partnerSalesDocument
     *            Partner Sales Doc.
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public PartnerSalesDocumentByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String partnerSalesDocument )
    {
        super(servicePath, entityCollection);
        this.key.put("PartnerSalesDocument", partnerSalesDocument);
    }

    @Override
    @Nonnull
    protected Class<PartnerSalesDocument> getEntityClass()
    {
        return PartnerSalesDocument.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
