/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerSalesDocumentItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerSalesDocumentItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Partner Sales Document Item (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerSalesDocumentItem</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerSalesDocumentItem extends VdmEntity<PartnerSalesDocumentItem>
{

    /**
     * Selector for all available fields of PartnerSalesDocumentItem.
     *
     */
    public final static PartnerSalesDocumentItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocumentItem_ID</b>
     * </p>
     *
     * @return Partner Sales Document Item
     */
    @Key
    @SerializedName( "PartnerSalesDocumentItem_ID" )
    @JsonProperty( "PartnerSalesDocumentItem_ID" )
    @Nullable
    @ODataField( odataName = "PartnerSalesDocumentItem_ID" )
    private String partnerSalesDocumentItem_ID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSalesDocumentItem_ID</b> field to query operations.
     *
     */
    public final static PartnerSalesDocumentItemField<String> PARTNER_SALES_DOCUMENT_ITEM_ID =
        new PartnerSalesDocumentItemField<String>("PartnerSalesDocumentItem_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocumentItemText</b>
     * </p>
     *
     * @return Partner Sales Document Item (Description)
     */
    @SerializedName( "PartnerSalesDocumentItemText" )
    @JsonProperty( "PartnerSalesDocumentItemText" )
    @Nullable
    @ODataField( odataName = "PartnerSalesDocumentItemText" )
    private String partnerSalesDocumentItemText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSalesDocumentItemText</b> field to query operations.
     *
     */
    public final static PartnerSalesDocumentItemField<String> PARTNER_SALES_DOCUMENT_ITEM_TEXT =
        new PartnerSalesDocumentItemField<String>("PartnerSalesDocumentItemText");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocument</b>
     * </p>
     *
     * @return Partner Sales Document Item (Partner Sales Doc.)
     */
    @Key
    @SerializedName( "PartnerSalesDocument" )
    @JsonProperty( "PartnerSalesDocument" )
    @Nullable
    @ODataField( odataName = "PartnerSalesDocument" )
    private String partnerSalesDocument;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSalesDocument</b> field to query operations.
     *
     */
    public final static PartnerSalesDocumentItemField<String> PARTNER_SALES_DOCUMENT =
        new PartnerSalesDocumentItemField<String>("PartnerSalesDocument");

    @Nonnull
    @Override
    public Class<PartnerSalesDocumentItem> getType()
    {
        return PartnerSalesDocumentItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocumentItem_ID</b>
     * </p>
     *
     * @param partnerSalesDocumentItem_ID
     *            Partner Sales Document Item
     */
    public void setPartnerSalesDocumentItem_ID( @Nullable final String partnerSalesDocumentItem_ID )
    {
        rememberChangedField("PartnerSalesDocumentItem_ID", this.partnerSalesDocumentItem_ID);
        this.partnerSalesDocumentItem_ID = partnerSalesDocumentItem_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocumentItemText</b>
     * </p>
     *
     * @param partnerSalesDocumentItemText
     *            Partner Sales Document Item (Description)
     */
    public void setPartnerSalesDocumentItemText( @Nullable final String partnerSalesDocumentItemText )
    {
        rememberChangedField("PartnerSalesDocumentItemText", this.partnerSalesDocumentItemText);
        this.partnerSalesDocumentItemText = partnerSalesDocumentItemText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocument</b>
     * </p>
     *
     * @param partnerSalesDocument
     *            Partner Sales Document Item (Partner Sales Doc.)
     */
    public void setPartnerSalesDocument( @Nullable final String partnerSalesDocument )
    {
        rememberChangedField("PartnerSalesDocument", this.partnerSalesDocument);
        this.partnerSalesDocument = partnerSalesDocument;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerSalesDocumentItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PartnerSalesDocumentItem_ID", getPartnerSalesDocumentItem_ID());
        result.put("PartnerSalesDocument", getPartnerSalesDocument());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PartnerSalesDocumentItem_ID", getPartnerSalesDocumentItem_ID());
        values.put("PartnerSalesDocumentItemText", getPartnerSalesDocumentItemText());
        values.put("PartnerSalesDocument", getPartnerSalesDocument());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PartnerSalesDocumentItem_ID") ) {
                final Object value = values.remove("PartnerSalesDocumentItem_ID");
                if( (value == null) || (!value.equals(getPartnerSalesDocumentItem_ID())) ) {
                    setPartnerSalesDocumentItem_ID(((String) value));
                }
            }
            if( values.containsKey("PartnerSalesDocumentItemText") ) {
                final Object value = values.remove("PartnerSalesDocumentItemText");
                if( (value == null) || (!value.equals(getPartnerSalesDocumentItemText())) ) {
                    setPartnerSalesDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("PartnerSalesDocument") ) {
                final Object value = values.remove("PartnerSalesDocument");
                if( (value == null) || (!value.equals(getPartnerSalesDocument())) ) {
                    setPartnerSalesDocument(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerSalesDocumentItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerSalesDocumentItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerSalesDocumentItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerSalesDocumentItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
