/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerSalesDocumentItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentItem
 * PartnerSalesDocumentItem} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class PartnerSalesDocumentItemByKeyFluentHelper
    extends
    FluentHelperByKey<PartnerSalesDocumentItemByKeyFluentHelper, PartnerSalesDocumentItem, PartnerSalesDocumentItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentItem
     * PartnerSalesDocumentItem} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param partnerSalesDocumentItem_ID
     *            Partner Sales Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PartnerSalesDocumentItem}
     * @param servicePath
     *            Service path to be used to fetch a single {@code PartnerSalesDocumentItem}
     * @param partnerSalesDocument
     *            Partner Sales Document Item (Partner Sales Doc.)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public PartnerSalesDocumentItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String partnerSalesDocumentItem_ID,
        final String partnerSalesDocument )
    {
        super(servicePath, entityCollection);
        this.key.put("PartnerSalesDocumentItem_ID", partnerSalesDocumentItem_ID);
        this.key.put("PartnerSalesDocument", partnerSalesDocument);
    }

    @Override
    @Nonnull
    protected Class<PartnerSalesDocumentItem> getEntityClass()
    {
        return PartnerSalesDocumentItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
