/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerSegmentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerSegmentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Partner Segment (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerSegment</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerSegment extends VdmEntity<PartnerSegment>
{

    /**
     * Selector for all available fields of PartnerSegment.
     *
     */
    public final static PartnerSegmentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegment_ID</b>
     * </p>
     *
     * @return Partner Segment
     */
    @Key
    @SerializedName( "PartnerSegment_ID" )
    @JsonProperty( "PartnerSegment_ID" )
    @Nullable
    @ODataField( odataName = "PartnerSegment_ID" )
    private String partnerSegment_ID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSegment_ID</b> field to query operations.
     *
     */
    public final static PartnerSegmentField<String> PARTNER_SEGMENT_ID =
        new PartnerSegmentField<String>("PartnerSegment_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegmentText</b>
     * </p>
     *
     * @return Partner Segment (Description)
     */
    @SerializedName( "PartnerSegmentText" )
    @JsonProperty( "PartnerSegmentText" )
    @Nullable
    @ODataField( odataName = "PartnerSegmentText" )
    private String partnerSegmentText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSegmentText</b> field to query operations.
     *
     */
    public final static PartnerSegmentField<String> PARTNER_SEGMENT_TEXT =
        new PartnerSegmentField<String>("PartnerSegmentText");

    @Nonnull
    @Override
    public Class<PartnerSegment> getType()
    {
        return PartnerSegment.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegment_ID</b>
     * </p>
     *
     * @param partnerSegment_ID
     *            Partner Segment
     */
    public void setPartnerSegment_ID( @Nullable final String partnerSegment_ID )
    {
        rememberChangedField("PartnerSegment_ID", this.partnerSegment_ID);
        this.partnerSegment_ID = partnerSegment_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegmentText</b>
     * </p>
     *
     * @param partnerSegmentText
     *            Partner Segment (Description)
     */
    public void setPartnerSegmentText( @Nullable final String partnerSegmentText )
    {
        rememberChangedField("PartnerSegmentText", this.partnerSegmentText);
        this.partnerSegmentText = partnerSegmentText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerSegment";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PartnerSegment_ID", getPartnerSegment_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PartnerSegment_ID", getPartnerSegment_ID());
        values.put("PartnerSegmentText", getPartnerSegmentText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PartnerSegment_ID") ) {
                final Object value = values.remove("PartnerSegment_ID");
                if( (value == null) || (!value.equals(getPartnerSegment_ID())) ) {
                    setPartnerSegment_ID(((String) value));
                }
            }
            if( values.containsKey("PartnerSegmentText") ) {
                final Object value = values.remove("PartnerSegmentText");
                if( (value == null) || (!value.equals(getPartnerSegmentText())) ) {
                    setPartnerSegmentText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PartnerSegmentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerSegmentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerSegmentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerSegmentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
