/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerWBSElementField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerWBSElementSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Partner WBS Element
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerWBSElement</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerWBSElement extends VdmEntity<PartnerWBSElement>
{

    /**
     * Selector for all available fields of PartnerWBSElement.
     *
     */
    public final static PartnerWBSElementSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElement</b>
     * </p>
     *
     * @return Partner WBS Element
     */
    @Key
    @SerializedName( "PartnerWBSElement" )
    @JsonProperty( "PartnerWBSElement" )
    @Nullable
    @ODataField( odataName = "PartnerWBSElement" )
    private String partnerWBSElement;
    /**
     * Use with available fluent helpers to apply the <b>PartnerWBSElement</b> field to query operations.
     *
     */
    public final static PartnerWBSElementField<String> PARTNER_WBS_ELEMENT =
        new PartnerWBSElementField<String>("PartnerWBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElementText</b>
     * </p>
     *
     * @return Partner WBS Element (Description)
     */
    @SerializedName( "PartnerWBSElementText" )
    @JsonProperty( "PartnerWBSElementText" )
    @Nullable
    @ODataField( odataName = "PartnerWBSElementText" )
    private String partnerWBSElementText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerWBSElementText</b> field to query operations.
     *
     */
    public final static PartnerWBSElementField<String> PARTNER_WBS_ELEMENT_TEXT =
        new PartnerWBSElementField<String>("PartnerWBSElementText");

    @Nonnull
    @Override
    public Class<PartnerWBSElement> getType()
    {
        return PartnerWBSElement.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElement</b>
     * </p>
     *
     * @param partnerWBSElement
     *            Partner WBS Element
     */
    public void setPartnerWBSElement( @Nullable final String partnerWBSElement )
    {
        rememberChangedField("PartnerWBSElement", this.partnerWBSElement);
        this.partnerWBSElement = partnerWBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElementText</b>
     * </p>
     *
     * @param partnerWBSElementText
     *            Partner WBS Element (Description)
     */
    public void setPartnerWBSElementText( @Nullable final String partnerWBSElementText )
    {
        rememberChangedField("PartnerWBSElementText", this.partnerWBSElementText);
        this.partnerWBSElementText = partnerWBSElementText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerWBSElement";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PartnerWBSElement", getPartnerWBSElement());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PartnerWBSElement", getPartnerWBSElement());
        values.put("PartnerWBSElementText", getPartnerWBSElementText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PartnerWBSElement") ) {
                final Object value = values.remove("PartnerWBSElement");
                if( (value == null) || (!value.equals(getPartnerWBSElement())) ) {
                    setPartnerWBSElement(((String) value));
                }
            }
            if( values.containsKey("PartnerWBSElementText") ) {
                final Object value = values.remove("PartnerWBSElementText");
                if( (value == null) || (!value.equals(getPartnerWBSElementText())) ) {
                    setPartnerWBSElementText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerWBSElementField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerWBSElementField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerWBSElementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerWBSElementField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
