/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerWBSElementSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElement PartnerWBSElement} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class PartnerWBSElementByKeyFluentHelper
    extends
    FluentHelperByKey<PartnerWBSElementByKeyFluentHelper, PartnerWBSElement, PartnerWBSElementSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElement PartnerWBSElement}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param partnerWBSElement
     *            Partner WBS Element
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PartnerWBSElement}
     * @param servicePath
     *            Service path to be used to fetch a single {@code PartnerWBSElement}
     */
    public PartnerWBSElementByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String partnerWBSElement )
    {
        super(servicePath, entityCollection);
        this.key.put("PartnerWBSElement", partnerWBSElement);
    }

    @Override
    @Nonnull
    protected Class<PartnerWBSElement> getEntityClass()
    {
        return PartnerWBSElement.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
