/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PartnerWBSElementInternalIDField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerWBSElementInternalIDSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Partner WBS Element Internal ID (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerWBSElementInternalID</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerWBSElementInternalID extends VdmEntity<PartnerWBSElementInternalID>
{

    /**
     * Selector for all available fields of PartnerWBSElementInternalID.
     *
     */
    public final static PartnerWBSElementInternalIDSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElementInternalID_ID</b>
     * </p>
     *
     * @return Partner WBS Element Internal ID
     */
    @Key
    @SerializedName( "PartnerWBSElementInternalID_ID" )
    @JsonProperty( "PartnerWBSElementInternalID_ID" )
    @Nullable
    @ODataField( odataName = "PartnerWBSElementInternalID_ID" )
    private String partnerWBSElementInternalID_ID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerWBSElementInternalID_ID</b> field to query operations.
     *
     */
    public final static PartnerWBSElementInternalIDField<String> PARTNER_WBS_ELEMENT_INTERNAL_IDID =
        new PartnerWBSElementInternalIDField<String>("PartnerWBSElementInternalID_ID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElementExternalID</b>
     * </p>
     *
     * @return Partner WBS Element External ID
     */
    @SerializedName( "PartnerWBSElementExternalID" )
    @JsonProperty( "PartnerWBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "PartnerWBSElementExternalID" )
    private String partnerWBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerWBSElementExternalID</b> field to query operations.
     *
     */
    public final static PartnerWBSElementInternalIDField<String> PARTNER_WBS_ELEMENT_EXTERNAL_ID =
        new PartnerWBSElementInternalIDField<String>("PartnerWBSElementExternalID");

    @Nonnull
    @Override
    public Class<PartnerWBSElementInternalID> getType()
    {
        return PartnerWBSElementInternalID.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElementInternalID_ID</b>
     * </p>
     *
     * @param partnerWBSElementInternalID_ID
     *            Partner WBS Element Internal ID
     */
    public void setPartnerWBSElementInternalID_ID( @Nullable final String partnerWBSElementInternalID_ID )
    {
        rememberChangedField("PartnerWBSElementInternalID_ID", this.partnerWBSElementInternalID_ID);
        this.partnerWBSElementInternalID_ID = partnerWBSElementInternalID_ID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElementExternalID</b>
     * </p>
     *
     * @param partnerWBSElementExternalID
     *            Partner WBS Element External ID
     */
    public void setPartnerWBSElementExternalID( @Nullable final String partnerWBSElementExternalID )
    {
        rememberChangedField("PartnerWBSElementExternalID", this.partnerWBSElementExternalID);
        this.partnerWBSElementExternalID = partnerWBSElementExternalID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerWBSElementInternalID";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PartnerWBSElementInternalID_ID", getPartnerWBSElementInternalID_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PartnerWBSElementInternalID_ID", getPartnerWBSElementInternalID_ID());
        values.put("PartnerWBSElementExternalID", getPartnerWBSElementExternalID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PartnerWBSElementInternalID_ID") ) {
                final Object value = values.remove("PartnerWBSElementInternalID_ID");
                if( (value == null) || (!value.equals(getPartnerWBSElementInternalID_ID())) ) {
                    setPartnerWBSElementInternalID_ID(((String) value));
                }
            }
            if( values.containsKey("PartnerWBSElementExternalID") ) {
                final Object value = values.remove("PartnerWBSElementExternalID");
                if( (value == null) || (!value.equals(getPartnerWBSElementExternalID())) ) {
                    setPartnerWBSElementExternalID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PartnerWBSElementInternalIDField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new PartnerWBSElementInternalIDField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerWBSElementInternalIDField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerWBSElementInternalIDField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
