/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerWBSElementInternalIDSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementInternalID
 * PartnerWBSElementInternalID} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class PartnerWBSElementInternalIDByKeyFluentHelper
    extends
    FluentHelperByKey<PartnerWBSElementInternalIDByKeyFluentHelper, PartnerWBSElementInternalID, PartnerWBSElementInternalIDSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementInternalID
     * PartnerWBSElementInternalID} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PartnerWBSElementInternalID}
     * @param servicePath
     *            Service path to be used to fetch a single {@code PartnerWBSElementInternalID}
     * @param partnerWBSElementInternalID_ID
     *            Partner WBS Element Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     */
    public PartnerWBSElementInternalIDByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String partnerWBSElementInternalID_ID )
    {
        super(servicePath, entityCollection);
        this.key.put("PartnerWBSElementInternalID_ID", partnerWBSElementInternalID_ID);
    }

    @Override
    @Nonnull
    protected Class<PartnerWBSElementInternalID> getEntityClass()
    {
        return PartnerWBSElementInternalID.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
