/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PlantField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PlantSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Plant (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>Plant</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Plant extends VdmEntity<Plant>
{

    /**
     * Selector for all available fields of Plant.
     *
     */
    public final static PlantSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant_ID</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant_ID" )
    @JsonProperty( "Plant_ID" )
    @Nullable
    @ODataField( odataName = "Plant_ID" )
    private String plant_ID;
    /**
     * Use with available fluent helpers to apply the <b>Plant_ID</b> field to query operations.
     *
     */
    public final static PlantField<String> PLANT_ID = new PlantField<String>("Plant_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlantText</b>
     * </p>
     *
     * @return Plant (Description)
     */
    @SerializedName( "PlantText" )
    @JsonProperty( "PlantText" )
    @Nullable
    @ODataField( odataName = "PlantText" )
    private String plantText;
    /**
     * Use with available fluent helpers to apply the <b>PlantText</b> field to query operations.
     *
     */
    public final static PlantField<String> PLANT_TEXT = new PlantField<String>("PlantText");

    @Nonnull
    @Override
    public Class<Plant> getType()
    {
        return Plant.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant_ID</b>
     * </p>
     *
     * @param plant_ID
     *            Plant
     */
    public void setPlant_ID( @Nullable final String plant_ID )
    {
        rememberChangedField("Plant_ID", this.plant_ID);
        this.plant_ID = plant_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlantText</b>
     * </p>
     *
     * @param plantText
     *            Plant (Description)
     */
    public void setPlantText( @Nullable final String plantText )
    {
        rememberChangedField("PlantText", this.plantText);
        this.plantText = plantText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Plant";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Plant_ID", getPlant_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Plant_ID", getPlant_ID());
        values.put("PlantText", getPlantText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Plant_ID") ) {
                final Object value = values.remove("Plant_ID");
                if( (value == null) || (!value.equals(getPlant_ID())) ) {
                    setPlant_ID(((String) value));
                }
            }
            if( values.containsKey("PlantText") ) {
                final Object value = values.remove("PlantText");
                if( (value == null) || (!value.equals(getPlantText())) ) {
                    setPlantText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PlantField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PlantField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PlantField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PlantField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
