/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PostingKeyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PostingKeySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Posting Key (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PostingKey</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PostingKey extends VdmEntity<PostingKey>
{

    /**
     * Selector for all available fields of PostingKey.
     *
     */
    public final static PostingKeySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingKey_ID</b>
     * </p>
     *
     * @return Posting Key
     */
    @Key
    @SerializedName( "PostingKey_ID" )
    @JsonProperty( "PostingKey_ID" )
    @Nullable
    @ODataField( odataName = "PostingKey_ID" )
    private String postingKey_ID;
    /**
     * Use with available fluent helpers to apply the <b>PostingKey_ID</b> field to query operations.
     *
     */
    public final static PostingKeyField<String> POSTING_KEY_ID = new PostingKeyField<String>("PostingKey_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PostingKeyText</b>
     * </p>
     *
     * @return Posting Key (Description)
     */
    @SerializedName( "PostingKeyText" )
    @JsonProperty( "PostingKeyText" )
    @Nullable
    @ODataField( odataName = "PostingKeyText" )
    private String postingKeyText;
    /**
     * Use with available fluent helpers to apply the <b>PostingKeyText</b> field to query operations.
     *
     */
    public final static PostingKeyField<String> POSTING_KEY_TEXT = new PostingKeyField<String>("PostingKeyText");

    @Nonnull
    @Override
    public Class<PostingKey> getType()
    {
        return PostingKey.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingKey_ID</b>
     * </p>
     *
     * @param postingKey_ID
     *            Posting Key
     */
    public void setPostingKey_ID( @Nullable final String postingKey_ID )
    {
        rememberChangedField("PostingKey_ID", this.postingKey_ID);
        this.postingKey_ID = postingKey_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PostingKeyText</b>
     * </p>
     *
     * @param postingKeyText
     *            Posting Key (Description)
     */
    public void setPostingKeyText( @Nullable final String postingKeyText )
    {
        rememberChangedField("PostingKeyText", this.postingKeyText);
        this.postingKeyText = postingKeyText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PostingKey";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PostingKey_ID", getPostingKey_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PostingKey_ID", getPostingKey_ID());
        values.put("PostingKeyText", getPostingKeyText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PostingKey_ID") ) {
                final Object value = values.remove("PostingKey_ID");
                if( (value == null) || (!value.equals(getPostingKey_ID())) ) {
                    setPostingKey_ID(((String) value));
                }
            }
            if( values.containsKey("PostingKeyText") ) {
                final Object value = values.remove("PostingKeyText");
                if( (value == null) || (!value.equals(getPostingKeyText())) ) {
                    setPostingKeyText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PostingKeyField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PostingKeyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PostingKeyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PostingKeyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
